/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.datesearch;

import com.vaadin.data.HasValue;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.TextField;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.CmsDateRangeRestriction;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.lists.CmsListManager;
import org.opencms.ui.apps.lists.CmsResultTable;
import org.opencms.ui.components.CmsAvailabilitySelector;
import org.opencms.ui.components.CmsComponentState;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.components.CmsFolderSelector;
import org.opencms.ui.components.CmsResourceTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.CmsResultFacets;
import org.opencms.ui.components.CmsResultFilterComponent;
import org.opencms.ui.components.CmsSiteSelector;
import org.opencms.ui.components.CmsTypeSelector;
import org.opencms.ui.components.I_CmsResultFacetsManager;
import org.opencms.ui.contextmenu.CmsResourceContextMenuBuilder;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsDateSearchComposite
implements CmsResourceTable.I_ResourcePropertyProvider,
I_CmsResultFacetsManager {
    static final Log LOG = CmsLog.getLog(CmsDateSearchComposite.class);
    static final int MAX_RESULTS = 5000;
    FilterComponent m_filterComponent = new FilterComponent();
    ResultComponent m_resultComponent;
    CmsResultFilterComponent m_resultFilterComponent;

    public CmsDateSearchComposite() {
        this.m_filterComponent.updateTypeSelector();
        this.m_resultComponent = new ResultComponent();
        this.m_resultFilterComponent = new ResultFilterComponent();
        this.connectComponents();
        this.m_resultComponent.showInfoEmptyType();
    }

    @Override
    public void addItemProperties(Item resourceItem, CmsObject cms, CmsResource resource, Locale locale) {
        List<String> contentLocales;
        CmsResourceUtil resUtil;
        String title;
        if (resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TITLE) != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(title = (resUtil = new CmsResourceUtil(cms, resource)).getGalleryTitle(locale))) {
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TITLE).setValue((Object)title);
        }
        if (resource instanceof CmsSearchResource && resourceItem.getItemProperty((Object)CmsListManager.INSTANCEDATE_PROPERTY) != null && (contentLocales = ((CmsSearchResource)resource).getDocument().getMultivaluedFieldAsStringList("con_locales")) != null) {
            for (String contentLocale : contentLocales) {
                String dateFieldKey = "instancedate_" + contentLocale + "_dt";
                Date date = ((CmsSearchResource)resource).getDateField(dateFieldKey);
                if (date == null) continue;
                resourceItem.getItemProperty((Object)CmsListManager.INSTANCEDATE_PROPERTY).setValue((Object)date);
            }
        }
    }

    public Component getFilterComponent() {
        return this.m_filterComponent;
    }

    public Component getResultComponent() {
        return this.m_resultComponent;
    }

    public Component getResultFilterComponent() {
        return this.m_resultFilterComponent;
    }

    public void search(boolean updateState, boolean resetSelectedFacets) {
        if (resetSelectedFacets) {
            this.m_filterComponent.m_resultFacets.resetFacets();
            this.m_filterComponent.m_resultFacets.setVisible(false);
        }
        if (updateState) {
            CmsComponentState componentState = new CmsComponentState();
            componentState.setSite((String)this.m_filterComponent.m_siteSelector.getValue());
            componentState.setFolder(this.m_filterComponent.m_folderSelector.getValue());
            componentState.setResourceType((I_CmsResourceType)this.m_filterComponent.m_typeSelector.getValue());
            componentState.setDateFrom(this.m_filterComponent.m_dateFrom.getDate());
            componentState.setDateTo(this.m_filterComponent.m_dateTo.getDate());
            componentState.setAvailability((String)((CmsPair)this.m_filterComponent.m_availabilitySelector.getValue()).getFirst());
            componentState.setQuery(this.m_filterComponent.m_textSearchField.getValue());
            componentState.setCategory(this.m_filterComponent.getSelectedCategory());
            CmsAppWorkplaceUi.get().changeCurrentAppState(componentState.generateStateString());
        }
        if (this.m_filterComponent.m_typeSelector.getValue() == null) {
            this.m_resultComponent.showInfoEmptyType();
        } else {
            CmsSolrResultList solrResultList = this.search(null);
            ArrayList<CmsResource> results = new ArrayList<CmsResource>(solrResultList);
            if (results.isEmpty()) {
                this.m_resultComponent.showInfoEmptyResult();
            } else {
                this.m_resultComponent.updateResultTable(results);
                HashMap<String, Boolean> checkedCategoryFacets = new HashMap<String, Boolean>();
                if (!this.m_filterComponent.m_resultFacets.getSelectedFieldFacets().isEmpty()) {
                    checkedCategoryFacets.put(this.m_filterComponent.m_resultFacets.getSelectedFieldFacets().get("category_exact").get(0), Boolean.TRUE);
                }
                this.m_filterComponent.m_resultFacets.displayFacetResult(solrResultList, checkedCategoryFacets, null, null, this.getCmsObject());
                this.m_filterComponent.m_resultFacets.setVisible(true);
            }
        }
    }

    @Override
    public void search(Map<String, List<String>> fieldFacets, Map<String, List<String>> rangeFacets) {
        this.search(true, false);
    }

    public void setState(CmsComponentState componentState) {
        this.m_filterComponent.m_siteSelector.setValue(componentState.getSite());
        this.m_filterComponent.m_folderSelector.setValue(componentState.getFolder());
        this.m_filterComponent.m_typeSelector.setValue(componentState.getResourceType());
        this.m_filterComponent.m_dateFrom.setDate(componentState.getDateFrom());
        this.m_filterComponent.m_dateTo.setDate(componentState.getDateTo());
        this.m_filterComponent.m_availabilitySelector.setValue(this.m_filterComponent.m_availabilitySelector.getOption(componentState.getAvailability()));
        if (componentState.getCategory() != null) {
            this.m_filterComponent.m_resultFacets.selectFieldFacet("category_exact", componentState.getCategory());
        }
        this.m_filterComponent.m_textSearchField.setValue(componentState.getQuery());
    }

    List<I_CmsResourceType> getAvailableTypes() {
        CmsSolrResultList solrResultList = this.search(0);
        ArrayList<I_CmsResourceType> result = new ArrayList<I_CmsResourceType>();
        for (FacetField.Count count : solrResultList.getFacetField("type").getValues()) {
            String typeName = count.getName();
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            if (typeSetting == null) continue;
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeName);
                result.add(resourceType);
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    CmsObject getCmsObject() {
        if (this.m_filterComponent == null || this.m_filterComponent.m_folderSelector == null) {
            return A_CmsUI.getCmsObject();
        }
        CmsObject folderSelectorCms = this.m_filterComponent.m_folderSelector.getCmsObject();
        return folderSelectorCms == null ? A_CmsUI.getCmsObject() : folderSelectorCms;
    }

    private CmsSolrQuery buildQuery() {
        String textSearch;
        List<String> checkedCategories;
        CmsSolrQuery query = new CmsSolrQuery(this.getCmsObject(), null);
        query.setSort("path", SolrQuery.ORDER.asc);
        query.addFacetField(new String[]{"type"});
        query.addFacetField(new String[]{"con_locales"});
        query.addFacetField(new String[]{"{!ex=ce}category_exact"});
        query.setFacetMinCount(1);
        ArrayList<Object> filterQueries = new ArrayList<Object>();
        filterQueries.add("con_locales:*");
        Object site = (String)this.m_filterComponent.m_siteSelector.getValue();
        String folder = this.m_filterComponent.m_folderSelector.getValue();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(folder)) {
            String path = CmsStringUtil.joinPaths(new String[]{site, folder});
            filterQueries.add("parent-folders:\"" + path + "\"");
        } else {
            if (site != null) {
                site = ((String)site).endsWith("/") ? site : (String)site + "/";
            }
            filterQueries.add("parent-folders:\"" + (String)site + "\"");
        }
        I_CmsResourceType type = (I_CmsResourceType)this.m_filterComponent.m_typeSelector.getValue();
        if (type != null) {
            filterQueries.add("type:" + type.getTypeName());
        }
        Date dateFrom = this.m_filterComponent.m_dateFrom.getDate();
        Date dateTo = this.m_filterComponent.m_dateTo.getDate();
        String dateRangeQuery = null;
        if (dateFrom != null || dateTo != null) {
            ArrayList<CallSite> dateRangeQueries = new ArrayList<CallSite>();
            List<Locale> availableLocales = OpenCms.getLocaleManager().getAvailableLocales(this.getCmsObject(), folder);
            for (Locale locale : availableLocales) {
                CmsDateRangeRestriction restriction = new CmsDateRangeRestriction(dateFrom, dateTo);
                dateRangeQueries.add((CallSite)((Object)("instancedatecurrenttill_" + locale + "_dt:" + restriction.getRange())));
            }
            dateRangeQuery = "(" + String.join((CharSequence)" OR ", dateRangeQueries) + ")";
            filterQueries.add(dateRangeQuery);
        }
        if (!filterQueries.isEmpty()) {
            if (this.m_filterComponent.m_availabilitySelector.isOptionWithout()) {
                query.setFilterQueries(new String[]{String.join((CharSequence)" AND ", filterQueries)});
            } else if (this.m_filterComponent.m_availabilitySelector.isOptionOnly()) {
                Date now = new Date();
                CmsDateRangeRestriction releasedRestriction = new CmsDateRangeRestriction(now, null);
                CmsDateRangeRestriction expiredRestriction = new CmsDateRangeRestriction(null, now);
                String releasedQuery = "released:" + releasedRestriction.getRange();
                String expiredQuery = "expired:" + expiredRestriction.getRange();
                String releasedOrExpiredQuery = releasedQuery + " OR " + expiredQuery;
                String expiredOrReleasedQuery = expiredQuery + " OR " + releasedQuery;
                query.setFilterQueries(new String[]{String.join((CharSequence)" AND ", filterQueries), releasedOrExpiredQuery, expiredOrReleasedQuery});
            } else {
                String releasedQuery = "released:[* TO *]";
                String expiredQuery = "expired:[* TO *]";
                query.setFilterQueries(new String[]{String.join((CharSequence)" AND ", filterQueries), releasedQuery, expiredQuery});
            }
        }
        if ((checkedCategories = this.m_filterComponent.m_resultFacets.getSelectedFieldFacets().get("category_exact")) != null && !checkedCategories.isEmpty()) {
            query.addFilterQuery(new String[]{"{!tag=ce}category_exact:\"" + checkedCategories.get(0) + "\""});
        }
        String string = textSearch = this.m_resultFilterComponent == null ? null : this.m_filterComponent.m_textSearchField.getValue();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(textSearch)) {
            query.setQuery(ClientUtils.escapeQueryChars((String)textSearch));
        }
        return query;
    }

    private void connectComponents() {
        this.m_filterComponent.m_siteSelector.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent arg0) {
                try {
                    CmsObject newCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    newCms.getRequestContext().setSiteRoot((String)CmsDateSearchComposite.this.m_filterComponent.m_siteSelector.getValue());
                    CmsDateSearchComposite.this.m_filterComponent.m_folderSelector.setCmsObject(newCms);
                    CmsDateSearchComposite.this.m_filterComponent.m_folderSelector.setValue("/");
                    CmsDateSearchComposite.this.m_filterComponent.updateTypeSelector();
                    CmsDateSearchComposite.this.m_filterComponent.m_dateFrom.setValue(null);
                    CmsDateSearchComposite.this.m_filterComponent.m_dateTo.setValue(null);
                    CmsDateSearchComposite.this.m_filterComponent.m_availabilitySelector.reset();
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
        this.m_filterComponent.m_folderSelector.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                CmsDateSearchComposite.this.m_filterComponent.updateTypeSelector();
                CmsDateSearchComposite.this.m_filterComponent.m_dateFrom.setValue(null);
                CmsDateSearchComposite.this.m_filterComponent.m_dateTo.setValue(null);
                CmsDateSearchComposite.this.m_filterComponent.m_availabilitySelector.reset();
            }
        });
    }

    private CmsSolrResultList search(Integer rows) {
        CmsSolrQuery query = this.buildQuery();
        boolean online = this.getCmsObject().getRequestContext().getCurrentProject().isOnlineProject();
        String indexName = online ? "Solr Online" : "Solr Offline";
        CmsSolrIndex index = OpenCms.getSearchManager().getIndexSolr(indexName);
        query.setRows(rows == null ? Integer.valueOf(5000) : rows);
        try {
            return index.search(this.getCmsObject(), query, true, null, true, CmsResourceFilter.ALL, 5000);
        }
        catch (CmsSearchException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private class FilterComponent
    extends VerticalLayout {
        CmsSiteSelector m_siteSelector;
        CmsFolderSelector m_folderSelector;
        CmsTypeSelector m_typeSelector;
        CmsDateField m_dateFrom;
        CmsDateField m_dateTo;
        CmsAvailabilitySelector m_availabilitySelector;
        CmsResultFacets m_resultFacets;
        FormLayout m_formLayout;
        TextField m_textSearchField;

        FilterComponent() {
            this.setMargin(true);
            this.setSpacing(true);
            this.m_formLayout = new FormLayout();
            this.m_formLayout.setMargin(true);
            this.m_formLayout.setSpacing(true);
            this.m_formLayout.addStyleName("o-formlayout-narrow");
            this.initSiteSelector();
            this.initFolderSelector();
            this.initTypeSelector();
            this.initDateFrom();
            this.initDateTo();
            this.initTextSearchField();
            this.initExpiredSelector();
            this.initResultFacets();
            this.m_formLayout.addComponent((Component)new VerticalLayout());
            this.addComponent((Component)this.m_formLayout);
        }

        String getSelectedCategory() {
            List<String> categories = this.m_resultFacets.getSelectedFieldFacets().get("category_exact");
            if (categories != null && !categories.isEmpty()) {
                return categories.get(0);
            }
            return null;
        }

        void updateTypeSelector() {
            this.m_typeSelector.updateTypes(CmsDateSearchComposite.this.getAvailableTypes());
        }

        private void initDateFrom() {
            this.m_dateFrom = new CmsDateField();
            this.m_dateFrom.setWidthFull();
            String caption = CmsVaadinUtils.getMessageText("GUI_DATE_SEARCH_DATE_FROM_0", new Object[0]);
            this.m_dateFrom.setCaption(caption);
            this.m_dateFrom.setResolution((Enum)DateTimeResolution.DAY);
            this.m_dateFrom.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<LocalDateTime>(){

                public void valueChange(HasValue.ValueChangeEvent<LocalDateTime> event) {
                    CmsDateSearchComposite.this.search(true, true);
                }
            });
            this.m_formLayout.addComponent((Component)this.m_dateFrom);
        }

        private void initDateTo() {
            this.m_dateTo = new CmsDateField();
            this.m_dateTo.setWidthFull();
            String caption = CmsVaadinUtils.getMessageText("GUI_DATE_SEARCH_DATE_TO_0", new Object[0]);
            this.m_dateTo.setCaption(caption);
            this.m_dateTo.setResolution((Enum)DateTimeResolution.DAY);
            this.m_dateTo.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<LocalDateTime>(){

                public void valueChange(HasValue.ValueChangeEvent<LocalDateTime> event) {
                    CmsDateSearchComposite.this.search(true, true);
                }
            });
            this.m_formLayout.addComponent((Component)this.m_dateTo);
        }

        private void initExpiredSelector() {
            this.m_availabilitySelector = new CmsAvailabilitySelector();
            this.m_availabilitySelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> CmsDateSearchComposite.this.search(true, true));
            this.m_formLayout.addComponent((Component)this.m_availabilitySelector);
        }

        private void initFolderSelector() {
            this.m_folderSelector = new CmsFolderSelector();
            this.m_folderSelector.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    CmsDateSearchComposite.this.search(true, true);
                }
            });
            this.m_formLayout.addComponent((Component)this.m_folderSelector);
        }

        private void initResultFacets() {
            this.m_resultFacets = new CmsResultFacets(CmsDateSearchComposite.this);
            this.m_resultFacets.setWidthFull();
            this.m_resultFacets.setMargin(false);
            this.m_resultFacets.setSpacing(true);
            this.m_formLayout.addComponent((Component)this.m_resultFacets);
        }

        private void initSiteSelector() {
            this.m_siteSelector = new CmsSiteSelector();
            this.m_siteSelector.setWidthFull();
            this.m_siteSelector.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> CmsDateSearchComposite.this.search(true, true));
            this.m_formLayout.addComponent((Component)this.m_siteSelector);
        }

        private void initTextSearchField() {
            this.m_textSearchField = new TextField();
            this.m_textSearchField.setCaption(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_SEARCH_0", new Object[0]));
            this.m_textSearchField.setWidthFull();
            this.m_textSearchField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> CmsDateSearchComposite.this.search(true, true));
            this.m_formLayout.addComponent((Component)this.m_textSearchField);
        }

        private void initTypeSelector() {
            this.m_typeSelector = new CmsTypeSelector();
            this.m_typeSelector.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> CmsDateSearchComposite.this.search(true, true));
            this.m_formLayout.addComponent((Component)this.m_typeSelector);
        }
    }

    private class ResultComponent
    extends VerticalLayout {
        VerticalLayout m_infoEmptyType;
        VerticalLayout m_infoEmptyResult;
        CmsResultTable m_resultTable;

        ResultComponent() {
            this.setSizeFull();
            this.initInfoEmptyType();
            this.initInfoEmptyResult();
            this.initResultTable();
        }

        void showInfoEmptyResult() {
            this.m_resultTable.setVisible(false);
            this.m_infoEmptyType.setVisible(false);
            this.m_infoEmptyResult.setVisible(true);
        }

        void showInfoEmptyType() {
            this.m_infoEmptyResult.setVisible(false);
            this.m_resultTable.setVisible(false);
            this.m_infoEmptyType.setVisible(true);
        }

        void updateResultTable(List<CmsResource> resources) {
            this.m_infoEmptyType.setVisible(false);
            this.m_infoEmptyResult.setVisible(false);
            this.m_resultTable.fillTable(CmsDateSearchComposite.this.getCmsObject(), resources, true, false, true);
            this.m_resultTable.setVisible(true);
        }

        private void initInfoEmptyResult() {
            this.m_infoEmptyResult = CmsVaadinUtils.getInfoLayout("GUI_DATE_SEARCH_EMPTY_RESULT_0");
            this.m_infoEmptyResult.setVisible(false);
            this.addComponent((Component)this.m_infoEmptyResult);
        }

        private void initInfoEmptyType() {
            this.m_infoEmptyType = CmsVaadinUtils.getInfoLayout("GUI_DATE_SEARCH_EMPTY_TYPE_0");
            this.m_infoEmptyType.setVisible(false);
            this.addComponent((Component)this.m_infoEmptyType);
        }

        private void initResultTable() {
            LinkedHashMap<CmsResourceTableProperty, Integer> tableColumns = new LinkedHashMap<CmsResourceTableProperty, Integer>();
            for (Map.Entry<CmsResourceTableProperty, Integer> columnsEntry : CmsFileTable.DEFAULT_TABLE_PROPERTIES.entrySet()) {
                if (columnsEntry.getKey().equals(CmsResourceTableProperty.PROPERTY_RESOURCE_TYPE)) {
                    tableColumns.put(CmsListManager.INSTANCEDATE_PROPERTY, 0);
                }
                tableColumns.put(columnsEntry.getKey(), columnsEntry.getValue());
            }
            this.m_resultTable = new CmsResultTable(null, tableColumns){

                @Override
                public void applyWorkplaceAppSettings() {
                    super.applyWorkplaceAppSettings();
                    this.m_fileTable.setColumnCollapsed((Object)CmsResourceTableProperty.PROPERTY_SIZE, true);
                    this.m_fileTable.setColumnCollapsed((Object)CmsResourceTableProperty.PROPERTY_DATE_MODIFIED, true);
                    this.m_fileTable.setColumnCollapsed((Object)CmsListManager.INSTANCEDATE_PROPERTY, false);
                }

                @Override
                public void filterTable(String search) {
                    this.m_container.removeAllContainerFilters();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
                        this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_SITE_PATH, search, true, false), new SimpleStringFilter((Object)CmsResourceTableProperty.PROPERTY_TITLE, search, true, false)}));
                    }
                    if (this.m_fileTable.getValue() != null & !((Set)this.m_fileTable.getValue()).isEmpty()) {
                        this.m_fileTable.setCurrentPageFirstItemId(((Set)this.m_fileTable.getValue()).iterator().next());
                    }
                }
            };
            this.m_resultTable.applyWorkplaceAppSettings();
            this.m_resultTable.addPropertyProvider(CmsDateSearchComposite.this);
            this.m_resultTable.setContextProvider(new I_CmsContextProvider(){

                @Override
                public I_CmsDialogContext getDialogContext() {
                    CmsFileTableDialogContext context = new CmsFileTableDialogContext("date-search", I_CmsDialogContext.ContextType.fileTable, ResultComponent.this.m_resultTable, ResultComponent.this.m_resultTable.getSelectedResources()){

                        @Override
                        public void finish(Collection<CmsUUID> ids) {
                            if (ResultComponent.this.m_resultTable.getSelectedItems() == null) {
                                super.finish(ids);
                            } else {
                                String itemId = ResultComponent.this.m_resultTable.getCurrentPageFirstItemId();
                                CmsDateSearchComposite.this.search(false, false);
                                ResultComponent.this.m_resultTable.setCurrentPageFirstItemId(itemId);
                                this.closeWindow();
                            }
                        }
                    };
                    return context;
                }
            });
            this.m_resultTable.addAdditionalStyleGenerator(new Table.CellStyleGenerator(){

                public String getStyle(Table source, Object itemId, Object propertyId) {
                    Object style = "";
                    Item item = source.getItem(itemId);
                    if (CmsResourceTableProperty.PROPERTY_TITLE.equals(propertyId) && (item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED) == null || ((Boolean)item.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RELEASED_NOT_EXPIRED).getValue()).booleanValue())) {
                        style = (String)style + "o-in-navigation ";
                    }
                    return style;
                }
            });
            this.m_resultTable.setSizeFull();
            this.m_resultTable.setMenuBuilder(new CmsResourceContextMenuBuilder());
            this.m_resultTable.setVisible(false);
            this.addComponent((Component)this.m_resultTable);
        }
    }

    private class ResultFilterComponent
    extends CmsResultFilterComponent {
        ResultFilterComponent() {
            this.addTextChangeListener(new FieldEvents.TextChangeListener(){

                public void textChange(FieldEvents.TextChangeEvent event) {
                    CmsDateSearchComposite.this.m_resultComponent.m_resultTable.filterTable(event.getText());
                }
            });
        }
    }
}

