/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.TextField;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.CmsPropertyTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsStringUtil;

public class CmsAddPropertyDefinitionDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -5454565964997277536L;
    protected TextField m_newProperty;
    private Button m_ok;
    private Button m_cancel;

    public CmsAddPropertyDefinitionDialog(final Window window, final CmsPropertyTable table) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -7356827828386377748L;

            public void buttonClick(Button.ClickEvent event) {
                CmsAddPropertyDefinitionDialog.this.m_newProperty.removeAllValidators();
                CmsAddPropertyDefinitionDialog.this.m_newProperty.addValidator((Validator)new PropertyExistValidator());
                if (CmsAddPropertyDefinitionDialog.this.m_newProperty.isValid()) {
                    CmsAddPropertyDefinitionDialog.this.saveProperty();
                    table.init();
                    window.close();
                }
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -3198675226086758775L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
    }

    protected void saveProperty() {
        try {
            A_CmsUI.getCmsObject().createPropertyDefinition((String)this.m_newProperty.getValue());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    class PropertyExistValidator
    implements Validator {
        private static final long serialVersionUID = -2500052661735259675L;

        PropertyExistValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_VALIDATION_EMPTY_0", new Object[0]));
            }
            String propName = (String)value;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(propName)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_VALIDATION_EMPTY_0", new Object[0]));
            }
            try {
                if (A_CmsUI.getCmsObject().readPropertyDefinition(propName) != null) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_VALIDATION_ALREADY_EXIST_0", new Object[0]));
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            try {
                CmsPropertyDefinition.checkPropertyName(propName);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_PROPERTY_VALIDATION_NOTVALID_0", new Object[0]));
            }
        }
    }
}

