/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockType;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.apps.Messages;

public class CmsRemovePubLocksThread
extends A_CmsReportThread {
    private Throwable m_error;
    private List<String> m_resources;

    public CmsRemovePubLocksThread(CmsObject cms, List<String> resources) {
        super(cms, Messages.get().getBundle().key("GUI_DB_PUBLOCKS_THREAD_NAME_0"));
        this.m_resources = new ArrayList<String>(resources);
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    @Override
    public Throwable getError() {
        return this.m_error;
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        try {
            this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_BEGIN_0"), 2);
            CmsObject cms = this.getCms();
            CmsLockFilter filter = CmsLockFilter.FILTER_ALL;
            filter = filter.filterType(CmsLockType.PUBLISH);
            for (String paramResName : this.m_resources) {
                this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_READLOCKS_1", paramResName), 3);
                for (String resName : cms.getLockedResources(paramResName, filter)) {
                    if (!cms.existsResource(resName, CmsResourceFilter.ALL)) {
                        this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_UNLOCKING_1", resName), 0);
                        OpenCms.getMemoryMonitor().uncacheLock(cms.getRequestContext().addSiteRoot(resName));
                        continue;
                    }
                    for (CmsResource res : cms.readSiblings(resName, CmsResourceFilter.ALL)) {
                        this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_UNLOCKING_1", cms.getSitePath(res)), 0);
                        OpenCms.getMemoryMonitor().uncacheLock(res.getRootPath());
                    }
                }
            }
            this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_END_0"), 2);
        }
        catch (Throwable exc) {
            this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_FAILED_0"), 1);
            this.getReport().println(exc);
            this.m_error = exc;
        }
    }
}

