/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.filehistory;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.filehistory.CmsHistoryClearThread;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.report.CmsReportDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFileHistoryPanel
extends VerticalLayout {
    private static final Log LOG = CmsLog.getLog(CmsFileHistoryPanel.class);
    private static final long serialVersionUID = 1484327372474823882L;
    private static final int VERSIONS_MAX = 50;
    protected Button m_cleanupPublishHistory;
    ComboBox m_numberVersionsToKeep;
    private CmsDateField m_dateField;
    private OptionGroup m_deleteMode;
    private Button m_ok;
    private Panel m_optionPanel;
    private Label m_settedVersions;
    private Button m_edit;
    private OptionGroup m_mode;
    private ComboBox m_numberVersions;

    public CmsFileHistoryPanel() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.setupVersionSettingsLabel();
        this.setupVersionsToKeepComboBox();
        this.setupDeleteModeOptions();
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -6314367378702836242L;

            public void buttonClick(Button.ClickEvent event) {
                CmsFileHistoryPanel.this.startCleanAndShowReport();
            }
        });
        this.m_cleanupPublishHistory.addClickListener((Button.ClickListener & Serializable)evt -> this.runPublishHistoryCleanup());
        this.m_edit.setEnabled(false);
        this.setupVersionComboBox();
        this.setupModeOptions();
        Property.ValueChangeListener changeListener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = -6003215873244541851L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsFileHistoryPanel.this.setButtonEnabled(true);
            }
        };
        this.m_numberVersions.addValueChangeListener(changeListener);
        this.m_mode.addValueChangeListener(changeListener);
        this.m_edit.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 161296255232053110L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsFileHistoryPanel.this.saveOptions()) {
                    CmsFileHistoryPanel.this.setButtonEnabled(false);
                } else {
                    String message = CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_INVALID_0", new Object[0]);
                    Notification.show((String)message, (Notification.Type)Notification.Type.ERROR_MESSAGE);
                }
            }
        });
    }

    protected void setButtonEnabled(boolean enable) {
        this.m_edit.setEnabled(enable);
    }

    boolean saveOptions() {
        int versions;
        boolean enabled = ((ComboBoxVersionsBean)this.m_numberVersions.getValue()).getValue() != -2;
        int versionsDeleted = versions = ((ComboBoxVersionsBean)this.m_numberVersions.getValue()).getValue();
        if (this.m_mode.getValue().equals("disabled")) {
            versionsDeleted = 0;
        }
        if (this.m_mode.getValue().equals("withoutversions")) {
            versionsDeleted = 1;
        }
        if (this.m_mode.getValue().equals("withversions") && versions == -2) {
            return false;
        }
        OpenCms.getSystemInfo().setVersionHistorySettings(enabled, versions, versionsDeleted);
        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
        return true;
    }

    void startCleanAndShowReport() {
        A_CmsReportThread thread = this.makeThread();
        String title = CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_CLEAR_REPORT_TITLE_0", new Object[0]);
        CmsReportDialog.showReportDialog(title, thread);
    }

    private A_CmsReportThread makeThread() {
        int versions;
        int versionsDeleted = versions = ((Integer)this.m_numberVersionsToKeep.getValue()).intValue();
        if (this.m_deleteMode.getValue().equals("disabled")) {
            versionsDeleted = 0;
        }
        if (this.m_deleteMode.getValue().equals("withoutversions")) {
            versionsDeleted = 1;
        }
        long date = this.m_dateField.getValue() != null ? this.m_dateField.getDate().getTime() : 0L;
        CmsHistoryClearThread thread = new CmsHistoryClearThread(A_CmsUI.getCmsObject(), versions, versionsDeleted, date);
        return thread;
    }

    private void runPublishHistoryCleanup() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            int numRemoved = OpenCms.getPublishManager().cleanupPublishHistory(cms);
            Notification notification = new Notification(CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_CLEANED_PUBLISH_HISTORY_1", numRemoved), Notification.Type.HUMANIZED_MESSAGE);
            notification.setDelayMsec(-1);
            notification.show(A_CmsUI.get().getPage());
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    private void setupDeleteModeOptions() {
        int versionsDeleted = OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion();
        String mode = versionsDeleted == 0 ? "disabled" : (versionsDeleted == 1 ? "withoutversions" : (versionsDeleted > 1 || versionsDeleted == -1 ? "withversions" : "disabled"));
        this.m_deleteMode.setValue((Object)mode);
    }

    private void setupModeOptions() {
        int versionsDeleted = OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion();
        String mode = versionsDeleted == 0 ? "disabled" : (versionsDeleted == 1 ? "withoutversions" : (versionsDeleted > 1 || versionsDeleted == -1 ? "withversions" : "disabled"));
        this.m_mode.setValue((Object)mode);
    }

    private void setupVersionComboBox() {
        int i;
        ArrayList<ComboBoxVersionsBean> beans = new ArrayList<ComboBoxVersionsBean>();
        beans.add(new ComboBoxVersionsBean(-2));
        for (i = 1; i <= 10; ++i) {
            beans.add(new ComboBoxVersionsBean(i));
        }
        for (i = 15; i <= 50; i += 5) {
            beans.add(new ComboBoxVersionsBean(i));
        }
        beans.add(new ComboBoxVersionsBean(-1));
        BeanItemContainer objects = new BeanItemContainer(ComboBoxVersionsBean.class, beans);
        this.m_numberVersions.setContainerDataSource((Container)objects);
        this.m_numberVersions.setItemCaptionPropertyId((Object)"displayValue");
        this.m_numberVersions.setNullSelectionAllowed(false);
        this.m_numberVersions.setTextInputAllowed(false);
        this.m_numberVersions.setPageLength(beans.size());
        int numberHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        this.m_numberVersions.setValue(beans.get(beans.indexOf(new ComboBoxVersionsBean(numberHistoryVersions))));
    }

    private void setupVersionSettingsLabel() {
        int numberHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        String numberString = String.valueOf(numberHistoryVersions);
        if (numberHistoryVersions == -2) {
            numberString = CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_DISABLED_0", new Object[0]);
        }
        if (numberHistoryVersions == -1) {
            numberString = CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_UNLIMITED_0", new Object[0]);
        }
        this.m_settedVersions.setContentMode(ContentMode.HTML);
        this.m_settedVersions.setValue(CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_DELETE_VERSIONINFO_1", numberString));
    }

    private void setupVersionsToKeepComboBox() {
        int i;
        final ArrayList<Integer> items = new ArrayList<Integer>();
        for (i = 0; i < 10; ++i) {
            this.m_numberVersionsToKeep.addItem((Object)i);
            items.add(i);
        }
        for (i = 10; i <= 50; i += 5) {
            this.m_numberVersionsToKeep.addItem((Object)i);
            items.add(i);
        }
        this.m_numberVersionsToKeep.setPageLength(this.m_numberVersionsToKeep.size());
        this.m_numberVersionsToKeep.setNullSelectionAllowed(false);
        this.m_numberVersionsToKeep.setTextInputAllowed(true);
        this.m_numberVersionsToKeep.setNewItemsAllowed(true);
        this.m_numberVersionsToKeep.setNewItemHandler(new AbstractSelect.NewItemHandler(){
            private static final long serialVersionUID = -1962380117946789444L;

            public void addNewItem(String newItemCaption) {
                int num = CmsStringUtil.getIntValue(newItemCaption, -1, "user entered version number is not a number");
                if (num > 1 && !items.contains(num)) {
                    CmsFileHistoryPanel.this.m_numberVersionsToKeep.addItem((Object)num);
                    CmsFileHistoryPanel.this.m_numberVersionsToKeep.select((Object)num);
                }
            }
        });
        int numberHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        if (numberHistoryVersions == -2) {
            numberHistoryVersions = 0;
        }
        if (numberHistoryVersions == -1) {
            numberHistoryVersions = 50;
        }
        this.m_numberVersionsToKeep.select((Object)numberHistoryVersions);
    }

    public class ComboBoxVersionsBean {
        private int m_val;

        public ComboBoxVersionsBean(int value) {
            this.m_val = value;
        }

        public boolean equals(Object o) {
            if (o instanceof ComboBoxVersionsBean) {
                return ((ComboBoxVersionsBean)o).getValue() == this.m_val;
            }
            return false;
        }

        public String getDisplayValue() {
            if (this.m_val == -2) {
                return CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_DISABLED_0", new Object[0]);
            }
            if (this.m_val == -1) {
                return CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_UNLIMITED_0", new Object[0]);
            }
            return String.valueOf(this.m_val);
        }

        public int getValue() {
            return this.m_val;
        }

        public int hashCode() {
            return CmsUUID.getNullUUID().hashCode();
        }
    }
}

