/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.git;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vaadin.ui.AbstractLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.git.CmsGitActionResultPanel;
import org.opencms.ui.apps.git.CmsGitCheckin;
import org.opencms.ui.apps.git.CmsGitConfiguration;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;

public class CmsGitToolOptionsPanel
extends VerticalLayout {
    public static final String ADDINFO_EMAIL = "git_cms_email";
    public static final String ADDINFO_MESSAGE = "git_cms_message";
    public static final String ADDINFO_USER = "git_cms_user";
    private static final Log LOG = CmsLog.getLog(CmsGitToolOptionsPanel.class);
    private static final long serialVersionUID = 1L;
    protected boolean m_advancedVisible;
    Map<String, CheckBox> m_moduleCheckboxes = Maps.newHashMap();
    private CheckBox m_addAndCommit;
    private VerticalLayout m_advancedLayout;
    private Button m_cancel;
    private CmsGitCheckin m_checkinBean;
    private Component m_checkoutTab;
    private TextArea m_commitMessage;
    private Panel m_configurationSelectionPanel;
    private ComboBox m_configurationSelector;
    private CheckBox m_copyAndUnzip;
    private Window[] m_currentWindow = new Window[]{null};
    private Button m_deselectAll;
    private DialogTab m_dialogTab = DialogTab.checkIn;
    private TextField m_emailField;
    private CheckBox m_excludeLib;
    private TextField m_fakeEmailField;
    private TextField m_fakeUserField;
    private CheckBox m_fetchAndReset;
    private CheckBox m_ignoreUnclean;
    private ActionType m_mode = ActionType.checkIn;
    private VerticalLayout m_moduleSelectionContainer;
    private ComboBox m_moduleSelector;
    private HorizontalLayout m_moduleSelectorContainer;
    private Button m_okButton;
    private CheckBox m_pullAfterCommit;
    private CheckBox m_pullFirst;
    private CheckBox m_pushAutomatically;
    private TabSheet m_tabs;
    private Button m_toggleOptions;
    private CmsUser m_user;
    private TextField m_userField;

    public CmsGitToolOptionsPanel(CmsGitCheckin checkinBean) {
        this.m_checkinBean = checkinBean;
        if (!checkinBean.hasValidConfiguration()) {
            this.setMargin(true);
            Label errorLabel = new Label(CmsVaadinUtils.getMessageText("GUI_GIT_APP_UNCONFIGURED_0", new Object[0]));
            errorLabel.setContentMode(ContentMode.HTML);
            this.addComponent((Component)errorLabel);
            return;
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.configureConfigurationSelector();
        this.updateForNewConfiguration(this.m_checkinBean.getCurrentConfiguration());
        this.m_user = A_CmsUI.getCmsObject().getRequestContext().getCurrentUser();
        this.restoreFieldsFromUserInfo();
        this.setAdvancedVisible(false);
        this.m_toggleOptions.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsGitToolOptionsPanel.this.setAdvancedVisible(!CmsGitToolOptionsPanel.this.m_advancedVisible);
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsGitToolOptionsPanel.this.m_dialogTab == DialogTab.checkIn) {
                    CmsGitToolOptionsPanel.this.runAction(ActionType.checkIn);
                } else {
                    CmsGitToolOptionsPanel.this.runAction(ActionType.checkOut);
                }
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                A_CmsUI.get().getPage().setLocation(CmsVaadinUtils.getWorkplaceLink());
            }
        });
        this.m_deselectAll.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                for (Map.Entry<String, CheckBox> entry : CmsGitToolOptionsPanel.this.m_moduleCheckboxes.entrySet()) {
                    CheckBox checkBox = entry.getValue();
                    checkBox.setValue((Object)Boolean.FALSE);
                }
            }
        });
        this.m_tabs.addStyleName("framed");
        this.m_tabs.addStyleName("padded-tabbar");
        this.m_tabs.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){
            private static final long serialVersionUID = 1L;

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                DialogTab tab = CmsGitToolOptionsPanel.this.m_tabs.getSelectedTab() == CmsGitToolOptionsPanel.this.m_checkoutTab ? DialogTab.checkOut : DialogTab.checkIn;
                CmsGitToolOptionsPanel.this.setTab(tab);
            }
        });
        this.m_fetchAndReset.setValue((Object)Boolean.TRUE);
        this.setTab(this.m_dialogTab);
    }

    public Window addAsWindow(Component component) {
        if (this.m_currentWindow[0] != null) {
            this.m_currentWindow[0].close();
            this.m_currentWindow[0] = null;
        }
        Window window = new Window();
        window.setContent(component);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_GIT_SCRIPT_RESULTS_0", new Object[0]));
        window.setWidth("1000px");
        window.setModal(true);
        window.setResizable(false);
        A_CmsUI.get().addWindow(window);
        this.m_currentWindow[0] = window;
        return window;
    }

    public void addSelectableModule(String moduleName) {
        boolean enabled = true;
        CheckBox moduleCheckBox = new CheckBox();
        String iconUri = CmsWorkplace.getResourceUri("tools/modules/buttons/modules.png");
        CmsResourceInfo info = new CmsResourceInfo(moduleName, "", iconUri);
        HorizontalLayout line = new HorizontalLayout();
        line.setWidth("100%");
        line.addComponent((Component)moduleCheckBox);
        info.setWidth("100%");
        line.addComponent((Component)info);
        line.setComponentAlignment((Component)moduleCheckBox, Alignment.MIDDLE_CENTER);
        line.setExpandRatio((Component)info, 1.0f);
        moduleCheckBox.setEnabled(true);
        moduleCheckBox.setValue((Object)enabled);
        this.m_moduleCheckboxes.put(moduleName, moduleCheckBox);
        this.m_moduleSelectionContainer.addComponent((Component)line, this.m_moduleSelectionContainer.getComponentCount() - 1);
        this.setTab(this.m_dialogTab);
    }

    public void enableCheckboxesForNotInstalledModules(boolean enable) {
        for (Map.Entry<String, CheckBox> entry : this.m_moduleCheckboxes.entrySet()) {
            String moduleName = entry.getKey();
            CheckBox checkbox = entry.getValue();
            if (OpenCms.getModuleManager().hasModule(moduleName)) continue;
            checkbox.setEnabled(enable);
            if (enable) continue;
            checkbox.setValue((Object)Boolean.FALSE);
        }
    }

    public Collection<String> getSelectedModules() {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, CheckBox> entry : this.m_moduleCheckboxes.entrySet()) {
            if (!((Boolean)entry.getValue().getValue()).booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public void runAction(ActionType action) {
        this.m_mode = action;
        this.setActionFlags();
        this.setCommonParameters();
        this.m_checkinBean.clearModules();
        for (String moduleName : this.getSelectedModules()) {
            this.m_checkinBean.addModuleToExport(moduleName);
        }
        int result = this.m_checkinBean.checkIn();
        String log = this.m_checkinBean.getLogText();
        String message = null;
        boolean error = false;
        switch (action) {
            case checkIn: {
                String messageToSave = this.m_checkinBean.getCommitMessage();
                String emailToSave = this.m_checkinBean.getGitUserEmail();
                String userToSave = this.m_checkinBean.getGitUserName();
                CmsObject cms = this.m_checkinBean.getCmsObject();
                CmsUser user = cms.getRequestContext().getCurrentUser();
                this.setUserInfo(user, ADDINFO_USER, userToSave);
                this.setUserInfo(user, ADDINFO_EMAIL, emailToSave);
                this.setUserInfo(user, ADDINFO_MESSAGE, messageToSave);
                try {
                    cms.writeUser(user);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                ArrayList<Button> resetButtons = new ArrayList<Button>();
                Button resetHead = new Button(CmsVaadinUtils.getMessageText("GUI_GIT_BUTTON_RESET_HEAD_0", new Object[0]));
                resetHead.setDescription(CmsVaadinUtils.getMessageText("GUI_GIT_BUTTON_RESET_HEAD_DESC_0", new Object[0]));
                resetHead.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        CmsGitToolOptionsPanel.this.runAction(ActionType.resetHead);
                    }
                });
                Button resetRemoteHead = new Button(CmsVaadinUtils.getMessageText("GUI_GIT_BUTTON_RESET_REMOTE_HEAD_0", new Object[0]));
                resetRemoteHead.setDescription(CmsVaadinUtils.getMessageText("GUI_GIT_BUTTON_RESET_REMOTE_HEAD_DESC_0", new Object[0]));
                resetRemoteHead.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        CmsGitToolOptionsPanel.this.runAction(ActionType.resetRemoteHead);
                    }
                });
                if (result == 0) {
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_CHECKIN_SUCCESSFUL_0", new Object[0]);
                } else if (result == 10) {
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_CHECKIN_FAILED_0", new Object[0]);
                    error = true;
                    resetButtons.add(resetRemoteHead);
                    resetButtons.add(resetHead);
                } else {
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_CHECKIN_FAILED_0", new Object[0]);
                    error = true;
                    resetButtons.add(resetRemoteHead);
                }
                CmsGitActionResultPanel panel = new CmsGitActionResultPanel(message, log, error, resetButtons);
                this.addAsWindow((Component)panel);
                break;
            }
            case checkOut: {
                message = result == 0 ? CmsVaadinUtils.getMessageText("GUI_GIT_IMPORT_SUCCESSFUL_0", new Object[0]) : CmsVaadinUtils.getMessageText("GUI_GIT_IMPORT_FAILED_0", new Object[0]);
                CmsGitActionResultPanel checkoutResult = new CmsGitActionResultPanel(message, log, error, new ArrayList<Button>());
                this.addAsWindow((Component)checkoutResult);
                break;
            }
            case resetHead: {
                if (result == 0) {
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_RESET_SUCCESSFUL_0", new Object[0]);
                } else {
                    error = true;
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_RESET_FAILED_0", new Object[0]);
                }
                CmsGitActionResultPanel resetResult = new CmsGitActionResultPanel(message, log, error, new ArrayList<Button>());
                this.addAsWindow((Component)resetResult);
                break;
            }
            case resetRemoteHead: {
                if (result == 0) {
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_RESET_SUCCESSFUL_0", new Object[0]);
                } else {
                    error = true;
                    message = CmsVaadinUtils.getMessageText("GUI_GIT_RESET_FAILED_0", new Object[0]);
                }
                CmsGitActionResultPanel resetRemoteResult = new CmsGitActionResultPanel(message, log, error, new ArrayList<Button>());
                this.addAsWindow((Component)resetRemoteResult);
                break;
            }
        }
    }

    public void setActionFlags() {
        this.m_checkinBean.setFetchAndResetBeforeImport((Boolean)this.m_fetchAndReset.getValue());
        switch (this.m_mode) {
            case checkOut: {
                this.m_checkinBean.setCheckout(true);
                this.m_checkinBean.setResetHead(false);
                this.m_checkinBean.setResetRemoteHead(false);
                break;
            }
            case checkIn: {
                this.m_checkinBean.setCheckout(false);
                this.m_checkinBean.setResetHead(false);
                this.m_checkinBean.setResetRemoteHead(false);
                break;
            }
            case resetHead: {
                this.m_checkinBean.setCheckout(false);
                this.m_checkinBean.setResetHead(true);
                this.m_checkinBean.setResetRemoteHead(false);
                break;
            }
            case resetRemoteHead: {
                this.m_checkinBean.setCheckout(false);
                this.m_checkinBean.setResetHead(false);
                this.m_checkinBean.setResetRemoteHead(true);
                break;
            }
        }
    }

    public void setAdvancedVisible(boolean visible) {
        this.m_advancedLayout.setVisible(visible);
        this.m_advancedVisible = visible;
        this.m_toggleOptions.setCaption(visible ? CmsVaadinUtils.getMessageText("GUI_GIT_OPTIONS_HIDE_0", new Object[0]) : CmsVaadinUtils.getMessageText("GUI_GIT_OPTIONS_SHOW_0", new Object[0]));
    }

    public void setTab(DialogTab dialogTab) {
        this.m_dialogTab = dialogTab;
        switch (dialogTab) {
            case checkIn: {
                this.enableCheckboxesForNotInstalledModules(false);
                this.m_okButton.setCaption(CmsVaadinUtils.getMessageText("GUI_GIT_BUTTON_CHECK_IN_0", new Object[0]));
                break;
            }
            case checkOut: {
                this.m_fakeEmailField.setValue((String)this.m_emailField.getValue());
                this.m_fakeUserField.setValue((String)this.m_userField.getValue());
                this.m_okButton.setCaption(CmsVaadinUtils.getMessageText("GUI_GIT_BUTTON_IMPORT_0", new Object[0]));
                this.enableCheckboxesForNotInstalledModules(true);
                break;
            }
        }
    }

    public void updateNewModuleSelector() {
        ComboBox newModuleSelector = this.createModuleSelector();
        ((AbstractLayout)this.m_moduleSelector.getParent()).replaceComponent((Component)this.m_moduleSelector, (Component)newModuleSelector);
        this.m_moduleSelector = newModuleSelector;
        this.m_moduleSelector.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                String moduleName = (String)event.getProperty().getValue();
                CmsGitToolOptionsPanel.this.addSelectableModule(moduleName);
                CmsGitToolOptionsPanel.this.updateNewModuleSelector();
            }
        });
    }

    protected void updateForNewConfiguration(CmsGitConfiguration gitConfig) {
        if (!this.m_checkinBean.setCurrentConfiguration(gitConfig)) {
            Notification.show((String)CmsVaadinUtils.getMessageText("GUI_GIT_CONFIGURATION_SWITCH_FAILED_0", new Object[0]), (String)CmsVaadinUtils.getMessageText("GUI_GIT_CONFIGURATION_SWITCH_FAILED_DESC_0", new Object[0]), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            this.m_configurationSelector.select((Object)this.m_checkinBean.getCurrentConfiguration());
            return;
        }
        this.resetSelectableModules();
        for (String moduleName : gitConfig.getConfiguredModules()) {
            this.addSelectableModule(moduleName);
        }
        this.updateNewModuleSelector();
        this.m_pullFirst.setValue((Object)gitConfig.getDefaultAutoPullBefore());
        this.m_pullAfterCommit.setValue((Object)gitConfig.getDefaultAutoPullAfter());
        this.m_addAndCommit.setValue((Object)gitConfig.getDefaultAutoCommit());
        this.m_pushAutomatically.setValue((Object)gitConfig.getDefaultAutoPush());
        this.m_commitMessage.setValue(Strings.nullToEmpty((String)gitConfig.getDefaultCommitMessage()));
        this.m_copyAndUnzip.setValue((Object)gitConfig.getDefaultCopyAndUnzip());
        this.m_excludeLib.setValue((Object)gitConfig.getDefaultExcludeLibs());
        this.m_ignoreUnclean.setValue((Object)gitConfig.getDefaultIngoreUnclean());
        this.m_userField.setValue(Strings.nullToEmpty((String)gitConfig.getDefaultGitUserName()));
        this.m_emailField.setValue(Strings.nullToEmpty((String)gitConfig.getDefaultGitUserEmail()));
    }

    private void configureConfigurationSelector() {
        if (this.m_checkinBean.getConfigurations().size() < 2) {
            this.removeComponent((Component)this.m_configurationSelectionPanel);
        } else {
            for (CmsGitConfiguration configuration : this.m_checkinBean.getConfigurations()) {
                this.m_configurationSelector.addItem((Object)configuration);
                this.m_configurationSelector.setItemCaption((Object)configuration, configuration.getName());
            }
            this.m_configurationSelector.setNullSelectionAllowed(false);
            this.m_configurationSelector.setNewItemsAllowed(false);
            this.m_configurationSelector.setWidth("350px");
            this.m_configurationSelector.select((Object)this.m_checkinBean.getCurrentConfiguration());
            this.m_configurationSelector.addValueChangeListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1L;

                public void valueChange(Property.ValueChangeEvent event) {
                    CmsGitToolOptionsPanel.this.updateForNewConfiguration((CmsGitConfiguration)event.getProperty().getValue());
                    CmsGitToolOptionsPanel.this.restoreFieldsFromUserInfo();
                }
            });
        }
    }

    private ComboBox createModuleSelector() {
        ComboBox result = new ComboBox();
        result.setPageLength(20);
        result.setWidth("350px");
        result.setFilteringMode(FilteringMode.CONTAINS);
        result.setNewItemsAllowed(false);
        result.setNullSelectionAllowed(false);
        ArrayList moduleNames = Lists.newArrayList();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            String moduleName = module.getName();
            if (this.m_moduleCheckboxes.containsKey(moduleName)) continue;
            moduleNames.add(moduleName);
        }
        Collections.sort(moduleNames);
        for (String moduleName : moduleNames) {
            result.addItem((Object)moduleName);
        }
        return result;
    }

    private void resetSelectableModules() {
        this.m_moduleCheckboxes.clear();
        this.m_moduleSelectionContainer.removeAllComponents();
        this.m_moduleSelectionContainer.addComponent((Component)this.m_moduleSelectorContainer);
    }

    private void restoreFieldsFromUserInfo() {
        String savedEmail = (String)this.m_user.getAdditionalInfo().get(ADDINFO_EMAIL);
        String savedName = (String)this.m_user.getAdditionalInfo().get(ADDINFO_USER);
        String savedMessage = (String)this.m_user.getAdditionalInfo().get(ADDINFO_MESSAGE);
        if (savedEmail != null) {
            this.m_emailField.setValue(savedEmail);
        }
        if (savedName != null) {
            this.m_userField.setValue(savedName);
        }
        if (savedMessage != null) {
            this.m_commitMessage.setValue(savedMessage);
        }
    }

    private void setCommonParameters() {
        this.m_checkinBean.setPullBefore((Boolean)this.m_pullFirst.getValue());
        this.m_checkinBean.setPullAfter((Boolean)this.m_pullAfterCommit.getValue());
        this.m_checkinBean.setPush((Boolean)this.m_pushAutomatically.getValue());
        this.m_checkinBean.setExcludeLibs((Boolean)this.m_excludeLib.getValue());
        this.m_checkinBean.setCommit((Boolean)this.m_addAndCommit.getValue());
        this.m_checkinBean.setIgnoreUnclean((Boolean)this.m_ignoreUnclean.getValue());
        this.m_checkinBean.setCopyAndUnzip((Boolean)this.m_copyAndUnzip.getValue());
        this.m_checkinBean.setGitUserEmail((String)this.m_emailField.getValue());
        this.m_checkinBean.setGitUserName((String)this.m_userField.getValue());
        String commitMessage = (String)this.m_commitMessage.getValue();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(commitMessage)) {
            this.m_checkinBean.setCommitMessage(commitMessage);
        }
    }

    private void setUserInfo(CmsUser user, String key, String value) {
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            user.getAdditionalInfo().put(key, value);
        }
    }

    static enum DialogTab {
        checkIn,
        checkOut;

    }

    static enum ActionType {
        checkIn,
        checkOut,
        resetHead,
        resetRemoteHead;

    }
}

