/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.linkvalidation;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsExternalLinksValidator;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.threads.Messages;

public class CmsExternalLinksValidatorThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsExternalLinksValidatorThread.class);
    private CmsObject m_cms;
    private CmsExternalLinksValidator m_externLinkValidator;
    private Runnable m_fin;

    public CmsExternalLinksValidatorThread(CmsObject cms, Runnable finRun) {
        super(cms, Messages.get().getBundle().key("GUI_POINTER_VALIDATION_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_cms = cms;
        this.m_fin = finRun;
        this.m_cms.getRequestContext().setUpdateSessionEnabled(false);
        this.m_externLinkValidator = new CmsExternalLinksValidator();
        this.m_externLinkValidator.setReport(this.getReport());
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        block3: {
            try {
                this.m_externLinkValidator.validateLinks(this.m_cms);
            }
            catch (Throwable e) {
                this.getReport().println(e);
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getLocalizedMessage());
            }
        }
        if (this.m_fin != null) {
            this.m_fin.run();
        }
    }
}

