/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.linkvalidation;

import com.vaadin.ui.Component;
import com.vaadin.v7.ui.Table;
import java.util.List;
import java.util.Set;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.linkvalidation.A_CmsLinkValidator;
import org.opencms.ui.apps.linkvalidation.I_CmsUpdatableComponent;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;

public class CmsLinkValidationInternalTable
extends CmsFileTable
implements I_CmsUpdatableComponent {
    private static final long serialVersionUID = -5023815553518761192L;
    private CmsObject m_cms;
    private Component m_introComponent;
    private Component m_nullComponent;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private A_CmsLinkValidator m_linkValidator;
    private List<String> m_resourcesToCheck;

    public CmsLinkValidationInternalTable(Component introComponent, Component nullComponent, final A_CmsLinkValidator linkValidator) {
        super(null, linkValidator.getTableProperties());
        this.applyWorkplaceAppSettings();
        this.setContextProvider(new I_CmsContextProvider(){

            @Override
            public I_CmsDialogContext getDialogContext() {
                CmsFileTableDialogContext context = new CmsFileTableDialogContext("project-management", I_CmsDialogContext.ContextType.fileTable, CmsLinkValidationInternalTable.this, CmsLinkValidationInternalTable.this.getSelectedResources());
                context.setEditableProperties(CmsFileExplorer.INLINE_EDIT_PROPERTIES);
                return context;
            }
        });
        this.setSizeFull();
        this.addPropertyProvider(linkValidator);
        if (linkValidator.getClickListener() != null) {
            this.m_fileTable.addItemClickListener(linkValidator.getClickListener());
            this.addAdditionalStyleGenerator(new Table.CellStyleGenerator(){

                public String getStyle(Table source, Object itemId, Object propertyId) {
                    if (linkValidator.getTableProperty().equals(propertyId)) {
                        return " o-hover-column";
                    }
                    return "";
                }
            });
        }
        this.m_linkValidator = linkValidator;
        this.m_introComponent = introComponent;
        this.m_nullComponent = nullComponent;
    }

    @Override
    public void update(List<String> resourcePaths) {
        this.m_resourcesToCheck = resourcePaths;
        this.reload();
    }

    void reload() {
        List<CmsResource> broken = this.m_linkValidator.failedResources(this.m_resourcesToCheck);
        if (broken.size() > 0) {
            this.setVisible(true);
            this.m_introComponent.setVisible(false);
            this.m_nullComponent.setVisible(false);
        } else {
            this.setVisible(false);
            this.m_introComponent.setVisible(false);
            this.m_nullComponent.setVisible(true);
        }
        this.fillTable(this.getRootCms(), broken);
    }

    private CmsObject getRootCms() {
        if (this.m_cms == null) {
            this.m_cms = A_CmsUI.getCmsObject();
            this.m_cms.getRequestContext().setSiteRoot("");
        }
        return this.m_cms;
    }
}

