/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.lists;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Collections;
import org.opencms.ade.containerpage.shared.CmsDialogOptions;
import org.opencms.file.CmsResource;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsOptionDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 8398169182381160373L;

    public CmsOptionDialog(CmsResource resource, CmsDialogOptions options, final I_OptionHandler handler, final Runnable onClose, final Window window) {
        if (resource != null) {
            this.displayResourceInfo(Collections.singletonList(resource));
        }
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        layout.setSpacing(true);
        layout.addComponent((Component)new Label(options.getInfo(), ContentMode.HTML));
        final OptionGroup opt = new OptionGroup();
        for (CmsDialogOptions.Option option : options.getOptions()) {
            opt.addItem((Object)option.getValue());
            opt.setItemCaption((Object)option.getValue(), option.getLabel());
        }
        opt.setValue((Object)options.getOptions().get(0).getValue());
        layout.addComponent((Component)opt);
        this.setContent((Component)layout);
        Button ok = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
        ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                String option = (String)opt.getValue();
                if (window != null) {
                    window.close();
                }
                handler.handleOption(option);
            }
        });
        this.addButton((Component)ok);
        Button cancel = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
        cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (window != null) {
                    window.close();
                }
                if (onClose != null) {
                    onClose.run();
                }
            }
        });
        this.addButton((Component)cancel);
        if (window != null && onClose != null) {
            window.addCloseListener(new Window.CloseListener(){
                private static final long serialVersionUID = 1L;

                public void windowClose(Window.CloseEvent e) {
                    onClose.run();
                }
            });
        }
    }

    public static interface I_OptionHandler {
        public void handleOption(String var1);
    }
}

