/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.apps.logfile.CmsLogDownloadDialog;
import org.opencms.ui.apps.logfile.CmsLogFileApp;
import org.opencms.ui.apps.logfile.CmsLogFileOptionProvider;
import org.opencms.ui.apps.logfile.I_CmsLogDownloadProvider;

public class CmsDefaultLogDownloadProvider
implements I_CmsLogDownloadProvider {
    private static final Log LOG = CmsLog.getLog(CmsDefaultLogDownloadProvider.class);
    private static final String ZIP_PATH = CmsLogFileApp.LOG_FOLDER + "logs.zip";

    @Override
    public boolean canDownloadAllLogs() {
        return true;
    }

    @Override
    public String getDownloadPrefix() {
        return "";
    }

    @Override
    public Set<String> getLogFiles() {
        HashSet<String> result = new HashSet<String>();
        for (File file : CmsLogFileOptionProvider.getLogFiles()) {
            String path;
            if (file.isDirectory() || (path = file.getAbsolutePath()).endsWith(".zip") || path.endsWith(".gz")) continue;
            result.add(file.getAbsolutePath());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream readAllLogs() {
        FileOutputStream fos = null;
        CmsLogDownloadDialog.ZipGenerator zipGen = null;
        try {
            fos = new FileOutputStream(ZIP_PATH);
            zipGen = new CmsLogDownloadDialog.ZipGenerator(fos);
            for (File file : CmsLogFileOptionProvider.getLogFiles()) {
                if (!(!file.isDirectory() & !ZIP_PATH.equals(file.getAbsolutePath()))) continue;
                zipGen.addToZip(new File(CmsLogFileApp.LOG_FOLDER), file);
            }
            zipGen.close();
            fos.close();
            FileInputStream fileInputStream = new FileInputStream(ZIP_PATH);
            return fileInputStream;
        }
        catch (IOException e) {
            LOG.error((Object)"unable to build zip file", (Throwable)e);
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (zipGen != null) {
                try {
                    zipGen.close();
                }
                catch (Exception e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public InputStream readLog(String path) {
        Set<String> files = this.getLogFiles();
        if (files.contains(path)) {
            try {
                return new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

