/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import java.io.File;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.logfile.CmsLogFileApp;

public final class CmsLogFileOptionProvider {
    public static final String ENV_LOGFILES = "OCCO_ADDITIONAL_LOG_DIRS";
    private static final Log LOG = CmsLog.getLog(CmsLogFileOptionProvider.class);

    private CmsLogFileOptionProvider() {
    }

    public static List<String> getAdditionalLogDirectories() {
        return OpenCms.getWorkplaceManager().getAdditionalLogFolderConfiguration().getLogFolders();
    }

    public static TreeSet<File> getLogFiles() {
        TreeSet<File> result = new TreeSet<File>();
        for (File file : new File(CmsLogFileApp.LOG_FOLDER).listFiles()) {
            result.add(file);
        }
        for (String dir : CmsLogFileOptionProvider.getAdditionalLogDirectories()) {
            File file = new File(dir);
            if (!file.exists() || !file.isDirectory()) continue;
            for (File child : file.listFiles()) {
                if (child.canRead()) {
                    result.add(child);
                    continue;
                }
                LOG.error((Object)("Can not read " + child.getAbsolutePath()));
            }
        }
        return result;
    }
}

