/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.google.common.base.Strings;
import com.vaadin.server.Resource;
import org.opencms.module.CmsModule;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.util.table.Column;

public class CmsModuleRow {
    private CmsModule m_module;

    public CmsModuleRow(CmsModule module) {
        this.m_module = module;
    }

    public boolean equals(Object other) {
        return other instanceof CmsModuleRow && ((CmsModuleRow)other).getName().equals(this.getName());
    }

    @Column(header="GUI_MODULES_HEADER_GROUP_0", order=40, width=200)
    public String getGroup() {
        return Strings.nullToEmpty((String)this.m_module.getGroup());
    }

    public Resource getIcon() {
        return CmsModuleApp.Icons.LIST_ICON;
    }

    public CmsModule getModule() {
        return this.m_module;
    }

    @Column(header="GUI_MODULES_HEADER_NAME_0", styleName="o-hover-column", width=350, order=10)
    public String getName() {
        return this.m_module.getName();
    }

    @Column(header="GUI_MODULES_HEADER_TITLE_0", expandRatio=1.0f, order=20)
    public String getTitle() {
        return Strings.nullToEmpty((String)this.m_module.getNiceName());
    }

    @Column(header="GUI_MODULES_HEADER_TYPES_0", order=50)
    public int getTypes() {
        return this.m_module.getResourceTypes().size();
    }

    @Column(header="GUI_MODULES_HEADER_VERSION_0", width=80, order=30)
    public String getVersion() {
        return this.m_module.getVersion().toString();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

