/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules.edit;

import com.google.common.collect.Lists;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Collections;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsAutoItemCreatingComboBox;

public class CmsModuleDependencyWidget
extends FormLayout {
    private static final long serialVersionUID = 1L;
    private CmsAutoItemCreatingComboBox m_moduleSelect;
    private TextField m_version;

    public CmsModuleDependencyWidget() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        IndexedContainer container = new IndexedContainer();
        ArrayList moduleNames = Lists.newArrayList();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            String name = module.getName();
            moduleNames.add(name);
        }
        Collections.sort(moduleNames);
        for (String name : moduleNames) {
            container.addItem((Object)name);
        }
        this.m_moduleSelect.setContainerDataSource((Container)container);
        this.m_moduleSelect.setNewValueHandler(new CmsAutoItemCreatingComboBox.I_NewValueHandler(){

            @Override
            public Object ensureItem(Container cnt, Object id) {
                if (!cnt.containsId(id)) {
                    cnt.addItem(id);
                }
                return id;
            }
        });
        this.setWidth("100%");
    }

    public static CmsModuleDependencyWidget create(CmsModuleDependency dep) {
        CmsModuleDependencyWidget result = new CmsModuleDependencyWidget();
        if (dep != null) {
            result.m_moduleSelect.setValue(dep.getName());
            result.m_version.setValue(dep.getVersion().toString());
        }
        return result;
    }

    public String getModuleName() {
        return (String)this.m_moduleSelect.getValue();
    }

    public String getModuleVersion() {
        return (String)this.m_version.getValue();
    }
}

