/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules.edit;

import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.shared.ui.ErrorLevel;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import java.util.Arrays;
import java.util.EventObject;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.shared.CmsSiteSelectorOption;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.ui.components.fileselect.CmsResourceSelectDialog;
import org.opencms.util.CmsStringUtil;

public class CmsModuleResourceSelectField
extends CmsPathSelectField {
    private static final Log LOG = CmsLog.getLog(CmsModuleResourceSelectField.class);
    private static final long serialVersionUID = 1L;

    public CmsModuleResourceSelectField() {
        this.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsModuleResourceSelectField.this.updateValidation();
            }
        });
    }

    @Override
    public void setCmsObject(CmsObject cms) {
        this.m_cms = cms;
    }

    public void updateSite(String siteRoot) {
        try {
            CmsObject cloneCms = OpenCms.initCmsObject(this.m_cms);
            if (siteRoot == null) {
                siteRoot = "/system";
            }
            cloneCms.getRequestContext().setSiteRoot(siteRoot);
            this.m_cms = cloneCms;
        }
        catch (CmsException e1) {
            LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
        }
        this.updateValidation();
    }

    @Override
    protected CmsResourceSelectDialog.Options getOptions() {
        CmsResourceSelectDialog.Options options = new CmsResourceSelectDialog.Options();
        CmsSiteSelectorOptionBuilder optBuilder = new CmsSiteSelectorOptionBuilder(this.m_cms);
        optBuilder.addNormalSites(true, new CmsUserSettings(this.m_cms).getStartFolder());
        optBuilder.addSharedSite();
        optBuilder.addSystemFolder();
        IndexedContainer availableSites = new IndexedContainer();
        availableSites.addContainerProperty((Object)"caption", String.class, null);
        for (CmsSiteSelectorOption option : optBuilder.getOptions()) {
            String siteRoot = option.getSiteRoot();
            boolean matches = false;
            for (String candidate : Arrays.asList(this.m_cms.getRequestContext().getSiteRoot(), "/system", OpenCms.getSiteManager().getSharedFolder())) {
                if (!CmsStringUtil.comparePaths(candidate, siteRoot)) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            Item siteItem = availableSites.addItem((Object)option.getSiteRoot());
            siteItem.getItemProperty((Object)"caption").setValue((Object)option.getMessage());
        }
        options.setSiteSelectionContainer(availableSites);
        return options;
    }

    private void updateValidation() {
        boolean changed = false;
        changed |= CmsVaadinUtils.updateComponentError((AbstractComponent)this.m_textField, null);
        String path = this.getValue();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(path) && !this.m_cms.existsResource(path, CmsResourceFilter.IGNORE_EXPIRATION)) {
            UserError error = new UserError(CmsVaadinUtils.getMessageText("GUI_MODULES_MODULE_RESOURCE_NOT_FOUND_0", new Object[0]), AbstractErrorMessage.ContentMode.TEXT, ErrorLevel.WARNING);
            changed |= CmsVaadinUtils.updateComponentError((AbstractComponent)this.m_textField, (ErrorMessage)error);
        }
        if (changed) {
            this.fireEvent((EventObject)new Component.ErrorEvent(null, (Component)this));
        }
    }
}

