/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.projects;

import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.projects.CmsProjectManager;
import org.opencms.ui.apps.projects.CmsProjectsTable;
import org.opencms.util.CmsUUID;

public class CmsProjectHistoryTable
extends Table {
    private static final Log LOG = CmsLog.getLog(CmsProjectHistoryTable.class);
    private static final long serialVersionUID = 7343623156086839992L;
    public static final String PROP_PUBLISH_DATE = "publishDate";
    public static final String PROP_PUBLISH_USER = "publishUser";
    IndexedContainer m_container;
    CmsProjectManager m_manager;

    public CmsProjectHistoryTable() {
        this.setSizeFull();
        this.m_container = new IndexedContainer();
        this.m_container.addContainerProperty((Object)"id", CmsUUID.class, null);
        this.m_container.addContainerProperty((Object)"name", String.class, (Object)"");
        this.m_container.addContainerProperty((Object)"descrition", String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_PUBLISH_DATE, Date.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_PUBLISH_USER, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)"orgUnit", String.class, (Object)"");
        this.m_container.addContainerProperty((Object)"owner", String.class, (Object)"");
        this.m_container.addContainerProperty((Object)"manager", String.class, (Object)"");
        this.m_container.addContainerProperty((Object)"user", String.class, (Object)"");
        this.m_container.addContainerProperty((Object)"dateCreated", Date.class, (Object)"");
        this.m_container.addContainerProperty((Object)"resources", CmsProjectsTable.ProjectResources.class, (Object)"");
        this.setContainerDataSource((Container)this.m_container);
        this.setColumnHeader("name", CmsVaadinUtils.getMessageText("GUI_PROJECTS_NAME_0", new Object[0]));
        this.setColumnHeader("descrition", CmsVaadinUtils.getMessageText("GUI_PROJECTS_DESCRIPTION_0", new Object[0]));
        this.setColumnHeader(PROP_PUBLISH_DATE, CmsVaadinUtils.getMessageText("GUI_PROJECTS_PUBLISH_DATE_0", new Object[0]));
        this.setColumnHeader(PROP_PUBLISH_USER, CmsVaadinUtils.getMessageText("GUI_PROJECTS_PUBLISHED_BY_0", new Object[0]));
        this.setColumnHeader("orgUnit", CmsVaadinUtils.getMessageText("GUI_PROJECTS_ORG_UNIT_0", new Object[0]));
        this.setColumnHeader("owner", CmsVaadinUtils.getMessageText("GUI_PROJECTS_OWNER_0", new Object[0]));
        this.setColumnHeader("manager", CmsVaadinUtils.getMessageText("GUI_PROJECTS_MANAGER_GROUP_0", new Object[0]));
        this.setColumnHeader("user", CmsVaadinUtils.getMessageText("GUI_PROJECTS_USER_GROUP_0", new Object[0]));
        this.setColumnHeader("dateCreated", CmsVaadinUtils.getMessageText("GUI_PROJECTS_DATE_CREATED_0", new Object[0]));
        this.setColumnHeader("resources", CmsVaadinUtils.getMessageText("GUI_PROJECTS_RESOURCES_0", new Object[0]));
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.addItemClickListener((ItemClickEvent.ItemClickListener & Serializable)event -> this.handleItemClick(event));
        this.loadProjects();
    }

    public void loadProjects() {
        CmsObject cms = A_CmsUI.getCmsObject();
        Locale locale = UI.getCurrent().getLocale();
        this.m_container.removeAllItems();
        boolean isMultiOU = false;
        try {
            isMultiOU = !OpenCms.getOrgUnitManager().getOrganizationalUnits(cms, "", true).isEmpty();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (isMultiOU) {
            this.setVisibleColumns(new Object[]{"name", "descrition", PROP_PUBLISH_DATE, PROP_PUBLISH_USER, "orgUnit", "owner", "manager", "user", "dateCreated", "resources"});
        } else {
            this.setVisibleColumns(new Object[]{"name", "descrition", PROP_PUBLISH_DATE, PROP_PUBLISH_USER, "owner", "manager", "user", "dateCreated", "resources"});
        }
        try {
            List<CmsHistoryProject> projects = cms.getAllHistoricalProjects();
            for (CmsHistoryProject project : projects) {
                Item item = this.m_container.addItem((Object)project.getPublishTag());
                if (item == null) continue;
                item.getItemProperty((Object)"id").setValue((Object)project.getUuid());
                item.getItemProperty((Object)"name").setValue((Object)project.getSimpleName());
                item.getItemProperty((Object)"descrition").setValue((Object)project.getDescription());
                item.getItemProperty((Object)PROP_PUBLISH_DATE).setValue((Object)new Date(project.getPublishingDate()));
                item.getItemProperty((Object)PROP_PUBLISH_USER).setValue((Object)project.getPublishedByName(cms));
                try {
                    item.getItemProperty((Object)"orgUnit").setValue((Object)OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, project.getOuFqn()).getDisplayName(locale));
                    item.getItemProperty((Object)"owner").setValue((Object)cms.readUser(project.getOwnerId()).getName());
                    item.getItemProperty((Object)"manager").setValue((Object)cms.readGroup(project.getManagerGroupId()).getSimpleName());
                    item.getItemProperty((Object)"user").setValue((Object)cms.readGroup(project.getGroupId()).getSimpleName());
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                item.getItemProperty((Object)"dateCreated").setValue((Object)new Date(project.getDateCreated()));
                StringBuffer html = new StringBuffer(512);
                CmsProjectsTable.ProjectResources resourceList = new CmsProjectsTable.ProjectResources(cms.readProjectResources(project));
                item.getItemProperty((Object)"resources").setValue((Object)resourceList);
            }
            this.m_container.sort(new Object[]{PROP_PUBLISH_DATE}, new boolean[]{false});
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void handleItemClick(ItemClickEvent event) {
        if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && "resources".equals(event.getPropertyId())) {
            CmsProjectsTable.showProjectResources(event.getItem());
        }
    }
}

