/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.publishqueue;

import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.publishqueue.CmsPublishQueue;
import org.opencms.ui.report.CmsReportWidget;
import org.opencms.util.CmsUUID;

public class CmsPublishReport
extends VerticalLayout {
    private static Log LOG = CmsLog.getLog(CmsPublishReport.class.getName());
    private static final long serialVersionUID = -1630983150603283505L;
    CmsPublishQueue m_manager;
    private CmsUUID m_jobId;
    private VerticalLayout m_panel;
    private String m_caption;

    public CmsPublishReport(String jobId) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_jobId = new CmsUUID(jobId);
        CmsPublishJobBase job = OpenCms.getPublishManager().getJobByPublishHistoryId(this.m_jobId);
        this.m_caption = CmsVaadinUtils.getMessageText("GUI_PQUEUE_REPORT_2", job.getProjectName(), job.getUserName(A_CmsUI.getCmsObject()));
        if (job instanceof CmsPublishJobRunning) {
            A_CmsReportThread thread = OpenCms.getThreadStore().retrieveThread(((CmsPublishJobRunning)job).getThreadUUID());
            CmsReportWidget report = new CmsReportWidget(thread);
            report.setWidth("100%");
            report.setHeight("700px");
            this.m_panel.addComponent((Component)report);
        } else {
            String reportHTML = "";
            try {
                reportHTML = new String(OpenCms.getPublishManager().getReportContents((CmsPublishJobFinished)job));
            }
            catch (CmsException e) {
                LOG.error((Object)"Error reading Report content of publish job.", (Throwable)e);
            }
            Label label = new Label();
            label.setValue(reportHTML);
            label.setContentMode(ContentMode.HTML);
            label.setHeight("700px");
            label.addStyleName("v-scrollable");
            label.addStyleName("o-report");
            this.m_panel.addComponent((Component)label);
        }
    }

    public String getCaption() {
        return this.m_caption;
    }
}

