/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.publishqueue;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishList;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.publishqueue.CmsPublishQueue;
import org.opencms.ui.apps.publishqueue.CmsPublishReport;
import org.opencms.ui.apps.publishqueue.CmsPublishResources;
import org.opencms.ui.apps.publishqueue.CmsResourcesCellGenerator;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsQueuedTable
extends Table {
    public static final String ICON_ERROR = "apps/publishqueue/state_error.png";
    public static final String ICON_OK = "apps/publishqueue/state_ok.png";
    public static final String ICON_WARNINGS = "apps/publishqueue/state_warning.png";
    public static final String LIST_ACTION_COUNT = "ac";
    public static final String LIST_ACTION_END = "ae";
    public static final String LIST_ACTION_PROJECT = "ap";
    public static final String LIST_ACTION_START = "as";
    public static final String LIST_ACTION_STATE_ERR = "ate";
    public static final String LIST_ACTION_STATE_OK = "ato";
    public static final String LIST_ACTION_VIEW = "av";
    public static final String LIST_ID = "lppq";
    static Log LOG = CmsLog.getLog(CmsQueuedTable.class.getName());
    private static final String PROP_FILESCOUNT = "filesCount";
    private static final String PROP_ICON = "icon";
    private static final String PROP_PROJECT = "project";
    private static final String PROP_RESOURCES = "resources";
    private static final String PROP_START = "start";
    private static final String PROP_STATUS = "status";
    private static final String PROP_SORT_TYPE = "sortType";
    private static final String PROP_STATUS_LOCALE = "statusLocale";
    private static final String PROP_STOP = "stop";
    private static final String PROP_USER = "user";
    private static final long serialVersionUID = 7507300060974348158L;
    private static final String STATE_ERROR = "error";
    private static final String STATE_OK = "ok";
    private static final String STATE_WARNING = "warning";
    private static final String STATE_RUNNING = "running";
    private static final String STATE_ENQUEUE = "queue";
    private static final Map<String, String> STATUS_MESSAGES = CmsQueuedTable.getStatusMap();
    BeanItemContainer<Row> m_container;
    CmsPublishQueue m_manager;
    CmsContextMenu m_menu;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntriesEnq;

    public CmsQueuedTable(CmsPublishQueue manager) {
        this.m_manager = manager;
        this.setSizeFull();
        this.setCaption(CmsVaadinUtils.getMessageText("GUI_PQUEUE_PQUEUE_HIST_0", new Object[0]));
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new BeanItemContainer(Row.class);
        this.setContainerDataSource((Container)this.m_container);
        this.setColumnHeader(PROP_STATUS_LOCALE, "");
        this.setColumnHeader(PROP_RESOURCES, CmsVaadinUtils.getMessageText("GUI_PQUEUE_RESOURCES_0", new Object[0]));
        this.setColumnHeader(PROP_PROJECT, CmsVaadinUtils.getMessageText("GUI_PQUEUE_PROJECT_0", new Object[0]));
        this.setColumnHeader(PROP_START, CmsVaadinUtils.getMessageText("GUI_PQUEUE_STARTDATE_0", new Object[0]));
        this.setColumnHeader(PROP_STOP, CmsVaadinUtils.getMessageText("GUI_PQUEUE_ENDDATE_0", new Object[0]));
        this.setColumnHeader(PROP_USER, CmsVaadinUtils.getMessageText("GUI_PQUEUE_USER_0", new Object[0]));
        this.setColumnHeader(PROP_FILESCOUNT, CmsVaadinUtils.getMessageText("GUI_PQUEUE_SIZE_0", new Object[0]));
        this.setVisibleColumns(new Object[]{PROP_STATUS_LOCALE, PROP_PROJECT, PROP_START, PROP_STOP, PROP_USER, PROP_RESOURCES, PROP_FILESCOUNT});
        this.setColumnWidth(PROP_START, 200);
        this.setColumnWidth(PROP_STOP, 200);
        this.setColumnWidth(PROP_RESOURCES, 550);
        this.setItemIconPropertyId(PROP_ICON);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -7394790444104979594L;

            public void itemClick(ItemClickEvent event) {
                CmsQueuedTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (CmsQueuedTable.PROP_RESOURCES.equals(propertyId)) {
                    return " o-hover-column";
                }
                if (CmsQueuedTable.PROP_PROJECT.equals(propertyId) & !(itemId instanceof CmsPublishJobEnqueued)) {
                    return " o-hover-column";
                }
                if (CmsQueuedTable.PROP_STATUS_LOCALE.equals(propertyId)) {
                    if (CmsQueuedTable.STATE_OK.equals(source.getItem(itemId).getItemProperty((Object)CmsQueuedTable.PROP_STATUS).getValue())) {
                        return " o-box-green";
                    }
                    if (CmsQueuedTable.STATE_WARNING.equals(source.getItem(itemId).getItemProperty((Object)CmsQueuedTable.PROP_STATUS).getValue())) {
                        return " o-box-orange";
                    }
                    if (CmsQueuedTable.STATE_ERROR.equals(source.getItem(itemId).getItemProperty((Object)CmsQueuedTable.PROP_STATUS).getValue())) {
                        return " o-box-red";
                    }
                    if (CmsQueuedTable.STATE_RUNNING.equals(source.getItem(itemId).getItemProperty((Object)CmsQueuedTable.PROP_STATUS).getValue())) {
                        return " o-box-gray-darker";
                    }
                    if (CmsQueuedTable.STATE_ENQUEUE.equals(source.getItem(itemId).getItemProperty((Object)CmsQueuedTable.PROP_STATUS).getValue())) {
                        return " o-box-gray";
                    }
                }
                return null;
            }
        });
        this.loadJobs();
    }

    private static Map<String, String> getStatusMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STATE_OK, "GUI_PQUEUE_STATUS_OK_0");
        map.put(STATE_WARNING, "GUI_PQUEUE_STATUS_WARNING_0");
        map.put(STATE_ERROR, "GUI_PQUEUE_STATUS_ERROR_0");
        map.put(STATE_RUNNING, "GUI_PQUEUE_STATUS_RUNNING_0");
        map.put(STATE_ENQUEUE, "GUI_PQUEUE_STATUS_ENQUEUE_0");
        return map;
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)PROP_USER, search, true, false), new SimpleStringFilter((Object)PROP_RESOURCES, search, true, false), new SimpleStringFilter((Object)PROP_PROJECT, search, true, false)}));
        }
    }

    protected void showReportDialog(String jobid) {
        CmsPublishReport pReport = new CmsPublishReport(jobid);
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsBasicDialog dialog = new CmsBasicDialog();
        dialog.addButton((Component)new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CLOSE_0", new Object[0]), new Button.ClickListener(){
            private static final long serialVersionUID = -4216949392648631634L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        }), true);
        dialog.setContent((Component)pReport);
        window.setContent((Component)dialog);
        window.setCaption(pReport.getCaption());
        A_CmsUI.get().addWindow(window);
    }

    protected void showResourceDialog(String jobid) {
        CmsPublishResources pResources = new CmsPublishResources(jobid);
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsBasicDialog dialog = new CmsBasicDialog();
        dialog.addButton((Component)new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CLOSE_0", new Object[0]), new Button.ClickListener(){
            private static final long serialVersionUID = -4216949392648631634L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        }), true);
        dialog.setContent((Component)pResources);
        window.setContent((Component)dialog);
        window.setCaption(pResources.getCaption());
        A_CmsUI.get().addWindow(window);
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.getValue() instanceof CmsPublishJobEnqueued) {
            if (this.m_menuEntriesEnq == null) {
                this.m_menuEntriesEnq = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
                this.m_menuEntriesEnq.add(new EntryStop());
                this.m_menuEntriesEnq.add(new EntryResources());
            }
            return this.m_menuEntriesEnq;
        }
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryReport());
            this.m_menuEntries.add(new EntryResources());
        }
        return this.m_menuEntries;
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        this.setValue(null);
        this.select(itemId);
        if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || propertyId == null) {
            this.m_menu.setEntries(this.getMenuEntries(), Collections.singleton(((Row)this.getValue()).getJob().getPublishHistoryId().getStringValue()));
            this.m_menu.openForTable(event, itemId, propertyId, this);
        } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && PROP_RESOURCES.equals(propertyId)) {
            this.showResourceDialog(((Row)this.getValue()).getJob().getPublishHistoryId().getStringValue());
        } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && PROP_PROJECT.equals(propertyId) && !(this.getValue() instanceof CmsPublishJobEnqueued)) {
            this.showReportDialog(((Row)this.getValue()).getJob().getPublishHistoryId().getStringValue());
        }
    }

    private String getState(CmsPublishJobFinished publishJob) {
        byte[] reportBytes = null;
        try {
            reportBytes = OpenCms.getPublishManager().getReportContents(publishJob);
        }
        catch (CmsException e) {
            return STATE_ERROR;
        }
        if (reportBytes != null) {
            String report = new String(reportBytes);
            if (report.indexOf("<span class='err'>") > -1) {
                return STATE_ERROR;
            }
            if (report.indexOf("<span class='warn'>") > -1) {
                return STATE_WARNING;
            }
        }
        return STATE_OK;
    }

    private void loadJobs() {
        CmsPublishJobRunning currentJob;
        List<CmsPublishJobFinished> publishJobs = OpenCms.getRoleManager().hasRole(A_CmsUI.getCmsObject(), CmsRole.ROOT_ADMIN) ? OpenCms.getPublishManager().getPublishHistory() : OpenCms.getPublishManager().getPublishHistory(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser());
        for (CmsPublishJobFinished job : publishJobs) {
            this.m_container.addBean((Object)new Row(job, 0));
        }
        this.m_container.sort((Object[])new String[]{PROP_START}, new boolean[]{false});
        ArrayList jobs = new ArrayList();
        if (OpenCms.getPublishManager().isRunning() && (currentJob = OpenCms.getPublishManager().getCurrentPublishJob()) != null) {
            this.m_container.addBean((Object)new Row(currentJob, 1));
        }
        int i = 0;
        for (CmsPublishJobBase cmsPublishJobBase : OpenCms.getPublishManager().getPublishQueue()) {
            this.m_container.addBean((Object)new Row(cmsPublishJobBase, 2 + i));
            ++i;
        }
        this.m_container.sort((Object[])new String[]{PROP_SORT_TYPE, PROP_START}, new boolean[]{false, false});
    }

    public class Row {
        private CmsPublishJobBase m_job;
        private List<?> m_resourceList;
        private Resource m_icon;
        private String m_state;
        private int m_sortType;

        public Row(CmsPublishJobBase job, int sortType) {
            this.m_job = job;
            this.m_sortType = sortType;
            if (job == null) {
                throw new IllegalArgumentException("Job must not be null.");
            }
        }

        public int getFilesCount() {
            return this.m_job.getSize();
        }

        public Resource getIcon() {
            if (this.m_icon == null) {
                this.m_icon = new CmsCssIcon("oc-icon-24-publish");
            }
            return this.m_icon;
        }

        public CmsPublishJobBase getJob() {
            return this.m_job;
        }

        public String getProject() {
            return this.m_job.getProjectName().replace("&#47;", "/");
        }

        public List<?> getResourceList() {
            if (this.m_resourceList == null) {
                if (this.m_job instanceof CmsPublishJobFinished) {
                    try {
                        this.m_resourceList = A_CmsUI.getCmsObject().readPublishedResources(this.m_job.getPublishHistoryId());
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                } else if (this.m_job instanceof CmsPublishJobEnqueued) {
                    this.m_resourceList = ((CmsPublishJobEnqueued)this.m_job).getOriginalPublishList().getAllResources();
                } else if (this.m_job instanceof CmsPublishJobRunning) {
                    CmsPublishList publishList = ((CmsPublishJobRunning)this.m_job).getOriginalPublishList();
                    this.m_resourceList = publishList == null ? Collections.emptyList() : publishList.getAllResources();
                }
            }
            return this.m_resourceList;
        }

        public String getResources() {
            List<?> resources = this.getResourceList();
            if (resources == null) {
                return "";
            }
            return CmsResourcesCellGenerator.formatResourcesForTable(resources, 50);
        }

        public int getSortType() {
            return this.m_sortType;
        }

        public Date getStart() {
            if (this.m_job instanceof CmsPublishJobFinished) {
                return new Date(((CmsPublishJobFinished)this.m_job).getStartTime());
            }
            if (this.m_job instanceof CmsPublishJobRunning) {
                return new Date(((CmsPublishJobRunning)this.m_job).getStartTime());
            }
            return null;
        }

        public String getStatus() {
            if (this.m_state == null) {
                if (this.m_job instanceof CmsPublishJobFinished) {
                    this.m_state = CmsQueuedTable.this.getState((CmsPublishJobFinished)this.m_job);
                } else if (this.m_job instanceof CmsPublishJobRunning) {
                    this.m_state = CmsQueuedTable.STATE_RUNNING;
                } else if (this.m_job instanceof CmsPublishJobEnqueued) {
                    this.m_state = CmsQueuedTable.STATE_ENQUEUE;
                } else {
                    this.m_state = CmsQueuedTable.STATE_ERROR;
                    LOG.error((Object)("Invalid job type: " + this.m_job));
                }
            }
            return this.m_state;
        }

        public String getStatusLocale() {
            String state = this.getStatus();
            String key = STATUS_MESSAGES.get(state);
            if (key == null) {
                LOG.error((Object)("KEY is null for state " + state));
            }
            return CmsVaadinUtils.getMessageText(key, new Object[0]);
        }

        public Date getStop() {
            if (this.m_job instanceof CmsPublishJobFinished) {
                return new Date(((CmsPublishJobFinished)this.m_job).getFinishTime());
            }
            return null;
        }

        public String getUser() {
            return this.m_job.getUserName(A_CmsUI.getCmsObject());
        }
    }

    class EntryStop
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryStop() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String jobid = data.iterator().next();
            CmsPublishJobBase job = OpenCms.getPublishManager().getJobByPublishHistoryId(new CmsUUID(jobid));
            if (job instanceof CmsPublishJobEnqueued) {
                try {
                    OpenCms.getPublishManager().abortPublishJob(A_CmsUI.getCmsObject(), (CmsPublishJobEnqueued)job, true);
                    CmsAppWorkplaceUi.get().reload();
                }
                catch (CmsException e) {
                    LOG.error((Object)"Error on aborting publish job.", (Throwable)e);
                }
            }
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PQUEUE_STOP_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryResources
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryResources() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsQueuedTable.this.showResourceDialog(data.iterator().next());
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PQUEUE_RESOURCES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryReport
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryReport() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsQueuedTable.this.showReportDialog(data.iterator().next());
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PQUEUE_REPORT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }
}

