/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.scheduler;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.BeanItem;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.scheduler.CmsJobBean;
import org.opencms.ui.apps.scheduler.CmsJobManagerApp;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;

public class CmsJobTable
extends Table {
    static final Log LOG = CmsLog.getLog(CmsJobTable.class);
    private static final long serialVersionUID = 1L;
    public CmsJobManagerApp m_manager;
    protected BeanItemContainer<CmsJobBean> m_beanContainer;
    private CmsContextMenu m_menu;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;

    public CmsJobTable(CmsJobManagerApp manager) {
        this.m_manager = manager;
        this.m_beanContainer = new BeanItemContainer(CmsJobBean.class);
        this.setContainerDataSource((Container)this.m_beanContainer);
        this.setVisibleColumns(new Object[]{TableProperty.className.toString(), TableProperty.name.toString(), TableProperty.lastExecution.toString(), TableProperty.nextExecution.toString()});
        this.setItemIconPropertyId(TableProperty.icon.toString());
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        for (TableProperty prop : TableProperty.withHeader()) {
            this.setColumnExpandRatio(prop.toString(), 1.0f);
            this.setColumnHeader(prop.toString(), CmsVaadinUtils.getMessageText(prop.getMessageKey(), new Object[0]));
        }
        this.setSortContainerPropertyId(TableProperty.name.toString());
        this.getVisibleColumns();
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -4738296706762013443L;

            public void itemClick(ItemClickEvent event) {
                CmsJobTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
            }
        });
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (TableProperty.className.toString().equals(propertyId)) {
                    return " o-hover-column";
                }
                CmsScheduledJobInfo job = ((CmsJobBean)((BeanItem)source.getItem(itemId)).getBean()).getJob();
                if (TableProperty.name.toString().equals(propertyId) & job.isActive()) {
                    return " o-in-navigation";
                }
                return null;
            }
        });
    }

    public static CmsResourceInfo getJobInfo(String name, String className) {
        return new CmsResourceInfo(name, className, (Resource)new CmsCssIcon("oc-icon-24-scheduler"));
    }

    public List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EditEntry());
            this.m_menuEntries.add(new ActivateEntry());
            this.m_menuEntries.add(new DeActivateEntry());
            this.m_menuEntries.add(new CopyEntry());
            this.m_menuEntries.add(new DeleteEntry());
            this.m_menuEntries.add(new RunEntry());
        }
        return this.m_menuEntries;
    }

    public void reloadJobs() {
        this.m_beanContainer.removeAllItems();
        for (CmsScheduledJobInfo job : this.m_manager.getAllElements()) {
            this.m_beanContainer.addBean((Object)new CmsJobBean(job));
        }
        this.sort();
        this.refreshRowCache();
    }

    public void setMenuEntries(List<I_CmsSimpleContextMenuEntry<Set<String>>> newEntries) {
        this.m_menuEntries = newEntries;
    }

    void editJob(String jobId) {
        String stateEdit = "edit";
        stateEdit = A_CmsWorkplaceApp.addParamToState(stateEdit, "jobId", jobId);
        CmsAppWorkplaceUi.get().showApp("scheduledjobs", stateEdit);
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            this.changeValueIfNotMultiSelect(itemId);
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || propertyId == null) {
                HashSet<String> jobIds = new HashSet<String>();
                for (CmsJobBean job : (Set)this.getValue()) {
                    jobIds.add(job.getJob().getId());
                }
                this.m_menu.setEntries(this.getMenuEntries(), jobIds);
                this.m_menu.openForTable(event, itemId, propertyId, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && TableProperty.className.toString().equals(propertyId)) {
                String jobId = ((CmsJobBean)((Set)this.getValue()).iterator().next()).getJob().getId();
                this.m_manager.defaultAction(jobId);
            }
        }
    }

    private void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    protected static enum TableProperty {
        className("className", "GUI_JOBS_LIST_COL_CLASS_0"),
        icon("icon", null),
        lastExecution("lastExecution", "GUI_JOBS_LIST_COL_LASTEXE_0"),
        name("name", "GUI_JOBS_LIST_COL_NAME_0"),
        nextExecution("nextExecution", "GUI_JOBS_LIST_COL_NEXTEXE_0");

        private String m_header;
        private String m_name;

        private TableProperty(String propName, String header) {
            this.m_header = header;
            this.m_name = propName;
        }

        static TableProperty get(String propName) {
            for (TableProperty prop : TableProperty.values()) {
                if (!prop.toString().equals(propName)) continue;
                return prop;
            }
            return null;
        }

        static Set<TableProperty> withHeader() {
            HashSet<TableProperty> ret = new HashSet<TableProperty>();
            for (TableProperty prop : TableProperty.values()) {
                if (prop.getMessageKey() == null) continue;
                ret.add(prop);
            }
            return ret;
        }

        public String toString() {
            return this.m_name;
        }

        String getMessageKey() {
            return this.m_header;
        }
    }

    class EditEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EditEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsJobTable.this.m_manager.openEditDialog(data.iterator().next(), false);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText(Action.edit.getMessageKey(), new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 && CmsJobTable.this.m_manager.getElement(data.iterator().next()) != null ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class ActivateEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ActivateEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsScheduledJobInfo job = ((CmsJobBean)((Set)CmsJobTable.this.getValue()).iterator().next()).getJob();
            CmsScheduledJobInfo jobClone = job.clone();
            jobClone.setActive(!job.isActive());
            CmsJobTable.this.m_manager.writeElement(jobClone);
            CmsJobTable.this.reloadJobs();
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText(Action.activation.getMessageKey(), new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() > 1 || CmsJobTable.this.m_manager.getElement(data.iterator().next()) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            CmsScheduledJobInfo job = ((CmsJobBean)((Set)CmsJobTable.this.getValue()).iterator().next()).getJob();
            return !job.isActive() ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class DeActivateEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        DeActivateEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsScheduledJobInfo job = ((CmsJobBean)((Set)CmsJobTable.this.getValue()).iterator().next()).getJob();
            CmsScheduledJobInfo jobClone = job.clone();
            jobClone.setActive(!job.isActive());
            CmsJobTable.this.m_manager.writeElement(jobClone);
            CmsJobTable.this.reloadJobs();
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText(Action.activation.getActivatedMessageKey(), new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() > 1 || CmsJobTable.this.m_manager.getElement(data.iterator().next()) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            CmsScheduledJobInfo job = ((CmsJobBean)((Set)CmsJobTable.this.getValue()).iterator().next()).getJob();
            return job.isActive() ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class CopyEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        CopyEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsJobTable.this.m_manager.openEditDialog(data.iterator().next(), true);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText(Action.copy.getMessageKey(), new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 && CmsJobTable.this.m_manager.getElement(data.iterator().next()) != null ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class DeleteEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        DeleteEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            Object jobNames = "";
            final ArrayList<String> jobIds = new ArrayList<String>();
            ArrayList<CmsResourceInfo> jobInfos = new ArrayList<CmsResourceInfo>();
            for (CmsJobBean job : (Set)CmsJobTable.this.getValue()) {
                jobIds.add(job.getJob().getId());
                jobNames = (String)jobNames + job.getName() + ", ";
                jobInfos.add(CmsJobTable.getJobInfo(job.getName(), job.getClassName()));
            }
            if (!((String)jobNames).isEmpty()) {
                jobNames = ((String)jobNames).substring(0, ((String)jobNames).length() - 2);
            }
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText(Action.delete.getMessageKey(), new Object[0]), CmsVaadinUtils.getMessageText("GUI_SCHEDULER_CONFIRM_DELETE_1", jobNames), new Runnable(){

                @Override
                public void run() {
                    CmsJobTable.this.m_manager.deleteElements(jobIds);
                    CmsJobTable.this.reloadJobs();
                }
            }).displayResourceInfoDirectly(jobInfos);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText(Action.delete.getMessageKey(), new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() > 0 && CmsJobTable.this.m_manager.getElement(data.iterator().next()) != null ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class RunEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        RunEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            final CmsScheduledJobInfo job = ((CmsJobBean)((Set)CmsJobTable.this.getValue()).iterator().next()).getJob();
            CmsConfirmationDialog.show(CmsVaadinUtils.getMessageText(Action.run.getMessageKey(), new Object[0]), CmsVaadinUtils.getMessageText("GUI_SCHEDULER_CONFIRM_EXECUTE_1", job.getJobName()), new Runnable(){

                @Override
                public void run() {
                    CmsJobTable.this.m_manager.runJob(job);
                }
            }).displayResourceInfoDirectly(Collections.singletonList(CmsJobTable.getJobInfo(job.getJobName(), job.getClassName())));
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText(Action.run.getMessageKey(), new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 && CmsJobTable.this.m_manager.getElement(data.iterator().next()) != null ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    static enum Action {
        activation("GUI_JOBS_LIST_ACTION_MACTIVATE_NAME_0", "GUI_JOBS_LIST_ACTION_MDEACTIVATE_NAME_0"),
        copy("GUI_JOBS_LIST_ACTION_COPY_NAME_0", ""),
        delete("GUI_JOBS_LIST_ACTION_DELETE_NAME_0", ""),
        edit("GUI_JOBS_LIST_ACTION_EDIT_NAME_0", ""),
        run("GUI_JOBS_LIST_ACTION_EXECUTE_NAME_0", "");

        private String m_key;
        private String m_keyActivated;

        private Action(String key, String activatedKey) {
            this.m_key = key;
            this.m_keyActivated = activatedKey;
        }

        String getActivatedMessageKey() {
            return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_keyActivated) ? this.m_key : this.m_keyActivated;
        }

        String getMessageKey() {
            return this.m_key;
        }
    }
}

