/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.searchindex;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.util.Iterator;
import java.util.List;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.I_CmsCRUDApp;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsSourceDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 4302977301857481351L;
    private Button m_cancelButton;
    private FormLayout m_layout;
    private I_CmsCRUDApp<I_CmsSearchIndex> m_manager;

    public CmsSourceDialog(I_CmsCRUDApp<I_CmsSearchIndex> app, final Runnable cancel) {
        this.m_manager = app;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -4321889329235244258L;

            public void buttonClick(Button.ClickEvent event) {
                cancel.run();
            }
        });
    }

    public void setSource(String searchindex) {
        Label label = new Label();
        label.setContentMode(ContentMode.HTML);
        label.setValue(this.getSources(searchindex));
        this.m_layout.removeAllComponents();
        this.m_layout.addComponent((Component)label);
    }

    private String getSources(String indexName) {
        StringBuffer html = new StringBuffer();
        I_CmsSearchIndex idx = this.m_manager.getElement(indexName);
        html.append("<ul>\n");
        for (CmsSearchIndexSource idxSource : idx.getSources()) {
            html.append("  <li>\n").append("    ").append("name      : ").append(idxSource.getName()).append("\n");
            html.append("  </li>");
            html.append("  <li>\n").append("    ").append("indexer   : ").append(idxSource.getIndexerClassName()).append("\n");
            html.append("  </li>");
            html.append("  <li>\n").append("    ").append("resources : ").append("\n");
            html.append("    <ul>\n");
            List<String> resources = idxSource.getResourcesNames();
            Iterator<String> itResources = resources.iterator();
            while (itResources.hasNext()) {
                html.append("    <li>\n").append("      ").append(itResources.next()).append("\n");
                html.append("    </li>\n");
            }
            html.append("    </ul>\n");
            html.append("  </li>");
            html.append("  <li>\n").append("    ").append("doctypes : ").append("\n");
            html.append("    <ul>\n");
            resources = idxSource.getDocumentTypes();
            itResources = resources.iterator();
            while (itResources.hasNext()) {
                html.append("    <li>\n").append("      ").append(itResources.next()).append("\n");
                html.append("    </li>\n");
            }
            html.append("    </ul>\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        return html.toString();
    }
}

