/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.event.MouseEvents;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsPageEditorConfiguration;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.sessions.CmsKillSessionDialog;
import org.opencms.ui.apps.sessions.CmsSessionsApp;
import org.opencms.ui.apps.sessions.CmsUserInfoDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSessionsTable
extends Table {
    static Log LOG = CmsLog.getLog(CmsSessionsTable.class.getName());
    public static final long INACTIVE_LIMIT = 450000L;
    private static final long serialVersionUID = 4136423899776482696L;
    protected String m_mySessionId;
    private IndexedContainer m_container;
    private CmsContextMenu m_menu;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;

    public CmsSessionsTable() {
        try {
            this.m_mySessionId = OpenCms.getSessionManager().getSessionInfo(CmsVaadinUtils.getRequest()).getSessionId().getStringValue();
            this.ini();
            this.setColumnWidth((Object)TableProperty.IS_ACTIVE, 80);
            this.addGeneratedColumn((Object)TableProperty.Icon, new Table.ColumnGenerator(){
                private static final long serialVersionUID = 1431421875590401227L;

                public Object generateCell(Table source, Object itemId, Object columnId) {
                    CmsCssIcon icon = new CmsCssIcon("oc-icon-24-session");
                    if (((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.IS_WAITING).getValue()).booleanValue()) {
                        icon.setOverlay("o-state-changed oc-icon-16-overlay-changed");
                    }
                    return new Label(icon.getHtmlWithOverlay(), ContentMode.HTML);
                }
            });
            this.setCellStyleGenerator(new Table.CellStyleGenerator(){
                private static final long serialVersionUID = 1L;

                public String getStyle(Table source, Object itemId, Object propertyId) {
                    String furtherClass = "";
                    if (CmsSessionsTable.this.m_mySessionId.equals(itemId)) {
                        furtherClass = " o-in-navigation";
                    }
                    if (TableProperty.UserName.equals(propertyId)) {
                        return " o-hover-column" + furtherClass;
                    }
                    if ((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.IS_WAITING).getValue() & propertyId == null) {
                        return " o-state-changed";
                    }
                    if (TableProperty.IS_ACTIVE.equals(propertyId)) {
                        return CmsUserInfoDialog.getStatusStyleForItem((Long)source.getItem(itemId).getItemProperty((Object)TableProperty.IS_ACTIVE).getValue());
                    }
                    return null;
                }
            });
            this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
                private static final long serialVersionUID = 7957778390938304845L;

                public void itemClick(ItemClickEvent event) {
                    CmsSessionsTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
                }
            });
            this.addGeneratedColumn((Object)TableProperty.IS_ACTIVE, new Table.ColumnGenerator(){
                private static final long serialVersionUID = -6781906011584975559L;

                public Object generateCell(Table source, Object itemId, Object columnId) {
                    return CmsUserInfoDialog.getStatusForItem((Long)source.getItem(itemId).getItemProperty((Object)TableProperty.IS_ACTIVE).getValue());
                }
            });
            this.setItemDescriptionGenerator(new AbstractSelect.ItemDescriptionGenerator(){
                private static final long serialVersionUID = 7367011213487089661L;

                public String generateDescription(Component source, Object itemId, Object propertyId) {
                    if (TableProperty.IS_ACTIVE.equals(propertyId)) {
                        String[] ret = CmsSessionInfo.getHourMinuteSecondTimeString((Long)((Table)source).getItem(itemId).getItemProperty(propertyId).getValue());
                        if (Integer.parseInt(ret[1]) == 1) {
                            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_LAST_ACTIVITY_ONE_MINUTE_0", new Object[0]);
                        }
                        if (Integer.parseInt(ret[1]) == 0) {
                            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_LAST_ACTIVITY_LESS_ONE_MINUTE_0", new Object[0]);
                        }
                        return CmsVaadinUtils.getMessageText("GUI_MESSAGES_LAST_ACTIVITY_MINUTES_1", Integer.valueOf(ret[1]));
                    }
                    return null;
                }
            });
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read sessions", (Throwable)e);
        }
    }

    protected static Runnable getCloseRunnable(final Window window, final CmsSessionsTable table) {
        return new Runnable(){

            @Override
            public void run() {
                window.close();
                try {
                    table.ini();
                }
                catch (CmsException e) {
                    LOG.error((Object)"Error on reading session information", (Throwable)e);
                }
            }
        };
    }

    protected static void showKillDialog(Set<String> ids, String caption, CmsSessionsTable table) {
        Window window = CmsBasicDialog.prepareWindow();
        window.setCaption(caption);
        window.setContent((Component)new CmsKillSessionDialog(ids, CmsSessionsTable.getCloseRunnable(window, table)));
        A_CmsUI.get().addWindow(window);
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.UserName, search, true, false), new SimpleStringFilter((Object)TableProperty.Site, search, true, false), new SimpleStringFilter((Object)TableProperty.Project, search, true, false)}));
        }
        if (this.getValue() != null & !((Set)this.getValue()).isEmpty()) {
            this.setCurrentPageFirstItemId(((Set)this.getValue()).iterator().next());
        }
    }

    protected void ini() throws CmsException {
        if (this.m_container == null) {
            this.m_container = new IndexedContainer();
            this.setContainerDataSource((Container)this.m_container);
        } else {
            this.m_container.removeAllItems();
        }
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefaultValue());
            this.setColumnHeader((Object)prop, prop.getLocalizedMessage());
        }
        this.setColumnWidth((Object)TableProperty.Icon, 40);
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        List<CmsSessionInfo> sessionInfos = OpenCms.getSessionManager().getSessionInfos();
        List<CmsOrganizationalUnit> manageableOus = OpenCms.getRoleManager().getManageableOrgUnits(A_CmsUI.getCmsObject(), "", true, false);
        for (CmsSessionInfo session : sessionInfos) {
            CmsUser user = A_CmsUI.getCmsObject().readUser(session.getUserId());
            CmsOrganizationalUnit userOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), user.getOuFqn());
            if (!manageableOus.contains(userOu) || user.isWebuser()) continue;
            Item item = this.m_container.addItem((Object)session.getSessionId().getStringValue());
            item.getItemProperty((Object)TableProperty.UserName).setValue((Object)user.getName());
            item.getItemProperty((Object)TableProperty.DateCreated).setValue((Object)(session.getAgeOfSession() + " " + CmsVaadinUtils.getMessageText("GUI_MESSAGES_HOUR_0", new Object[0])));
            item.getItemProperty((Object)TableProperty.IS_ACTIVE).setValue((Object)(System.currentTimeMillis() - session.getTimeLastAction()));
            item.getItemProperty((Object)TableProperty.OrgUnit).setValue((Object)userOu.getName());
            item.getItemProperty((Object)TableProperty.Project).setValue((Object)A_CmsUI.getCmsObject().readProject(session.getProject()).getName());
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(session.getSiteRoot());
            String siteTitle = site == null ? CmsVaadinUtils.getMessageText("GUI_ROOT_SITE_0", new Object[0]) : site.getTitle();
            item.getItemProperty((Object)TableProperty.Site).setValue((Object)siteTitle);
            item.getItemProperty((Object)TableProperty.IS_WAITING).setValue((Object)(!session.getBroadcastQueue().isEmpty() ? 1 : 0));
        }
        this.setVisibleColumns(new Object[]{TableProperty.Icon, TableProperty.IS_ACTIVE, TableProperty.UserName, TableProperty.DateCreated, TableProperty.Site, TableProperty.Project});
    }

    protected void showUserInfoWindow(String data) {
        CmsUserInfoDialog.showUserInfo(OpenCms.getSessionManager().getSessionInfo(data));
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new UserEntry());
            this.m_menuEntries.add(new ExplorerEntry());
            this.m_menuEntries.add(new PageEditorEntry());
            this.m_menuEntries.add(new SendBroadcastEntry());
            this.m_menuEntries.add(new KillEntry());
        }
        return this.m_menuEntries;
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            this.changeValueIfNotMultiSelect(itemId);
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || TableProperty.Icon.equals(propertyId)) {
                this.m_menu.setEntries(this.getMenuEntries(), (Set)this.getValue());
                this.m_menu.openForTable(event, itemId, propertyId, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && TableProperty.UserName.equals(propertyId)) {
                this.showUserInfoWindow((String)((Set)this.getValue()).iterator().next());
            }
        }
    }

    private void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    static enum TableProperty {
        DateCreated("GUI_MESSAGES_BROADCAST_COLS_CREATION_0", String.class, "", false),
        Icon(null, Label.class, null, false),
        IS_ACTIVE("GUI_MESSAGES_BROADCAST_COLS_STATUS_0", Long.class, 0L, false),
        IS_WAITING(null, Boolean.class, false, false),
        OrgUnit("GUI_MESSAGES_BROADCAST_COLS_ORGUNIT_0", String.class, "", false),
        Project("GUI_MESSAGES_BROADCAST_COLS_PROJECT_0", String.class, "", false),
        Site("GUI_MESSAGES_BROADCAST_COLS_SITE_0", String.class, "", false),
        UserName("GUI_MESSAGES_BROADCAST_COLS_USER_0", String.class, "", false);

        private boolean m_collapsable;
        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String headerMessage, Class<?> type, Object defaultValue, boolean collapsable) {
            this.m_headerMessage = headerMessage;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
            this.m_collapsable = collapsable;
        }

        static List<TableProperty> withHeader() {
            ArrayList<TableProperty> props = new ArrayList<TableProperty>();
            for (TableProperty prop : TableProperty.values()) {
                if (prop.m_headerMessage == null) continue;
                props.add(prop);
            }
            return props;
        }

        Object getDefaultValue() {
            return this.m_defaultValue;
        }

        String getLocalizedMessage() {
            if (this.m_headerMessage == null) {
                return "";
            }
            return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
        }

        Class<?> getType() {
            return this.m_type;
        }

        boolean isCollapsable() {
            return this.m_collapsable;
        }
    }

    class UserEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        UserEntry() {
        }

        @Override
        public void executeAction(Set<String> context) {
            CmsSessionsTable.this.showUserInfoWindow(context.iterator().next());
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_SHOW_USER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class ExplorerEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ExplorerEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            try {
                String sessionId = data.iterator().next();
                CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(new CmsUUID(sessionId));
                String siteRoot = session.getSiteRoot();
                A_CmsUI.getCmsObject().getRequestContext().setSiteRoot(siteRoot);
                A_CmsUI.getCmsObject().getRequestContext().setCurrentProject(A_CmsUI.getCmsObject().readProject(session.getProject()));
                CmsAppWorkplaceUi.get().getNavigator().navigateTo("explorer/" + session.getProject() + "!!" + siteRoot + "!!");
            }
            catch (CmsException e) {
                LOG.error((Object)"Cannot read project", (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return Messages.get().getBundle(locale).key("GUI_EXPLORER_TITLE_0");
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class PageEditorEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        PageEditorEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            try {
                String sessionId = data.iterator().next();
                CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(new CmsUUID(sessionId));
                String siteRoot = session.getSiteRoot();
                A_CmsUI.get().changeSite(siteRoot);
                A_CmsUI.get().changeProject(A_CmsUI.getCmsObject().readProject(session.getProject()));
                CmsPageEditorConfiguration pageeditorApp = new CmsPageEditorConfiguration();
                pageeditorApp.getAppLaunchCommand().run();
            }
            catch (CmsException e) {
                LOG.error((Object)"Cannot read project", (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PAGEEDITOR_TITLE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            String sessionId = data.iterator().next();
            CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(new CmsUUID(sessionId));
            String siteRoot = session.getSiteRoot();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(siteRoot) || OpenCms.getSiteManager().getSharedFolder().startsWith(siteRoot)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class SendBroadcastEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        SendBroadcastEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsSessionsApp.showSendBroadcastDialog(data, CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_SESSIONS_1", CmsSessionsApp.getUserNames(data, CmsVaadinUtils.getMessageText("GUI_MESSAGES_AND_0", new Object[0]))), CmsSessionsTable.this);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_SEND_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class KillEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        KillEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsSessionsTable.showKillDialog(data, CmsVaadinUtils.getMessageText("GUI_MESSAGES_DESTROY_SESSIONS_1", CmsSessionsApp.getUserNames(data, CmsVaadinUtils.getMessageText("GUI_MESSAGES_AND_0", new Object[0]))), CmsSessionsTable.this);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_DESTROY_SESSION_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data.size() == 1 & data.iterator().next().equals(CmsSessionsTable.this.m_mySessionId)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }
}

