/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsPageEditorConfiguration;
import org.opencms.ui.apps.CmsSitemapEditorConfiguration;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.sitemanager.CmsExportSiteForm;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.apps.user.I_CmsFilterableTable;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSitesTable
extends Table
implements I_CmsFilterableTable {
    protected static Log LOG = CmsLog.getLog(CmsSitesTable.class.getName());
    private static final long serialVersionUID = 4655464609332605219L;
    public CmsSiteManager m_manager;
    protected List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private IndexedContainer m_container;
    private CmsContextMenu m_menu;
    private int m_siteCounter;

    public CmsSitesTable(CmsSiteManager manager) {
        this.m_manager = manager;
        this.m_container = new IndexedContainer();
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefault());
            this.setColumnHeader((Object)prop, prop.getName());
        }
        this.setContainerDataSource((Container)this.m_container);
        this.setColumnAlignment((Object)TableProperty.Favicon, Table.Align.CENTER);
        this.setColumnExpandRatio((Object)TableProperty.Server, 2.0f);
        this.setColumnExpandRatio((Object)TableProperty.Title, 2.0f);
        this.setColumnExpandRatio((Object)TableProperty.Path, 2.0f);
        this.setColumnWidth((Object)TableProperty.Favicon, 40);
        this.setColumnWidth((Object)TableProperty.SSL, 130);
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsSitesTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                Object styles = "";
                if (TableProperty.SSL.equals(propertyId)) {
                    styles = (String)styles + " " + CmsSitesTable.getSSLStyle((CmsSite)source.getItem(itemId).getItemProperty((Object)TableProperty.CmsSite).getValue());
                }
                if (TableProperty.Server.equals(propertyId)) {
                    styles = (String)styles + " o-hover-column";
                    if (!((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.OK).getValue()).booleanValue()) {
                        styles = ((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.Changed).getValue()).booleanValue() ? (String)styles + " o-state-changed" : (String)styles + " o-expired";
                    } else if (((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.New).getValue()).booleanValue()) {
                        styles = (String)styles + " o-state-new";
                    }
                }
                if (TableProperty.Title.equals(propertyId) & (Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.Is_Webserver).getValue()) {
                    styles = (String)styles + " o-in-navigation";
                }
                if (((String)styles).isEmpty()) {
                    return null;
                }
                return styles;
            }
        });
        this.addGeneratedColumn((Object)TableProperty.SSL, new Table.ColumnGenerator(){
            private static final long serialVersionUID = -2144476865774782965L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                return CmsSitesTable.this.getSSLStatus((CmsSite)source.getItem(itemId).getItemProperty((Object)TableProperty.CmsSite).getValue());
            }
        });
        this.addGeneratedColumn((Object)TableProperty.Favicon, new FavIconColumn());
        this.setItemDescriptionGenerator(new AbstractSelect.ItemDescriptionGenerator(){
            private static final long serialVersionUID = 7367011213487089661L;

            public String generateDescription(Component source, Object itemId, Object propertyId) {
                if (TableProperty.Favicon.equals(propertyId)) {
                    return ((CmsSite)((Table)source).getItem(itemId).getItemProperty((Object)TableProperty.CmsSite).getValue()).getSSLMode().getLocalizedMessage();
                }
                return null;
            }
        });
        this.setColumnCollapsingAllowed(false);
        this.setVisibleColumns(new Object[]{TableProperty.Icon, TableProperty.SSL, TableProperty.Favicon, TableProperty.Server, TableProperty.Title, TableProperty.Path});
        this.setColumnWidth((Object)TableProperty.Icon, 40);
    }

    public static String getSSLStyle(CmsSite site) {
        if (site != null && site.getSSLMode().isSecure()) {
            return " o-box-cyan";
        }
        return " o-box-gray";
    }

    @Override
    public void filter(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.Title, search, true, false), new SimpleStringFilter((Object)TableProperty.Path, search, true, false), new SimpleStringFilter((Object)TableProperty.Server, search, true, false)}));
        }
        if (this.getValue() != null & !((Set)this.getValue()).isEmpty()) {
            this.setCurrentPageFirstItemId(((Set)this.getValue()).iterator().next());
        }
    }

    public IndexedContainer getContainer() {
        return this.m_container;
    }

    @Override
    public VerticalLayout getEmptyLayout() {
        return null;
    }

    public List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EditEntry());
            this.m_menuEntries.add(new DeleteEntry());
            this.m_menuEntries.add(new ExplorerEntry());
            this.m_menuEntries.add(new PageEditorEntry());
            this.m_menuEntries.add(new ExportEntry());
        }
        return this.m_menuEntries;
    }

    public int getSitesCount() {
        return this.m_siteCounter;
    }

    public void loadSites() {
        Item item;
        this.m_container.removeAllItems();
        List<CmsSite> sites = this.m_manager.getAllElements();
        this.m_siteCounter = 0;
        CmsCssIcon icon = new CmsCssIcon("oc-icon-24-site");
        icon.setOverlay("o-state-changed oc-icon-16-overlay-changed");
        for (CmsSite site : sites) {
            if (site.getSiteMatcher() == null) continue;
            ++this.m_siteCounter;
            item = this.m_container.addItem((Object)site.getSiteRoot());
            item.getItemProperty((Object)TableProperty.CmsSite).setValue((Object)site);
            item.getItemProperty((Object)TableProperty.Server).setValue((Object)site.getUrl());
            item.getItemProperty((Object)TableProperty.Title).setValue((Object)site.getTitle());
            item.getItemProperty((Object)TableProperty.Is_Webserver).setValue((Object)site.isWebserver());
            item.getItemProperty((Object)TableProperty.Path).setValue((Object)site.getSiteRoot());
            if (OpenCms.getSiteManager().isOnlyOfflineSite(site)) {
                item.getItemProperty((Object)TableProperty.New).setValue((Object)true);
                item.getItemProperty((Object)TableProperty.Icon).setValue((Object)new Label(icon.getHtmlWithOverlay(), ContentMode.HTML));
            } else {
                item.getItemProperty((Object)TableProperty.Icon).setValue((Object)new Label(icon.getHtml(), ContentMode.HTML));
            }
            item.getItemProperty((Object)TableProperty.OK).setValue((Object)this.isNotNestedSite(site, sites));
        }
        for (CmsSite site : this.m_manager.getCorruptedSites()) {
            item = this.m_container.addItem((Object)site.getSiteRoot());
            if (item == null) continue;
            item.getItemProperty((Object)TableProperty.CmsSite).setValue((Object)site);
            item.getItemProperty((Object)TableProperty.Icon).setValue((Object)new Label(icon.getHtml(), ContentMode.HTML));
            item.getItemProperty((Object)TableProperty.Server).setValue((Object)site.getUrl());
            item.getItemProperty((Object)TableProperty.Title).setValue((Object)site.getTitle());
            item.getItemProperty((Object)TableProperty.Is_Webserver).setValue((Object)site.isWebserver());
            item.getItemProperty((Object)TableProperty.Path).setValue((Object)site.getSiteRoot());
            item.getItemProperty((Object)TableProperty.OK).setValue((Object)false);
            if (site.getSiteRootUUID().isNullUUID() || !this.m_manager.getRootCmsObject().existsResource(site.getSiteRootUUID())) continue;
            item.getItemProperty((Object)TableProperty.Changed).setValue((Object)true);
            item.getItemProperty((Object)TableProperty.Icon).setValue((Object)new Label(icon.getHtmlWithOverlay(), ContentMode.HTML));
        }
    }

    public void setMenuEntries(List<I_CmsSimpleContextMenuEntry<Set<String>>> newEntries) {
        this.m_menuEntries = newEntries;
    }

    protected String getSSLStatus(CmsSite site) {
        if (site != null && site.getSSLMode().isSecure()) {
            return CmsVaadinUtils.getMessageText("GUI_SITE_ENCRYPTED_0", new Object[0]);
        }
        return CmsVaadinUtils.getMessageText("GUI_SITE_UNENCRYPTED_0", new Object[0]);
    }

    Image getImageFavIcon(final String itemId) {
        Resource resource = this.getFavIconResource(itemId);
        if (resource != null) {
            Image favIconImage = new Image("", resource);
            favIconImage.setWidth("24px");
            favIconImage.setDescription(CmsVaadinUtils.getMessageText("GUI_SITE_FAVICON_0", new Object[0]));
            favIconImage.addClickListener(new MouseEvents.ClickListener(){
                private static final long serialVersionUID = 5954790734673665522L;

                public void click(MouseEvents.ClickEvent event) {
                    CmsSitesTable.this.onItemClick(event, itemId, (Object)TableProperty.Favicon);
                }
            });
            return favIconImage;
        }
        return null;
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            this.changeValueIfNotMultiSelect(itemId);
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || propertyId == TableProperty.Icon) {
                this.m_menu.setEntries(this.getMenuEntries(), (Set)this.getValue());
                this.m_menu.openForTable(event, itemId, propertyId, this);
            } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && TableProperty.Server.equals(propertyId)) {
                String siteRoot = (String)itemId;
                this.m_manager.defaultAction(siteRoot);
            }
        }
    }

    private void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    private Resource getFavIconResource(String siteRoot) {
        try {
            CmsResource favicon = this.m_manager.getRootCmsObject().readResource(siteRoot + "/favicon.ico");
            CmsFile faviconFile = this.m_manager.getRootCmsObject().readFile(favicon);
            final byte[] imageData = faviconFile.getContents();
            return new StreamResource(new StreamResource.StreamSource(){
                private static final long serialVersionUID = -8868657402793427460L;

                public InputStream getStream() {
                    return new ByteArrayInputStream(imageData);
                }
            }, "");
        }
        catch (CmsException e) {
            return null;
        }
    }

    private Boolean isNotNestedSite(CmsSite site, List<CmsSite> sites) {
        for (CmsSite s : sites) {
            if (!(site.getSiteRoot().length() > s.getSiteRoot().length() & site.getSiteRoot().startsWith(CmsFileUtil.addTrailingSeparator(s.getSiteRoot())))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected static enum TableProperty {
        Changed("", Boolean.class, false),
        CmsSite("", CmsSite.class, null),
        Favicon("", Image.class, null),
        Icon(null, Label.class, new Label(new CmsCssIcon("oc-icon-24-site").getHtml(), ContentMode.HTML)),
        Is_Webserver("", Boolean.class, true),
        New("", Boolean.class, false),
        OK("", Boolean.class, true),
        Path("GUI_SITE_PATH_0", String.class, ""),
        Server("GUI_SITE_SERVER_0", String.class, ""),
        SSL("", Integer.class, 1),
        Title("GUI_SITE_TITLE_0", String.class, ""),
        Under_Other_Site("", Boolean.class, false);

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String name, Class<?> type, Object defaultValue) {
            this.m_headerMessage = name;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        Object getDefault() {
            return this.m_defaultValue;
        }

        String getName() {
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_headerMessage)) {
                return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
            }
            return "";
        }

        Class<?> getType() {
            return this.m_type;
        }
    }

    class FavIconColumn
    implements Table.ColumnGenerator {
        private static final long serialVersionUID = -3772456970393398685L;

        FavIconColumn() {
        }

        public Object generateCell(Table source, Object itemId, Object columnId) {
            return CmsSitesTable.this.getImageFavIcon((String)itemId);
        }
    }

    public class EditEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        @Override
        public void executeAction(Set<String> data) {
            String siteRoot = data.iterator().next();
            CmsSitesTable.this.m_manager.openEditDialog(siteRoot);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_EDIT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() != 1 || CmsSitesTable.this.m_manager.getElement(data.iterator().next()) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class DeleteEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        DeleteEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            CmsSitesTable.this.m_manager.openDeleteDialog(data);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PROJECTS_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (CmsSitesTable.this.m_manager.getElement(data.iterator().next()) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class ExplorerEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ExplorerEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String siteRoot = data.iterator().next();
            A_CmsUI.getCmsObject().getRequestContext().setSiteRoot(siteRoot);
            CmsAppWorkplaceUi.get().showApp("explorer", A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getUuid() + "!!" + siteRoot + "!!");
        }

        @Override
        public String getTitle(Locale locale) {
            return Messages.get().getBundle(locale).key("GUI_EXPLORER_TITLE_0");
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            try {
                CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                if (cms.existsResource(data.iterator().next())) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to inti OpenCms Object", (Throwable)e);
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
        }
    }

    class PageEditorEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        PageEditorEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String siteRoot = data.iterator().next();
            A_CmsUI.get().changeSite(siteRoot);
            CmsPageEditorConfiguration pageeditorApp = new CmsPageEditorConfiguration();
            pageeditorApp.getAppLaunchCommand().run();
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_PAGEEDITOR_TITLE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (data.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            String siteRoot = data.iterator().next();
            if (CmsSitesTable.this.m_manager.getElement(siteRoot) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (!((Boolean)CmsSitesTable.this.getItem(siteRoot).getItemProperty((Object)TableProperty.OK).getValue()).booleanValue()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    public class ExportEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        @Override
        public void executeAction(Set<String> context) {
            CmsExportSiteForm form = new CmsExportSiteForm(A_CmsUI.getCmsObject(), CmsSitesTable.this.m_manager, context.iterator().next());
            CmsSitesTable.this.m_manager.openDialog(form, CmsVaadinUtils.getMessageText("GUI_SITE_EXPORT_DIALOG_CAPTION_0", new Object[0]));
        }

        @Override
        public String getTitle(Locale locale) {
            return Messages.get().getBundle(locale).key("GUI_SITE_EXPORT_0");
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() != 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            return CmsSitesTable.this.m_manager.isExportEnabled() && OpenCms.getRoleManager().hasRole(A_CmsUI.getCmsObject(), CmsRole.DATABASE_MANAGER) ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class SitemapEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        SitemapEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String siteRoot = data.iterator().next();
            A_CmsUI.get().changeSite(siteRoot);
            CmsSitemapEditorConfiguration sitemapApp = new CmsSitemapEditorConfiguration();
            sitemapApp.getAppLaunchCommand().run();
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_SITEMAP_TITLE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null || data.size() != 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            String siteRoot = data.iterator().next();
            if (CmsSitesTable.this.m_manager.getElement(siteRoot) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }
}

