/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsGroupEditParameters;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsUUID;

public class CmsGroupEditDialog
extends CmsBasicDialog {
    static Log LOG = CmsLog.getLog(CmsGroupEditDialog.class.getName());
    private static final long serialVersionUID = 6633733627052633351L;
    Button m_ok;
    private CmsAccountsApp m_app;
    private Button m_cancel;
    private CmsObject m_cms;
    private TextArea m_description;
    private CheckBox m_enabled;
    private CmsGroup m_group;
    private CmsGroupEditParameters m_groupEditParameters = new CmsGroupEditParameters();
    private TextField m_name;
    private Label m_ou;

    public CmsGroupEditDialog(CmsObject cms, CmsUUID groupId, final Window window, final CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cms = cms;
        this.m_app = app;
        try {
            if (groupId != null) {
                this.m_group = this.m_cms.readGroup(groupId);
                this.m_groupEditParameters = this.m_app.getGroupEditParameters(this.m_group);
                this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_group)));
                this.m_ou.setValue(this.m_group.getOuFqn());
                this.m_name.setValue(this.m_group.getSimpleName());
                this.m_name.setEnabled(false);
                this.m_description.setValue(this.m_group.getDescription());
                this.m_enabled.setValue((Object)this.m_group.isEnabled());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to read group", (Throwable)e);
        }
        this.m_ok.setEnabled(false);
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 2337532424806798793L;

            public void buttonClick(Button.ClickEvent event) {
                CmsGroupEditDialog.this.saveGroup();
                window.close();
                app.reload();
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -6389260624197980323L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        Property.ValueChangeListener listener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = -7480617292190495288L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsGroupEditDialog.this.m_ok.setEnabled(true);
            }
        };
        this.m_enabled.addValueChangeListener(listener);
        this.m_description.addValueChangeListener(listener);
        this.m_name.addValueChangeListener(listener);
        if (!this.m_groupEditParameters.isEditable()) {
            this.m_description.setEnabled(false);
            this.m_enabled.setEnabled(false);
        }
    }

    public CmsGroupEditDialog(CmsObject cms, Window window, String ou, CmsAccountsApp app) {
        this(cms, null, window, app);
        this.m_ou.setValue(ou);
        this.m_enabled.setValue((Object)true);
    }

    protected void saveGroup() {
        if (this.m_group == null) {
            this.m_group = new CmsGroup();
            Object ou = this.m_ou.getValue();
            if (!((String)ou).endsWith("/")) {
                ou = (String)ou + "/";
            }
            this.m_group.setName((String)this.m_name.getValue());
            try {
                this.m_cms.createGroup((String)ou + (String)this.m_name.getValue(), (String)this.m_description.getValue(), 0, null);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        this.m_group.setDescription((String)this.m_description.getValue());
        this.m_group.setEnabled((Boolean)this.m_enabled.getValue());
        try {
            this.m_cms.writeGroup(this.m_group);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }
}

