/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;

public class CmsOUHandler {
    private List<String> m_managableOU;
    private CmsObject m_cms;
    private boolean m_isRootAccountManager;
    private Map<String, Boolean> m_isParentOfOU = new HashMap<String, Boolean>();

    public CmsOUHandler(CmsObject cms) {
        this.m_cms = cms;
        this.m_isRootAccountManager = OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(""));
        if (!this.m_isRootAccountManager) {
            this.m_managableOU = CmsOUHandler.getManagableOUs(cms);
        }
    }

    public static List<String> getManagableOUs(CmsObject cms) {
        ArrayList<String> ous = new ArrayList<String>();
        try {
            for (CmsRole role : OpenCms.getRoleManager().getRolesOfUser(cms, cms.getRequestContext().getCurrentUser().getName(), "", true, false, true)) {
                if (!role.getRoleName().equals(CmsRole.ACCOUNT_MANAGER.getRoleName())) continue;
                if (role.getOuFqn().equals("")) {
                    ous.add(0, role.getOuFqn());
                    continue;
                }
                ous.add(role.getOuFqn());
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return ous;
    }

    public String getBaseOU() {
        if (this.m_isRootAccountManager) {
            return "";
        }
        if (this.m_managableOU.contains("")) {
            return "";
        }
        String base = this.m_managableOU.get(0);
        for (String ou : this.m_managableOU) {
            while (!ou.startsWith(base)) {
                if ((base = base.substring(0, base.length() - 1)).lastIndexOf("/") > -1) {
                    base = base.substring(0, base.lastIndexOf("/"));
                    continue;
                }
                return "";
            }
        }
        return base;
    }

    public boolean isOUManagable(String ou) {
        if (this.m_isRootAccountManager) {
            return true;
        }
        if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(""))) {
            return true;
        }
        return this.m_managableOU.contains(this.assureOUString(ou));
    }

    public boolean isParentOfManagableOU(String name) {
        if (this.m_isRootAccountManager) {
            return true;
        }
        if (this.m_isParentOfOU.containsKey(name)) {
            return this.m_isParentOfOU.get(name);
        }
        for (String ou : this.m_managableOU) {
            if (!ou.startsWith(name)) continue;
            this.m_isParentOfOU.put(name, true);
            return true;
        }
        this.m_isParentOfOU.put(name, false);
        return false;
    }

    private String assureOUString(String ou) {
        if (ou.equals("") | ou.endsWith("/")) {
            return ou;
        }
        return ou + "/";
    }
}

