/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsDeleteOUDialog;
import org.opencms.ui.apps.user.CmsGroupEditDialog;
import org.opencms.ui.apps.user.CmsImportExportUserDialog;
import org.opencms.ui.apps.user.CmsOUEditDialog;
import org.opencms.ui.apps.user.CmsOuTreeType;
import org.opencms.ui.apps.user.CmsUserEditDialog;
import org.opencms.ui.apps.user.I_CmsFilterableTable;
import org.opencms.ui.apps.user.I_CmsOuTreeType;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;

public class CmsOUTable
extends Table
implements I_CmsFilterableTable {
    static final Log LOG = CmsLog.getLog(CmsOUTable.class);
    private static final long serialVersionUID = -1080519790145391678L;
    protected CmsAccountsApp m_app;
    protected String m_parentOu;
    CmsObject m_cms;
    CmsContextMenu m_menu;
    private IndexedContainer m_container;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;

    public CmsOUTable(String ou, CmsAccountsApp app) {
        this.m_app = app;
        this.init(ou);
    }

    public static void openImportExportDialog(CmsObject cms, String ou) {
        boolean includeTechnicalFields = false;
        try {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ADMINISTRATOR);
            includeTechnicalFields = true;
        }
        catch (CmsRoleViolationException cmsRoleViolationException) {
            // empty catch block
        }
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_DIALOGNAME_0", new Object[0]));
        window.setContent((Component)CmsImportExportUserDialog.getExportUserDialogForOU(ou, window, includeTechnicalFields));
        A_CmsUI.get().addWindow(window);
    }

    @Override
    public void filter(String data) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(data)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.Name, data, true, false), new SimpleStringFilter((Object)TableProperty.Description, data, true, false)}));
        }
    }

    @Override
    public VerticalLayout getEmptyLayout() {
        VerticalLayout layout = new VerticalLayout();
        layout.setVisible(false);
        return layout;
    }

    protected boolean isAdmin() {
        return OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ADMINISTRATOR.forOrgUnit(this.m_parentOu));
    }

    protected void updateApp(String itemId) {
        I_CmsOuTreeType foundType = null;
        for (I_CmsOuTreeType type : this.m_app.getTreeTypeProvider().getTreeTypes()) {
            if (!itemId.equals(type.getId())) continue;
            foundType = type;
            break;
        }
        if (foundType != null) {
            this.m_app.update(this.m_parentOu, foundType, null);
            return;
        }
        this.m_app.update(itemId, CmsOuTreeType.OU, null, "");
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryOpen());
            this.m_menuEntries.add(new EntryEdit());
            this.m_menuEntries.add(new EntryNewGroup());
            this.m_menuEntries.add(new EntryNewUser());
            this.m_menuEntries.add(new EntryImportExportUser());
            this.m_menuEntries.add(new EntryDelete());
        }
        return this.m_menuEntries;
    }

    private void addOuToTable(CmsOrganizationalUnit ou) {
        Item item;
        if (this.m_app.isParentOfManagableOU(ou.getName()) && (item = this.m_container.addItem((Object)ou.getName())) != null) {
            item.getItemProperty((Object)TableProperty.Name).setValue((Object)ou.getName());
            item.getItemProperty((Object)TableProperty.Description).setValue((Object)ou.getDisplayName(A_CmsUI.get().getLocale()));
            if (ou.hasFlagWebuser()) {
                item.getItemProperty((Object)TableProperty.Icon).setValue((Object)new CmsCssIcon("oc-icon-24-webuser"));
            }
        }
    }

    private void init(String parentOu) {
        this.m_parentOu = parentOu;
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new IndexedContainer();
        this.setContainerDataSource((Container)this.m_container);
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefault());
            this.setColumnHeader((Object)prop, prop.getName());
        }
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId((Object)TableProperty.Icon);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.addGeneratedColumn((Object)TableProperty.Ressources, new Table.ColumnGenerator(){
            private static final long serialVersionUID = 4624734503799549261L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                Object out = "";
                try {
                    List<CmsResource> resources;
                    boolean isOu = true;
                    for (I_CmsOuTreeType type : CmsOUTable.this.m_app.getTreeTypeProvider().getTreeTypes()) {
                        if (!type.getId().equals(itemId)) continue;
                        isOu = false;
                    }
                    if (isOu && !(resources = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(CmsOUTable.this.m_cms, (String)itemId)).isEmpty()) {
                        out = resources.get(0).getRootPath();
                        int i = 1;
                        while (resources.size() > i & ((String)out).length() < 50) {
                            out = (String)out + ", " + resources.get(i).getRootPath();
                        }
                        if (resources.size() > i) {
                            out = (String)out + " ...";
                        }
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)"unable to read resources.", (Throwable)e);
                }
                return out;
            }
        });
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.Description, TableProperty.Ressources});
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            this.m_cms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException e) {
            this.m_cms = A_CmsUI.getCmsObject();
        }
        try {
            if (this.m_app.isOUManagable(this.m_parentOu)) {
                for (I_CmsOuTreeType treeType : this.m_app.getTreeTypeProvider().getTreeTypes()) {
                    if (!treeType.showInOuTable() || !treeType.isValidForOu(this.m_cms, this.m_parentOu)) continue;
                    Item item = this.m_container.addItem((Object)treeType.getId());
                    item.getItemProperty((Object)TableProperty.Name).setValue((Object)treeType.getName());
                    item.getItemProperty((Object)TableProperty.Icon).setValue((Object)treeType.getIcon());
                    item.getItemProperty((Object)TableProperty.Type).setValue((Object)treeType);
                }
            }
            ArrayList<CmsOrganizationalUnit> webOus = new ArrayList<CmsOrganizationalUnit>();
            for (CmsOrganizationalUnit ou : OpenCms.getOrgUnitManager().getOrganizationalUnits(this.m_cms, parentOu, false)) {
                if (ou.hasFlagWebuser()) {
                    webOus.add(ou);
                    continue;
                }
                this.addOuToTable(ou);
            }
            for (CmsOrganizationalUnit ou : webOus) {
                this.addOuToTable(ou);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read ous", (Throwable)e);
        }
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 4807195510202231174L;

            public void itemClick(ItemClickEvent event) {
                CmsOUTable.this.setValue(null);
                CmsOUTable.this.select(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    CmsOUTable.this.m_menu.setEntries(CmsOUTable.this.getMenuEntries(), Collections.singleton((String)CmsOUTable.this.getValue()));
                    CmsOUTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsOUTable.this);
                    return;
                }
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && event.getPropertyId().equals((Object)TableProperty.Name)) {
                    CmsOUTable.this.updateApp((String)CmsOUTable.this.getValue());
                }
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (TableProperty.Name.equals(propertyId)) {
                    return " o-hover-column";
                }
                return "";
            }
        });
    }

    static enum TableProperty {
        Description("GUI_USERMANAGEMENT_OU_DESCRIPTION_0", String.class, ""),
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-orgunit")),
        Name("GUI_USERMANAGEMENT_OU_NAME_0", String.class, ""),
        Ressources("GUI_USERMANAGEMENT_OU_EDIT_PANEL2_0", String.class, ""),
        Type(null, I_CmsOuTreeType.class, CmsOuTreeType.OU);

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String name, Class<?> type, Object defaultValue) {
            this.m_headerMessage = name;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        Object getDefault() {
            return this.m_defaultValue;
        }

        String getName() {
            return this.m_headerMessage == null ? "" : CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
        }

        Class<?> getType() {
            return this.m_type;
        }
    }

    class EntryOpen
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryOpen() {
        }

        @Override
        public void executeAction(Set<String> context) {
            String itemId = context.iterator().next();
            CmsOUTable.this.updateApp(itemId);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OPEN_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (CmsOUTable.this.m_app != null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryEdit
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryEdit() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_EDIT_WINDOW_CAPTION_0", new Object[0]));
            window.setContent((Component)new CmsOUEditDialog(CmsOUTable.this.m_cms, context.iterator().next(), window, CmsOUTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_EDIT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (CmsOUTable.this.getItem(context.iterator().next()).getItemProperty((Object)TableProperty.Type).getValue().equals(CmsOuTreeType.OU)) {
                if (CmsOUTable.this.isAdmin()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
                }
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryNewGroup
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryNewGroup() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_GROUP_0", new Object[0]));
            window.setContent((Component)new CmsGroupEditDialog(CmsOUTable.this.m_cms, window, CmsOUTable.this.m_parentOu, CmsOUTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_GROUP_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            Object typeObj = CmsOUTable.this.getItem(context.iterator().next()).getItemProperty((Object)TableProperty.Type).getValue();
            if (((I_CmsOuTreeType)typeObj).isGroup()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryNewUser
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryNewUser() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_0", new Object[0]));
            window.setContent((Component)new CmsUserEditDialog(CmsOUTable.this.m_cms, window, CmsOUTable.this.m_parentOu, CmsOUTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_ADD_USER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            Object typeObj = CmsOUTable.this.getItem(context.iterator().next()).getItemProperty((Object)TableProperty.Type).getValue();
            if (((I_CmsOuTreeType)typeObj).isUser()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryImportExportUser
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryImportExportUser() {
        }

        @Override
        public void executeAction(Set<String> context) {
            CmsOUTable.openImportExportDialog(CmsOUTable.this.m_cms, context.iterator().next());
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_CONTEXTMENUNAME_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (CmsOUTable.this.getItem(context.iterator().next()).getItemProperty((Object)TableProperty.Type).getValue().equals(CmsOuTreeType.OU)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryDelete
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryDelete() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            CmsDeleteOUDialog dialog = new CmsDeleteOUDialog(CmsOUTable.this.m_cms, context.iterator().next(), window, CmsOUTable.this.m_app);
            window.setContent((Component)dialog);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_DELETE_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (CmsOUTable.this.getItem(context.iterator().next()).getItemProperty((Object)TableProperty.Type).getValue().equals(CmsOuTreeType.OU)) {
                if (CmsOUTable.this.isAdmin()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
                }
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }
}

