/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsShowResourceTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsUUID;

public class CmsShowResourcesDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -1744033403586325260L;
    private static final Log LOG = CmsLog.getLog(CmsShowResourcesDialog.class);
    private Button m_cancel;
    private VerticalLayout m_layout;
    private CmsPrincipal m_principal;
    private CmsObject m_cms;
    private DialogType m_type;

    public CmsShowResourcesDialog(String id, final Window window) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.iniCmsObject();
        try {
            this.m_principal = A_CmsUI.getCmsObject().readUser(new CmsUUID(id));
            this.m_type = DialogType.User;
        }
        catch (CmsException e) {
            try {
                this.m_principal = A_CmsUI.getCmsObject().readGroup(new CmsUUID(id));
                this.m_type = DialogType.Group;
            }
            catch (CmsException e1) {
                this.m_type = DialogType.Error;
            }
        }
        this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_principal)));
        CmsShowResourceTable table = new CmsShowResourceTable(this.m_cms, this.m_principal.getId(), this.m_type);
        if (table.hasNoEntries()) {
            this.m_layout.addComponent((Component)CmsVaadinUtils.getInfoLayout("GUI_USERMANAGEMENT_NO_RESOURCES_WITH_PERMISSIONS_0"));
        } else {
            this.m_layout.addComponent((Component)table);
        }
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2117164384116082079L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
    }

    private void iniCmsObject() {
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            this.m_cms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to clone CmsObject", (Throwable)e);
        }
    }

    protected static enum DialogType {
        Group,
        User,
        Error;

    }
}

