/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.UserError;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsDefaultValidationHandler;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPasswordInfo;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.CmsUserLog;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsPasswordSecurityEvaluator;
import org.opencms.security.twofactor.CmsTwoFactorAuthenticationHandler;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsGeneratePasswordDialog;
import org.opencms.ui.apps.user.CmsSendPasswordNotification;
import org.opencms.ui.apps.user.CmsUserEditParameters;
import org.opencms.ui.apps.user.I_CmsPasswordFetcher;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsUserDataFormLayout;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.ui.dialogs.permissions.CmsPrincipalSelect;
import org.opencms.ui.login.CmsPasswordForm;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUserEditDialog
extends CmsBasicDialog
implements I_CmsPasswordFetcher {
    private static final Log LOG = CmsLog.getLog(CmsUserEditDialog.class);
    private static final long serialVersionUID = -5198443053070008413L;
    protected boolean m_visSites = true;
    boolean m_isWebOU;
    CmsPasswordForm m_pw;
    ComboBox m_site;
    CmsPathSelectField m_startfolder;
    private CmsAccountsApp m_app;
    private Button m_cancel;
    private CmsObject m_cms;
    private TextArea m_description;
    private com.vaadin.v7.ui.Label m_dummyPasswordLabel;
    private CmsUserEditParameters m_editParams = new CmsUserEditParameters();
    private CheckBox m_enabled;
    private CheckBox m_forceResetPassword;
    private Button m_generateButton;
    private CmsPrincipalSelect m_group;
    private ComboBox m_language;
    private TextField m_loginname;
    private boolean m_name_was_empty;
    private Button m_next;
    private Button m_ok;
    private com.vaadin.v7.ui.Label m_ou;
    private PasswordValidator m_passwordValidator = new PasswordValidator();
    private ComboBox m_project;
    private CheckBox m_resetTwoFactorAuthentication;
    private ComboBox m_role;
    private CheckBox m_selfmanagement;
    private CheckBox m_sendEmail;
    private ComboBox m_startview;
    private TabSheet m_tab;
    private Label m_twoFactorAuthState;
    private FormLayout m_twoFactorBox;
    private CmsUser m_user;
    private CmsUserDataFormLayout m_userdata;

    public CmsUserEditDialog(CmsObject cms, CmsUUID userId, Window window, CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.setPasswordFields();
        try {
            CmsTwoFactorAuthenticationHandler twoFactorHandler;
            this.m_cms = OpenCms.initCmsObject(cms);
            this.m_app = app;
            this.m_startfolder.disableSiteSwitch();
            this.m_user = this.m_cms.readUser(userId);
            this.m_editParams = app.getUserEditParameters(this.m_user);
            if (this.m_user.isWebuser()) {
                this.m_sendEmail.setVisible(false);
                this.m_sendEmail.setValue((Object)Boolean.FALSE);
                this.m_forceResetPassword.setVisible(false);
                this.m_forceResetPassword.setValue((Object)Boolean.FALSE);
                this.m_selfmanagement.setVisible(false);
                this.m_selfmanagement.setValue((Object)Boolean.FALSE);
                this.m_isWebOU = true;
            } else {
                this.m_selfmanagement.setValue((Object)true);
            }
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_user)));
            this.m_group.setVisible(false);
            this.m_role.setVisible(false);
            this.m_loginname.setValue(this.m_user.getSimpleName());
            this.m_loginname.setEnabled(false);
            this.m_ou.setValue(this.m_user.getOuFqn().isEmpty() ? "/" : this.m_user.getOuFqn());
            this.m_description.setValue(this.m_user.getDescription());
            this.m_selfmanagement.setValue((Object)(!this.m_user.isManaged() ? 1 : 0));
            this.m_enabled.setValue((Object)this.m_user.isEnabled());
            CmsUserSettings settings = new CmsUserSettings(this.m_user);
            this.init(window, app, settings, this.m_editParams.isEditEnabled());
            this.m_sendEmail.setEnabled(false);
            this.m_forceResetPassword.setValue((Object)(this.m_user.getAdditionalInfo().get("RESET_PASSWORD") != null ? 1 : 0));
            this.m_next.setVisible(false);
            this.setupStartFolder(settings.getStartFolder());
            this.m_loginname.setEnabled(false);
            if (!this.m_editParams.isEditEnabled()) {
                this.m_description.setEnabled(false);
            }
            if (!this.m_editParams.isPasswordChangeEnabled()) {
                this.m_pw.setVisible(false);
                this.m_forceResetPassword.setVisible(false);
                this.m_sendEmail.setVisible(false);
                this.m_generateButton.setVisible(false);
            }
            if ((twoFactorHandler = OpenCms.getTwoFactorAuthenticationHandler()).needsTwoFactorAuthentication(this.m_user)) {
                this.m_twoFactorBox.setVisible(true);
                if (!twoFactorHandler.hasSecondFactor(this.m_user)) {
                    this.m_resetTwoFactorAuthentication.setEnabled(false);
                    this.m_twoFactorAuthState.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_2FA_NOT_SET_UP_0", new Object[0]));
                } else {
                    this.m_twoFactorAuthState.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_2FA_USED_0", new Object[0]));
                    this.m_resetTwoFactorAuthentication.setEnabled(true);
                }
            } else {
                this.m_twoFactorBox.setVisible(false);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read user", (Throwable)e);
        }
    }

    public CmsUserEditDialog(CmsObject cms, Window window, String ou, CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsOrganizationalUnit myOu = null;
        try {
            this.m_app = app;
            this.m_cms = OpenCms.initCmsObject(cms);
            myOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, ou);
            this.m_isWebOU = false;
            this.m_sendEmail.setValue((Object)Boolean.TRUE);
            this.m_forceResetPassword.setValue((Object)Boolean.TRUE);
            if (myOu.hasFlagWebuser()) {
                this.m_role.setVisible(false);
                this.m_sendEmail.setVisible(false);
                this.m_sendEmail.setValue((Object)Boolean.FALSE);
                this.m_forceResetPassword.setVisible(false);
                this.m_forceResetPassword.setValue((Object)Boolean.FALSE);
                this.m_selfmanagement.setVisible(false);
                this.m_selfmanagement.setValue((Object)Boolean.FALSE);
                this.m_isWebOU = true;
            } else {
                CmsUserEditDialog.iniRole(this.m_cms, ou, this.m_role, LOG, true);
                this.m_role.select((Object)CmsRole.EDITOR.forOrgUnit(ou));
                this.m_selfmanagement.setValue((Object)true);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read OU", (Throwable)e);
        }
        this.setPasswordFields();
        this.m_ou.setValue(ou.isEmpty() ? "/" : ou);
        this.m_group.setWidgetType(CmsPrincipalSelect.WidgetType.groupwidget);
        try {
            CmsGroup group = this.m_cms.readGroup(ou + OpenCms.getDefaultUsers().getGroupUsers());
            this.m_group.setValue(group.getName());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_group.setRealPrincipalsOnly(true);
        this.m_group.setOU(this.m_ou.getValue());
        try {
            this.m_group.setIncludeWebOus(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, ou).hasFlagWebuser());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_twoFactorBox.setVisible(false);
        this.m_enabled.setValue((Object)Boolean.TRUE);
        this.init(window, app, null, true);
        this.setupStartFolder(null);
        this.m_tab.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){
            private static final long serialVersionUID = -2579639520410382246L;

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                CmsUserEditDialog.this.setButtonVisibility();
            }
        });
        this.setButtonVisibility();
    }

    protected static void iniRole(CmsObject cms, String ou, com.vaadin.ui.ComboBox<CmsRole> roleComboBox, Log log) {
        block2: {
            try {
                List<CmsRole> roles = OpenCms.getRoleManager().getRoles(cms, ou, false);
                CmsRole.applySystemRoleOrder(roles);
                ListDataProvider provider = new ListDataProvider(roles);
                roleComboBox.setDataProvider((DataProvider)provider);
                roleComboBox.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)role -> {
                    try {
                        return role.getDisplayName(cms, A_CmsUI.get().getLocale());
                    }
                    catch (CmsException e) {
                        return "";
                    }
                });
                roleComboBox.setEmptySelectionAllowed(false);
            }
            catch (CmsException e) {
                if (log == null) break block2;
                log.error((Object)"Unable to read roles.", (Throwable)e);
            }
        }
    }

    protected static void iniRole(CmsObject cms, String ou, ComboBox roleComboBox, Log log) {
        CmsUserEditDialog.iniRole(cms, ou, roleComboBox, log, false);
    }

    protected static void iniRole(CmsObject cms, String ou, ComboBox roleComboBox, Log log, boolean includeNoRoleEntry) {
        block4: {
            try {
                List<CmsRole> roles = OpenCms.getRoleManager().getRoles(cms, ou, false);
                CmsRole.applySystemRoleOrder(roles);
                IndexedContainer container = new IndexedContainer();
                container.addContainerProperty((Object)"caption", String.class, (Object)"");
                for (CmsRole role : roles) {
                    Item item = container.addItem((Object)role);
                    item.getItemProperty((Object)"caption").setValue((Object)role.getDisplayName(cms, A_CmsUI.get().getLocale()));
                }
                if (includeNoRoleEntry) {
                    Item item = container.addItem((Object)"NoRole");
                    item.getItemProperty((Object)"caption").setValue((Object)CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_NO_ROLE_0", new Object[0]));
                }
                roleComboBox.setContainerDataSource((Container)container);
                roleComboBox.setItemCaptionPropertyId((Object)"caption");
                roleComboBox.setNullSelectionAllowed(false);
                roleComboBox.setNewItemsAllowed(false);
            }
            catch (CmsException e) {
                if (log == null) break block4;
                log.error((Object)"Unable to read roles.", (Throwable)e);
            }
        }
    }

    protected static void sendMail(CmsObject cms, String password, CmsUser user, boolean newUser, boolean changePassword) {
        CmsUserEditDialog.sendMail(cms, password, user, user.getOuFqn(), newUser, changePassword);
    }

    protected static void sendMail(CmsObject cms, String password, CmsUser user, String ou, boolean newUser, boolean changePassword) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(user.getEmail())) {
            return;
        }
        CmsSendPasswordNotification notification = new CmsSendPasswordNotification(cms, password, user, ou, cms.getRequestContext().getCurrentUser(), newUser, changePassword);
        try {
            notification.send();
        }
        catch (EmailException e) {
            LOG.error((Object)"Unable to send email with password", (Throwable)e);
        }
    }

    @Override
    public void fetchPassword(String password) {
        this.m_pw.getPassword1Field().setValue(password);
        this.m_pw.getPassword2Field().setValue(password);
        this.m_forceResetPassword.setValue((Object)Boolean.TRUE);
        this.m_sendEmail.setValue((Object)Boolean.TRUE);
        this.m_sendEmail.setEnabled(true);
    }

    protected boolean isNewUser() {
        return this.m_user == null;
    }

    protected boolean isPasswordMismatchingConfirm() {
        return !this.m_pw.getPassword1().equals(this.m_pw.getPassword2());
    }

    protected boolean isPasswordValid() {
        if (this.m_pw.getPassword1() == null | this.m_pw.getPassword2() == null) {
            return false;
        }
        try {
            CmsPasswordInfo pwdInfo = new CmsPasswordInfo();
            pwdInfo.setNewPwd(this.m_pw.getPassword1());
            pwdInfo.setConfirmation(this.m_pw.getPassword2());
            pwdInfo.validate();
            return true;
        }
        catch (CmsIllegalArgumentException | CmsIllegalStateException e) {
            LOG.error((Object)"New password is not ok", (Throwable)e);
            return false;
        }
    }

    protected boolean isRootSiteSelected() {
        return this.m_site.getValue().equals("");
    }

    protected boolean isSiteNull() {
        return this.m_site.getValue() == null;
    }

    protected boolean isSitePathValid() {
        try {
            CmsObject cmsLocal = OpenCms.initCmsObject(this.m_cms);
            cmsLocal.getRequestContext().setSiteRoot((String)this.m_site.getValue());
            if (this.m_startfolder.getValue().length() <= ((String)this.m_site.getValue()).length()) {
                return false;
            }
            return cmsLocal.existsResource(this.m_startfolder.getValue().substring(((String)this.m_site.getValue()).length()));
        }
        catch (CmsException e) {
            LOG.error((Object)"Unabel to ini CmsObject", (Throwable)e);
            return false;
        }
    }

    protected boolean isStartViewAvailableOnRoot() {
        if (!this.m_startview.isEnabled()) {
            return false;
        }
        return !this.m_startview.getValue().equals("pageeditor") & !this.m_startview.getValue().equals("sitemapeditor");
    }

    protected boolean isValid() {
        boolean[] ret = new boolean[]{this.m_loginname.isValid(), this.m_isWebOU ? true : this.m_userdata.isValid() | this.m_name_was_empty, this.m_isWebOU ? true : this.m_site.isValid() & this.m_startview.isValid() & this.m_startfolder.isValid() & this.m_project.isValid(), this.validatePasswordField1(this.m_pw.getPassword1Field().getValue())};
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i]) continue;
            this.m_tab.setSelectedTab(i);
            break;
        }
        return ret[0] & ret[1] & ret[2] & ret[3];
    }

    protected void save() {
        boolean newUser = false;
        try {
            if (this.m_user == null) {
                this.createNewUser();
                newUser = true;
            } else {
                this.saveUser();
            }
            this.saveUserSettings();
            if ((Boolean)this.m_sendEmail.getValue() & this.m_sendEmail.isEnabled()) {
                CmsUserEditDialog.sendMail(this.m_cms, this.m_pw.getPassword1(), this.m_user, newUser, (Boolean)this.m_forceResetPassword.getValue());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to save user", (Throwable)e);
        }
    }

    protected void setButtonVisibility() {
        Component tab = this.m_tab.getSelectedTab();
        int pos = this.m_tab.getTabPosition(this.m_tab.getTab(tab));
        int maxPos = this.m_isWebOU ? 3 : 3;
        this.m_next.setVisible(pos < maxPos);
        this.m_ok.setVisible(pos == maxPos);
    }

    protected void setEmailBox() {
        this.m_sendEmail.setEnabled(!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_pw.getPassword1()) | !CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_pw.getPassword2()));
    }

    protected void setupStartFolder(String startFolder) {
        try {
            CmsObject cmsCopy = OpenCms.initCmsObject(this.m_cms);
            if (this.m_site.getValue() != null) {
                cmsCopy.getRequestContext().setSiteRoot((String)this.m_site.getValue());
            } else {
                cmsCopy.getRequestContext().setSiteRoot("");
            }
            this.m_startfolder.requireFolder();
            this.m_startfolder.disableSiteSwitch();
            String defaultFolder = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartFolder();
            if (startFolder == null && (CmsStringUtil.isEmptyOrWhitespaceOnly(defaultFolder) || !cmsCopy.existsResource(defaultFolder))) {
                defaultFolder = "/";
            }
            this.m_startfolder.setValue(cmsCopy.getRequestContext().addSiteRoot(startFolder == null ? defaultFolder : startFolder));
            this.m_startfolder.setCmsObject(cmsCopy);
            this.m_startfolder.setUseRootPaths(true);
            if (!this.m_visSites) {
                try {
                    List<CmsResource> ouResources = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(cmsCopy, this.m_ou.getValue());
                    if (!ouResources.isEmpty()) {
                        this.m_startfolder.setValue(ouResources.get(0).getRootPath());
                    }
                }
                catch (CmsException e1) {
                    LOG.error((Object)"unable to read resources for ou", (Throwable)e1);
                }
            }
            this.m_startfolder.setEnabled(this.m_visSites);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to ini CmsObject", (Throwable)e);
        }
    }

    protected void setupValidators() {
        if (this.m_loginname.getValidators().size() == 0) {
            this.m_loginname.addValidator((Validator)new LoginNameValidator());
            this.m_pw.getPassword1Field().addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.validatePasswordField1((String)event.getValue()));
            this.m_site.addValidator((Validator)new StartSiteValidator());
            this.m_startview.addValidator((Validator)new StartViewValidator());
            this.m_startfolder.addValidator(new StartPathValidator());
        }
    }

    protected void switchTab() {
        Component tab = this.m_tab.getSelectedTab();
        int pos = this.m_tab.getTabPosition(this.m_tab.getTab(tab));
        if (this.m_isWebOU && pos == 0) {
            pos = 1;
        }
        this.m_tab.setSelectedTab(pos + 1);
    }

    protected boolean userAlreadyExists(String username) {
        if (this.m_user != null) {
            return false;
        }
        CmsUser user = null;
        try {
            user = this.m_cms.readUser(this.m_ou.getValue() + username);
        }
        catch (CmsException e) {
            return false;
        }
        return user != null;
    }

    void checkPasswordMatch(String password2) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(password2)) {
            this.showPasswordMatchError(!password2.equals(this.m_pw.getPassword1()));
        }
    }

    void checkSecurity(String password) {
        I_CmsPasswordHandler handler = OpenCms.getPasswordHandler();
        try {
            handler.validatePassword(password);
            if (handler instanceof I_CmsPasswordSecurityEvaluator) {
                I_CmsPasswordSecurityEvaluator.SecurityLevel level = ((I_CmsPasswordSecurityEvaluator)((Object)handler)).evaluatePasswordSecurity(password);
                this.m_pw.setErrorPassword1(null, "o-security-" + level.name());
            } else {
                this.m_pw.setErrorPassword1(null, "o-security-strong");
            }
        }
        catch (CmsSecurityException e) {
            this.m_pw.setErrorPassword1(new UserError(e.getLocalizedMessage(A_CmsUI.get().getLocale())), "o-security-invalid");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_pw.getPassword2())) {
            this.showPasswordMatchError(!password.equals(this.m_pw.getPassword2()));
        }
    }

    CmsObject getCmsObjectWithSite(String siteRoot) {
        if (siteRoot == null) {
            siteRoot = "/";
        }
        try {
            CmsObject res = OpenCms.initCmsObject(this.m_cms);
            res.getRequestContext().setSiteRoot(siteRoot);
            return res;
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to initialize CmsObject", (Throwable)e);
            return this.m_cms;
        }
    }

    void iniSite(CmsUserSettings settings) {
        List<CmsSite> sitesList = OpenCms.getSiteManager().getAvailableSites(this.m_cms, true, false, this.m_ou.getValue());
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)"caption", String.class, (Object)"");
        CmsSite firstNoRootSite = null;
        for (CmsSite site : sitesList) {
            Item item;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(site.getSiteRoot())) {
                if (!(this.hasRole(CmsRole.VFS_MANAGER) | (this.m_user == null && Arrays.asList(CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.m_ou.getValue()), CmsRole.ADMINISTRATOR.forOrgUnit(this.m_ou.getValue()), CmsRole.WORKPLACE_MANAGER.forOrgUnit(this.m_ou.getValue()), CmsRole.DATABASE_MANAGER.forOrgUnit(this.m_ou.getValue()), CmsRole.PROJECT_MANAGER.forOrgUnit(this.m_ou.getValue()), CmsRole.VFS_MANAGER.forOrgUnit(this.m_ou.getValue()), CmsRole.ROOT_ADMIN.forOrgUnit(this.m_ou.getValue())).contains(this.m_role.getValue() instanceof CmsRole ? ((CmsRole)this.m_role.getValue()).forOrgUnit(this.m_ou.getValue()) : "")))) continue;
                item = container.addItem((Object)site.getSiteRoot());
                item.getItemProperty((Object)"caption").setValue((Object)site.getTitle());
                continue;
            }
            if (firstNoRootSite == null) {
                firstNoRootSite = site;
            }
            item = container.addItem((Object)site.getSiteRoot());
            item.getItemProperty((Object)"caption").setValue((Object)site.getTitle());
        }
        if (container.size() == 0) {
            if (!container.containsId((Object)A_CmsUI.getCmsObject().getRequestContext().getSiteRoot())) {
                Item defaultItem = container.addItem((Object)A_CmsUI.getCmsObject().getRequestContext().getSiteRoot());
                defaultItem.getItemProperty((Object)"caption").setValue((Object)A_CmsUI.getCmsObject().getRequestContext().getSiteRoot());
            }
            this.m_visSites = false;
        }
        this.m_site.setContainerDataSource((Container)container);
        this.m_site.setItemCaptionPropertyId((Object)"caption");
        this.m_site.setNewItemsAllowed(false);
        this.m_site.setNullSelectionAllowed(false);
        if (settings != null) {
            if (settings.getStartSite().length() >= 1) {
                this.m_site.select((Object)settings.getStartSite().substring(0, settings.getStartSite().length() - 1));
            } else {
                LOG.error((Object)"The start site is unvalid configured");
            }
        } else {
            String defaultSite = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartSite();
            if (container.containsId((Object)defaultSite)) {
                this.m_site.select((Object)defaultSite);
            } else if (firstNoRootSite != null) {
                this.m_site.select((Object)firstNoRootSite.getSiteRoot());
            } else {
                this.m_site.select(container.getItemIds().get(0));
            }
        }
    }

    void iniStartView(CmsUserSettings settings) {
        IndexedContainer container = this.getStartViewContainer("caption");
        if (container.size() > 0) {
            this.m_startview.setEnabled(true);
            this.m_startview.setContainerDataSource((Container)container);
            this.m_startview.setItemCaptionPropertyId((Object)"caption");
            this.m_startview.setNullSelectionAllowed(false);
            this.m_startview.setNewItemsAllowed(false);
            if (container.getItemIds().size() > 0) {
                if (settings != null && container.containsId((Object)settings.getStartView())) {
                    this.m_startview.select((Object)settings.getStartView());
                } else {
                    String defaultView = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartView();
                    if (container.containsId((Object)defaultView)) {
                        this.m_startview.select((Object)defaultView);
                    } else if (container.containsId((Object)"pageeditor")) {
                        this.m_startview.select((Object)"pageeditor");
                    } else {
                        this.m_startview.select(container.getItemIds().get(0));
                    }
                }
            }
        } else {
            this.m_startview.setValue(null);
            this.m_startview.setEnabled(false);
        }
    }

    void showPasswordMatchError(boolean show) {
        if (show) {
            this.m_pw.setErrorPassword2(new UserError(CmsVaadinUtils.getMessageText("GUI_PWCHANGE_PASSWORD_MISMATCH_0", new Object[0])), "o-security-invalid");
        } else {
            this.m_pw.setErrorPassword2(null, "o-security-strong");
        }
    }

    private void createNewUser() throws CmsException {
        Object ou = this.m_ou.getValue();
        if (!((String)ou).endsWith("/")) {
            ou = (String)ou + "/";
        }
        CmsUser user = this.m_cms.createUser((String)ou + (String)this.m_loginname.getValue(), this.m_pw.getPassword1(), "", null);
        this.updateUser(user);
        this.m_cms.writeUser(user);
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_group.getValue())) {
            this.m_cms.addUserToGroup(user.getName(), this.m_group.getValue());
        }
        if (this.m_role.isVisible() && this.m_role.getValue() instanceof CmsRole) {
            OpenCms.getRoleManager().addUserToRole(this.m_cms, (CmsRole)this.m_role.getValue(), user.getName());
        }
        this.m_user = user;
    }

    private IndexedContainer getStartViewContainer(String caption) {
        List<I_CmsWorkplaceAppConfiguration> apps = OpenCms.getWorkplaceAppManager().getDefaultQuickLaunchConfigurations();
        IndexedContainer res = new IndexedContainer();
        res.addContainerProperty((Object)caption, String.class, (Object)"");
        for (I_CmsWorkplaceAppConfiguration app : apps) {
            if (!this.hasRoleForApp(app)) continue;
            Item item = res.addItem((Object)app.getId());
            item.getItemProperty((Object)caption).setValue((Object)app.getName(A_CmsUI.get().getLocale()));
        }
        return res;
    }

    private boolean hasRole(CmsRole role) {
        if (this.m_user != null) {
            return OpenCms.getRoleManager().hasRole(this.m_cms, this.m_user.getName(), CmsRole.VFS_MANAGER);
        }
        return false;
    }

    private boolean hasRoleForApp(I_CmsWorkplaceAppConfiguration app) {
        if (this.m_user != null) {
            return OpenCms.getRoleManager().hasRole(this.m_cms, this.m_user.getName(), app.getRequiredRole());
        }
        if (!(this.m_role.getValue() instanceof CmsRole)) {
            return false;
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_group.getValue())) {
            try {
                CmsGroup group = this.m_cms.readGroup(this.m_group.getValue());
                CmsRole roleFromGroup = CmsRole.valueOf(group);
                CmsRole roleFromField = (CmsRole)this.m_role.getValue();
                if (roleFromGroup == null || !roleFromGroup.getChildren(true).contains(roleFromField)) {
                    roleFromGroup = roleFromField;
                }
                if (roleFromGroup == null) {
                    return false;
                }
                List<CmsRole> groupRoles = roleFromGroup.getChildren(true);
                groupRoles.add(roleFromGroup);
                ArrayList<String> roleNames = new ArrayList<String>();
                for (CmsRole gr : groupRoles) {
                    roleNames.add(gr.getRoleName());
                }
                return roleNames.contains(app.getRequiredRole().getRoleName());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read group", (Throwable)e);
            }
        }
        return true;
    }

    private void iniLanguage(CmsUserSettings settings) {
        IndexedContainer container = CmsVaadinUtils.getWorkplaceLanguageContainer("caption");
        this.m_language.setContainerDataSource((Container)container);
        this.m_language.setItemCaptionPropertyId((Object)"caption");
        this.m_language.setNewItemsAllowed(false);
        this.m_language.setNullSelectionAllowed(false);
        if (settings != null) {
            this.m_language.select((Object)settings.getLocale());
        } else if (container.containsId((Object)OpenCms.getWorkplaceManager().getDefaultUserSettings().getLocale())) {
            this.m_language.select((Object)OpenCms.getWorkplaceManager().getDefaultUserSettings().getLocale());
        } else {
            this.m_language.select(this.m_language.getItemIds().iterator().next());
        }
    }

    private void iniProject(CmsUserSettings settings) {
        try {
            List<CmsProject> projects = OpenCms.getOrgUnitManager().getAllAccessibleProjects(this.m_cms, this.m_ou.getValue(), false);
            for (CmsProject project : projects) {
                this.m_project.addItem((Object)project.getName());
            }
            this.m_project.setNewItemsAllowed(false);
            this.m_project.setNullSelectionAllowed(false);
            if (settings != null) {
                String projString = settings.getStartProject();
                if (projString.startsWith("/")) {
                    projString = projString.substring(1);
                }
                if (!this.m_project.containsId((Object)projString)) {
                    this.m_project.addItem((Object)projString);
                    this.m_project.addValidator((Validator)new StartProjectValidator(projString));
                }
                this.m_project.select((Object)projString);
            } else {
                String defaultProject = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartProject();
                if (this.m_project.containsId((Object)defaultProject)) {
                    this.m_project.select((Object)defaultProject);
                } else if (this.m_project.containsId((Object)"Offline")) {
                    this.m_project.select((Object)"Offline");
                } else {
                    Iterator it = this.m_project.getItemIds().iterator();
                    String p = (String)it.next();
                    while (p.equals("Online") & it.hasNext()) {
                        p = (String)it.next();
                    }
                    this.m_project.select((Object)p);
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read projects", (Throwable)e);
        }
    }

    private void init(final Window window, final CmsAccountsApp app, final CmsUserSettings settings, boolean enabled) {
        this.m_userdata.initFields(this.m_user, enabled ? CmsUserDataFormLayout.EditLevel.all : CmsUserDataFormLayout.EditLevel.none);
        if (this.m_user != null && CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_user.getFirstname()) | CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_user.getLastname()) | CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_user.getEmail())) {
            this.m_name_was_empty = true;
        }
        this.iniLanguage(settings);
        this.iniProject(settings);
        this.iniSite(settings);
        this.iniStartView(settings);
        this.m_site.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 5111762655156037899L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsUserEditDialog.this.setupStartFolder(null);
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2579639520410382246L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserEditDialog.this.setupValidators();
                if (CmsUserEditDialog.this.isValid()) {
                    CmsUserEditDialog.this.save();
                    window.close();
                    app.reload();
                }
            }
        });
        this.m_next.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -8584899970290349959L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserEditDialog.this.setupValidators();
                CmsUserEditDialog.this.switchTab();
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5803825104722705175L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        if (this.m_user == null) {
            this.m_role.addValueChangeListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 5697126133686172725L;

                public void valueChange(Property.ValueChangeEvent event) {
                    CmsUserEditDialog.this.iniSite(settings);
                    CmsUserEditDialog.this.iniStartView(settings);
                }
            });
            this.m_group.addValueChangeListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1512940002751242094L;

                public void valueChange(Property.ValueChangeEvent event) {
                    CmsUserEditDialog.this.iniStartView(settings);
                    CmsUserEditDialog.this.iniSite(settings);
                }
            });
        }
        this.m_site.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -169973382455098800L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsUserEditDialog.this.m_startfolder.setCmsObject(CmsUserEditDialog.this.getCmsObjectWithSite((String)CmsUserEditDialog.this.m_site.getValue()));
            }
        });
        this.m_generateButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 4128513094772586752L;

            public void buttonClick(Button.ClickEvent event) {
                final Window windowDialog = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.content);
                windowDialog.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GEN_PASSWORD_CAPTION_0", new Object[0]));
                CmsGeneratePasswordDialog dialog = new CmsGeneratePasswordDialog(CmsUserEditDialog.this, new Runnable(){

                    @Override
                    public void run() {
                        windowDialog.close();
                    }
                });
                windowDialog.setContent((Component)dialog);
                A_CmsUI.get().addWindow(windowDialog);
            }
        });
    }

    private boolean isPasswordField1Valid() {
        String value = this.m_pw.getPassword1Field().getValue();
        try {
            this.m_passwordValidator.validate(value);
            return true;
        }
        catch (Validator.InvalidValueException e) {
            return false;
        }
    }

    private void saveUser() throws CmsException {
        this.updateUser(this.m_user);
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_pw.getPassword1()) && this.isPasswordValid()) {
            this.m_cms.setPassword(this.m_user.getName(), this.m_pw.getPassword1());
            CmsUserLog.logPasswordChange(this.m_cms, this.m_user.getName());
        }
        this.m_cms.writeUser(this.m_user);
    }

    private void saveUserSettings() throws CmsException {
        CmsUserSettings settings = new CmsUserSettings(this.m_user);
        settings.setLocale((Locale)this.m_language.getValue());
        settings.setStartSite((String)this.m_site.getValue() + "/");
        settings.setStartProject((String)this.m_project.getValue());
        if (this.m_visSites) {
            settings.setStartFolder(this.m_startfolder.getValue().substring(((String)this.m_site.getValue()).length()));
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_startview.getValue())) {
                settings.setStartView((String)this.m_startview.getValue());
            }
        }
        settings.save(this.m_cms);
    }

    private void setPasswordFields() {
        this.m_dummyPasswordLabel.setContentMode(ContentMode.HTML);
        String pwd = "<input type=\"password\" value=\"password\">";
        this.m_dummyPasswordLabel.setValue("<div style=\"display: none;\">" + pwd + pwd + "</div>");
        this.m_pw.hideOldPassword();
        this.m_pw.setHeaderVisible(false);
        if (OpenCms.getPasswordHandler() instanceof I_CmsPasswordSecurityEvaluator) {
            this.m_pw.setSecurityHint(((I_CmsPasswordSecurityEvaluator)((Object)OpenCms.getPasswordHandler())).getPasswordSecurityHint(A_CmsUI.get().getLocale()));
        }
        this.m_pw.getOldPasswordField().setImmediate(true);
        this.m_pw.getPassword1Field().addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.checkSecurity((String)event.getValue());
            this.setEmailBox();
        });
        this.m_pw.getPassword2Field().addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.checkSecurity(this.m_pw.getPassword1());
            this.checkPasswordMatch((String)event.getValue());
            this.setEmailBox();
        });
    }

    private void setUserPasswordStatus(CmsUser user, boolean reset) {
        if (reset) {
            user.setAdditionalInfo("RESET_PASSWORD", "true");
        } else {
            user.deleteAdditionalInfo("RESET_PASSWORD");
        }
        this.m_app.getPasswordResetStateCache().put(user.getId(), reset);
    }

    private void updateUser(CmsUser user) {
        this.setUserPasswordStatus(user, (Boolean)this.m_forceResetPassword.getValue());
        CmsUserLog.logSetForceResetPassword(A_CmsUI.getCmsObject(), user.getName());
        user.setDescription((String)this.m_description.getValue());
        user.setManaged((Boolean)this.m_selfmanagement.getValue() == false);
        if (((Boolean)this.m_resetTwoFactorAuthentication.getValue()).booleanValue()) {
            OpenCms.getTwoFactorAuthenticationHandler().resetTwoFactorAuthentication(user);
        }
        boolean enabled = (Boolean)this.m_enabled.getValue();
        user.setEnabled(enabled);
        if (enabled) {
            user.getAdditionalInfo().remove("accountLocked");
        }
        this.m_userdata.submit(user, this.m_cms, new Runnable(){

            @Override
            public void run() {
            }
        }, true);
    }

    private boolean validatePasswordField1(String value) {
        try {
            this.m_passwordValidator.validate(value);
            this.m_pw.getPassword1Field().setComponentError(null);
            return true;
        }
        catch (Validator.InvalidValueException e) {
            this.m_pw.getPassword1Field().setComponentError(e.getErrorMessage());
            return false;
        }
    }

    class PasswordValidator
    implements Validator {
        private static final long serialVersionUID = 64216980175982548L;

        PasswordValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (CmsUserEditDialog.this.isPasswordMismatchingConfirm()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_PASSWORD_NOT_EQUAL_CONFIRM_0", new Object[0]));
            }
            if (!CmsUserEditDialog.this.isNewUser() && value == null | CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                return;
            }
            if (!CmsUserEditDialog.this.isPasswordValid()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_PASSWORD_INVALID_0", new Object[0]));
            }
        }
    }

    class LoginNameValidator
    implements Validator {
        private static final long serialVersionUID = -6768717591898665618L;

        LoginNameValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_LOGINNAME_EMPTY_0", new Object[0]));
            }
            try {
                CmsDefaultValidationHandler handler = new CmsDefaultValidationHandler();
                handler.checkUserName((String)value);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_LOGINNAME_INVALID_0", new Object[0]));
            }
            if (CmsUserEditDialog.this.userAlreadyExists((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_LOGINNAME_DOUBLE_0", new Object[0]));
            }
        }
    }

    class StartSiteValidator
    implements Validator {
        private static final long serialVersionUID = -4257155941690487831L;

        StartSiteValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (!CmsUserEditDialog.this.m_visSites) {
                return;
            }
            if (CmsUserEditDialog.this.isSiteNull()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_STARTSITE_EMPTY_0", new Object[0]));
            }
        }
    }

    class StartViewValidator
    implements Validator {
        private static final long serialVersionUID = -4257155941690487831L;

        StartViewValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (!CmsUserEditDialog.this.isSiteNull() && CmsUserEditDialog.this.isRootSiteSelected() & !CmsUserEditDialog.this.isStartViewAvailableOnRoot()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_STARTVIEW_NOTFORROOT_0", new Object[0]));
            }
        }
    }

    class StartPathValidator
    implements Validator {
        private static final long serialVersionUID = -4257155941690487831L;

        StartPathValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (!CmsUserEditDialog.this.m_visSites) {
                return;
            }
            if (!CmsUserEditDialog.this.isSiteNull() && !CmsUserEditDialog.this.isSitePathValid()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_START_PATH_NOT_VALID_0", new Object[0]));
            }
        }
    }

    class StartProjectValidator
    implements Validator {
        private static final long serialVersionUID = 7117548227591179638L;
        private String m_invalidProject;

        public StartProjectValidator(String invalidProject) {
            this.m_invalidProject = invalidProject;
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (Objects.equals(String.valueOf(value), this.m_invalidProject)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_START_PROJECT_NOT_EXISTING_0", new Object[0]));
            }
        }
    }

    class EmailValidator
    implements Validator {
        private static final long serialVersionUID = 8943898736907290076L;

        EmailValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_EMAIL_EMPTY_0", new Object[0]));
            }
            try {
                CmsUser.checkEmail((String)value);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_EMAIL_INVALID_0", new Object[0]));
            }
        }
    }
}

