/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sessions.CmsKillSessionDialog;
import org.opencms.ui.apps.sessions.CmsUserInfoDialog;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsAdditionalInfosDialog;
import org.opencms.ui.apps.user.CmsDeleteMultiplePrincipalDialog;
import org.opencms.ui.apps.user.CmsMoveUserToOU;
import org.opencms.ui.apps.user.CmsOuTreeType;
import org.opencms.ui.apps.user.CmsShowResourcesDialog;
import org.opencms.ui.apps.user.CmsUserEditDialog;
import org.opencms.ui.apps.user.CmsUserEditGroupsDialog;
import org.opencms.ui.apps.user.CmsUserEditRoleDialog;
import org.opencms.ui.apps.user.I_CmsFilterableTable;
import org.opencms.ui.apps.user.I_CmsOuTreeType;
import org.opencms.ui.apps.user.I_CmsToggleTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUserTable
extends Table
implements I_CmsFilterableTable,
I_CmsToggleTable {
    static final Log LOG = CmsLog.getLog(CmsUserTable.class);
    private static final long serialVersionUID = 7863356514060544048L;
    protected String m_group;
    protected I_CmsOuTreeType m_type;
    CmsAccountsApp m_app;
    CmsObject m_cms;
    List<CmsUser> m_indirects;
    CmsContextMenu m_menu;
    String m_ou;
    private HashSet<CmsUser> m_blackList = new HashSet();
    private IndexedContainer m_container;
    private VerticalLayout m_emptyLayout;
    private boolean m_fullyLoaded;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private List<CmsUser> m_users;

    public CmsUserTable(String ou, CmsUUID groupID, I_CmsOuTreeType cmsOuTreeType, boolean showAll, CmsAccountsApp app) {
        this.m_ou = ou.equals("/") ? "" : ou;
        this.m_app = app;
        try {
            this.m_cms = this.getCmsObject();
            this.m_type = cmsOuTreeType;
            this.m_indirects = new ArrayList<CmsUser>();
            if (this.m_type.isGroup()) {
                this.m_group = this.m_cms.readGroup(groupID).getName();
                this.m_users = this.m_cms.getUsersOfGroup(this.m_group, true);
                this.m_fullyLoaded = true;
            }
            if (this.m_type.isRole()) {
                this.m_group = CmsRole.valueOfId(groupID).forOrgUnit(ou).getFqn();
                List<CmsUser> directs = OpenCms.getRoleManager().getUsersOfRole(this.m_cms, CmsRole.valueOfId(groupID).forOrgUnit(ou), true, true);
                if (showAll) {
                    this.setAllUsers(directs);
                } else {
                    this.m_users = directs;
                }
            }
            this.init(showAll);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read user", (Throwable)e);
        }
    }

    public CmsUserTable(String ou, I_CmsOuTreeType type, CmsAccountsApp app, boolean showAll) {
        this.m_ou = ou.equals("/") ? "" : ou;
        this.m_app = app;
        try {
            this.m_cms = this.getCmsObject();
            this.m_type = type;
            List<CmsUser> directs = this.m_app.getUsersWithoutAdditionalInfo(this.m_cms, type, ou, false);
            this.m_indirects = new ArrayList<CmsUser>();
            if (showAll) {
                this.setAllUsers(directs);
            } else {
                this.m_users = directs;
            }
            this.init(showAll);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read user.", (Throwable)e);
        }
    }

    @Override
    public void filter(String data) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(data)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.SystemName, data, true, false), new SimpleStringFilter((Object)TableProperty.FullName, data, true, false)}));
        }
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public VerticalLayout getEmptyLayout() {
        this.m_emptyLayout = CmsVaadinUtils.getInfoLayout(CmsOuTreeType.USER.getEmptyMessageKey());
        this.setVisible(this.size() > 0);
        this.m_emptyLayout.setVisible(this.size() == 0);
        return this.m_emptyLayout;
    }

    public List<CmsUser> getVisibleUser() {
        if (!this.m_fullyLoaded) {
            return this.m_users;
        }
        if (this.size() == this.m_users.size()) {
            return this.m_users;
        }
        ArrayList<CmsUser> directs = new ArrayList<CmsUser>();
        for (CmsUser user : this.m_users) {
            if (this.m_indirects.contains(user)) continue;
            directs.add(user);
        }
        return directs;
    }

    @Override
    public void toggle(boolean pressed) {
        try {
            if (pressed && !this.m_fullyLoaded) {
                this.setAllUsers(this.m_users);
            }
        }
        catch (CmsException e) {
            this.m_fullyLoaded = false;
            LOG.error((Object)"Error loading user", (Throwable)e);
        }
        this.fillContainer(pressed);
    }

    protected void addUserToContainer(IndexedContainer container, CmsUser user) {
        if (this.m_blackList.contains(user)) {
            return;
        }
        Item item = container.addItem((Object)user);
        this.fillItem(item, user);
    }

    protected void fillContainer(boolean showIndirect) {
        this.m_container.removeAllContainerFilters();
        this.m_container.removeAllItems();
        for (CmsUser user : this.m_users) {
            if (!showIndirect && this.m_indirects.contains(user)) continue;
            this.addUserToContainer(this.m_container, user);
        }
        this.setVisibilities();
    }

    protected void fillItem(Item item, CmsUser user) {
        item.getItemProperty((Object)TableProperty.Name).setValue((Object)user.getSimpleName());
        item.getItemProperty((Object)TableProperty.FullName).setValue((Object)user.getFullName());
        item.getItemProperty((Object)TableProperty.SystemName).setValue((Object)user.getName());
        boolean disabled = !user.isEnabled();
        item.getItemProperty((Object)TableProperty.DISABLED).setValue((Object)disabled);
        boolean newUser = user.getLastlogin() == 0L;
        item.getItemProperty((Object)TableProperty.NEWUSER).setValue((Object)newUser);
        try {
            item.getItemProperty((Object)TableProperty.OU).setValue((Object)OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, user.getOuFqn()).getDisplayName(A_CmsUI.get().getLocale()));
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read OU", (Throwable)e);
        }
        item.getItemProperty((Object)TableProperty.LastLogin).setValue((Object)user.getLastlogin());
        item.getItemProperty((Object)TableProperty.Created).setValue((Object)user.getDateCreated());
        item.getItemProperty((Object)TableProperty.INDIRECT).setValue((Object)this.m_indirects.contains(user));
        item.getItemProperty((Object)TableProperty.FROMOTHEROU).setValue((Object)(!user.getOuFqn().equals(this.m_ou) ? 1 : 0));
        item.getItemProperty((Object)TableProperty.STATUS).setValue((Object)this.getStatusInt(disabled, newUser));
    }

    protected void init(boolean showAll) {
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new IndexedContainer();
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefault());
            this.setColumnHeader((Object)prop, prop.getName());
        }
        this.m_app.addUserContainerProperties(this.m_container);
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId((Object)TableProperty.Icon);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setColumnWidth((Object)TableProperty.STATUS, 100);
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.OU});
        this.fillContainer(showAll);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 4807195510202231174L;

            public void itemClick(ItemClickEvent event) {
                CmsUserTable.this.changeValueIfNotMultiSelect(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    HashSet<String> userIds = new HashSet<String>();
                    for (CmsUser user : (Set)CmsUserTable.this.getValue()) {
                        userIds.add(user.getId().getStringValue());
                    }
                    CmsUserTable.this.m_menu.setEntries(CmsUserTable.this.getMenuEntries(), userIds);
                    CmsUserTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsUserTable.this);
                } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && TableProperty.Name.equals(event.getPropertyId())) {
                    CmsUser user = (CmsUser)((Set)CmsUserTable.this.getValue()).iterator().next();
                    try {
                        CmsUserTable.this.openInfoDialog(user.getId());
                    }
                    catch (CmsException e) {
                        LOG.error((Object)"Error on opening user info dialog", (Throwable)e);
                    }
                }
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 4685652851810828147L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (TableProperty.STATUS.equals(propertyId)) {
                    return this.getStatusStyleForItem(source.getItem(itemId), (CmsUser)itemId);
                }
                Object css = " ";
                if (((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.FROMOTHEROU).getValue()).booleanValue()) {
                    css = (String)css + "o-expired";
                }
                if (TableProperty.Name.equals(propertyId)) {
                    css = (String)css + " o-hover-column";
                }
                if (((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.INDIRECT).getValue()).booleanValue()) {
                    return (String)css + " o-table-cell-disabled";
                }
                return ((String)css).length() == 1 ? null : css;
            }

            private String getStatusStyleForItem(Item item, CmsUser user) {
                if (((Boolean)item.getItemProperty((Object)TableProperty.DISABLED).getValue()).booleanValue()) {
                    return " o-box-gray";
                }
                if (OpenCms.getLoginManager().isUserTempDisabled(user.getName())) {
                    return " o-box-red";
                }
                if (((Boolean)item.getItemProperty((Object)TableProperty.NEWUSER).getValue()).booleanValue()) {
                    return " o-box-blue";
                }
                if (CmsUserTable.this.isUserPasswordReset(user)) {
                    return " o-box-orange";
                }
                return " o-box-green";
            }
        });
        this.addGeneratedColumn((Object)TableProperty.STATUS, new Table.ColumnGenerator(){
            private static final long serialVersionUID = -2144476865774782965L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                return CmsUserTable.this.getStatus((CmsUser)itemId, (Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.DISABLED).getValue(), (Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.NEWUSER).getValue());
            }
        });
        this.addGeneratedColumn((Object)TableProperty.LastLogin, new Table.ColumnGenerator(){
            private static final long serialVersionUID = -6781906011584975559L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                long lastLogin = (Long)source.getItem(itemId).getItemProperty((Object)TableProperty.LastLogin).getValue();
                return lastLogin == 0L ? CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_NEVER_LOGGED_IN_0", new Object[0]) : CmsDateUtil.getDateTime(new Date(lastLogin), 3, A_CmsUI.get().getLocale());
            }
        });
        this.addGeneratedColumn((Object)TableProperty.Created, new Table.ColumnGenerator(){
            private static final long serialVersionUID = -6781906011584975559L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                long created = (Long)source.getItem(itemId).getItemProperty((Object)TableProperty.Created).getValue();
                return created == 0L ? "" : CmsDateUtil.getDateTime(new Date(created), 3, A_CmsUI.get().getLocale());
            }
        });
        this.setItemDescriptionGenerator(new AbstractSelect.ItemDescriptionGenerator(){
            private static final long serialVersionUID = 7367011213487089661L;

            public String generateDescription(Component source, Object itemId, Object propertyId) {
                if (TableProperty.STATUS.equals(propertyId)) {
                    return CmsUserTable.this.getStatusHelp((CmsUser)itemId, (Boolean)((Table)source).getItem(itemId).getItemProperty((Object)TableProperty.DISABLED).getValue(), (Boolean)((Table)source).getItem(itemId).getItemProperty((Object)TableProperty.NEWUSER).getValue());
                }
                return null;
            }
        });
        this.setVisibleColumns(new Object[]{TableProperty.STATUS, TableProperty.Name, TableProperty.FullName, TableProperty.OU, TableProperty.LastLogin, TableProperty.Created});
    }

    protected boolean onlyVisibleForOU(CmsUUID userId) {
        try {
            if (this.m_app.isOUManagable(this.m_cms.readUser(userId).getOuFqn())) {
                return true;
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return false;
    }

    protected CmsMenuItemVisibilityMode onlyVisibleForOU(Set<String> context) {
        for (String id : context) {
            if (this.onlyVisibleForOU(new CmsUUID(id))) continue;
            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
    }

    protected void openInfoDialog(CmsUUID id) throws CmsException {
        CmsUserInfoDialog.showUserInfo(this.m_cms.readUser(id));
    }

    void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryInfo());
            this.m_menuEntries.add(new EntryEdit());
            this.m_menuEntries.add(new EntryEditRole());
            this.m_menuEntries.add(new EntryEditGroup());
            this.m_menuEntries.add(new EntryAddInfos());
            this.m_menuEntries.add(new EntryShowResources());
            this.m_menuEntries.add(new EntrySwitchUser());
            this.m_menuEntries.add(new EntryRemoveFromGroup());
            this.m_menuEntries.add(new EntryMoveOU());
            this.m_menuEntries.add(new EntryDelete());
            this.m_menuEntries.add(new EntryKillSession());
            this.m_menuEntries.add(new EntryEnable());
        }
        return this.m_menuEntries;
    }

    String getStatus(CmsUser user, boolean disabled, boolean newUser) {
        if (disabled) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_DISABLED_0", new Object[0]);
        }
        if (OpenCms.getLoginManager().isUserTempDisabled(user.getName())) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_UNLOCK_USER_STATUS_0", new Object[0]);
        }
        if (newUser) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_INACTIVE_0", new Object[0]);
        }
        if (this.isUserPasswordReset(user)) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_PASSWORT_RESET_0", new Object[0]);
        }
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_ACTIVE_0", new Object[0]);
    }

    String getStatusHelp(CmsUser user, boolean disabled, boolean newUser) {
        if (disabled) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_DISABLED_HELP_0", new Object[0]);
        }
        if (newUser) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_INACTIVE_HELP_0", new Object[0]);
        }
        if (this.isUserPasswordReset(user)) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_PASSWORT_RESET_HELP_0", new Object[0]);
        }
        long lastLogin = user.getLastlogin();
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_ACTIVE_HELP_1", CmsDateUtil.getDateTime(new Date(lastLogin), 3, A_CmsUI.get().getLocale()));
    }

    Integer getStatusInt(boolean disabled, boolean newUser) {
        if (disabled) {
            return 2;
        }
        if (newUser) {
            return 1;
        }
        return 0;
    }

    boolean isUserPasswordReset(CmsUser user) {
        Boolean cachedValue = this.m_app.getPasswordResetStateCache().get(user.getId());
        if (cachedValue != null) {
            return cachedValue;
        }
        CmsUser currentUser = user;
        if (user.getAdditionalInfo().size() < 3) {
            try {
                currentUser = this.m_cms.readUser(user.getId());
            }
            catch (CmsException e) {
                LOG.error((Object)"Can not read user", (Throwable)e);
            }
        }
        boolean result = currentUser.getAdditionalInfo("RESET_PASSWORD") != null;
        this.m_app.getPasswordResetStateCache().put(user.getId(), result);
        return result;
    }

    private List<CmsUser> getAllowedIndirects(List<CmsUser> allUsers, List<CmsUser> directUsers) {
        ArrayList<CmsUser> res = new ArrayList<CmsUser>();
        for (CmsUser u : allUsers) {
            if (directUsers.contains(u)) continue;
            res.add(u);
        }
        return res;
    }

    private CmsObject getCmsObject() {
        CmsObject cms;
        try {
            cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException e) {
            cms = A_CmsUI.getCmsObject();
        }
        return cms;
    }

    private boolean isAllowedUser(CmsUser user) throws CmsException {
        if (user.getOuFqn().startsWith(this.m_cms.getRequestContext().getOuFqn())) {
            return true;
        }
        return OpenCms.getRoleManager().getRolesOfUser(this.m_cms, user.getName(), this.m_ou, true, true, false).size() > 0;
    }

    private void setAllUsers(List<CmsUser> directs) throws CmsException {
        this.m_fullyLoaded = true;
        if (this.m_type.equals(CmsOuTreeType.ROLE)) {
            this.m_users = OpenCms.getRoleManager().getUsersOfRole(this.m_cms, CmsRole.valueOfRoleName(this.m_group).forOrgUnit(this.m_ou), true, false);
        } else if (this.m_type.equals(CmsOuTreeType.USER)) {
            this.m_users = this.m_app.getUsersWithoutAdditionalInfo(this.m_cms, this.m_type, this.m_ou, true);
        }
        for (CmsUser u : this.m_users) {
            if (this.isAllowedUser(u)) continue;
            this.m_blackList.add(u);
        }
        this.m_indirects.addAll(this.getAllowedIndirects(this.m_users, directs));
    }

    private void setVisibilities() {
        this.setVisible(this.size() > 0);
        if (this.m_emptyLayout != null) {
            this.m_emptyLayout.setVisible(this.size() == 0);
        }
    }

    public static enum TableProperty {
        Created("GUI_USERMANAGEMENT_USER_DATE_CREATED_0", Long.class, 0L),
        DISABLED("", Boolean.class, false),
        FROMOTHEROU("", Boolean.class, false),
        FullName("GUI_USERMANAGEMENT_USER_NAME_0", String.class, ""),
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-user")),
        INDIRECT("", Boolean.class, false),
        LastLogin("GUI_USERMANAGEMENT_USER_LAST_LOGIN_0", Long.class, 0L),
        Name("GUI_USERMANAGEMENT_USER_USER_0", String.class, ""),
        NEWUSER("", Boolean.class, false),
        OU("GUI_USERMANAGEMENT_USER_OU_0", String.class, ""),
        STATUS("", Integer.class, 0),
        SystemName("", String.class, "");

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String name, Class<?> type, Object defaultValue) {
            this.m_headerMessage = name;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        Object getDefault() {
            return this.m_defaultValue;
        }

        String getName() {
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_headerMessage)) {
                return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
            }
            return "";
        }

        Class<?> getType() {
            return this.m_type;
        }
    }

    class EntryInfo
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryInfo() {
        }

        @Override
        public void executeAction(Set<String> context) {
            try {
                CmsUserTable.this.openInfoDialog(new CmsUUID(context.iterator().next()));
            }
            catch (CmsException e) {
                LOG.error((Object)"Error on opening user info dialog", (Throwable)e);
            }
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_SHOW_USER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class EntryEdit
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryEdit() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_USER_0", new Object[0]));
            window.setContent((Component)new CmsUserEditDialog(CmsUserTable.this.m_cms, new CmsUUID(context.iterator().next()), window, CmsUserTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_USER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            CmsUUID id = new CmsUUID(context.iterator().next());
            return CmsMenuItemVisibilityMode.activeInactive(CmsUserTable.this.m_app.canEditUser(id) && CmsUserTable.this.onlyVisibleForOU(id) && context.size() <= 1);
        }
    }

    class EntryEditRole
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryEditRole() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            window.setContent((Component)new CmsUserEditRoleDialog(CmsUserTable.this.m_cms, new CmsUUID(context.iterator().next()), window, CmsUserTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_USERROLES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            return CmsMenuItemVisibilityMode.activeInactive(CmsUserTable.this.onlyVisibleForOU(new CmsUUID(context.iterator().next())) && context.size() <= 1);
        }
    }

    class EntryEditGroup
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryEditGroup() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            window.setContent((Component)new CmsUserEditGroupsDialog(CmsUserTable.this.m_cms, new CmsUUID(context.iterator().next()), window, CmsUserTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_USERGROUP_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            return CmsMenuItemVisibilityMode.activeInactive(CmsUserTable.this.onlyVisibleForOU(new CmsUUID(context.iterator().next())) && context.size() <= 1);
        }
    }

    class EntryAddInfos
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryAddInfos() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
            CmsAdditionalInfosDialog dialog = new CmsAdditionalInfosDialog(CmsUserTable.this.m_cms, new CmsUUID(context.iterator().next()), window, CmsUserTable.this.m_app);
            window.setContent((Component)dialog);
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_ADDITIONAL_INFOS_MENU_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class EntryShowResources
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryShowResources() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_SHOW_RESOURCES_0", new Object[0]));
            window.setContent((Component)new CmsShowResourcesDialog(context.iterator().next(), window));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_SHOW_RESOURCES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class EntrySwitchUser
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntrySwitchUser() {
        }

        @Override
        public void executeAction(Set<String> context) {
            final Window window = CmsBasicDialog.prepareWindow();
            final CmsUUID userID = new CmsUUID(context.iterator().next());
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_MESSAGES_SWITCH_USER_0", new Object[0]));
            CmsConfirmationDialog dialog = new CmsConfirmationDialog(CmsVaadinUtils.getMessageText("GUI_MESSAGES_SWITCH_USER_CONFIRM_0", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    try {
                        Object path = OpenCms.getSessionManager().switchUser(A_CmsUI.getCmsObject(), CmsVaadinUtils.getRequest(), CmsUserTable.this.m_cms.readUser(userID));
                        if (path == null) {
                            path = CmsVaadinUtils.getWorkplaceLink() + "?_lrid=" + new Date().getTime();
                        }
                        A_CmsUI.get().getPage().setLocation((String)path);
                        if (((String)path).contains("workplace#")) {
                            A_CmsUI.get().getPage().reload();
                        }
                        window.close();
                    }
                    catch (CmsException e) {
                        LOG.error((Object)"Unable to swith user", (Throwable)e);
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    window.close();
                }
            });
            window.setContent((Component)dialog);
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_SWITCH_USER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            try {
                OpenCms.getRoleManager().checkRole(CmsUserTable.this.m_cms, CmsRole.ADMINISTRATOR);
                return CmsMenuItemVisibilityMode.activeInactive(CmsUserTable.this.onlyVisibleForOU(new CmsUUID(context.iterator().next())) && context.size() <= 1);
            }
            catch (CmsRoleViolationException e) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        }
    }

    class EntryRemoveFromGroup
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryRemoveFromGroup() {
        }

        @Override
        public void executeAction(Set<String> context) {
            try {
                final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                final String user = CmsUserTable.this.m_cms.readUser(new CmsUUID(context.iterator().next())).getName();
                String confirmText = "";
                String caption = "";
                Runnable okRunnable = null;
                if (CmsUserTable.this.m_type.isGroup()) {
                    caption = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_REMOVE_USER_FROM_GROUP_0", new Object[0]);
                    confirmText = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_REMOVE_USER_FROM_GROUP_CONFIRM_2", user, CmsUserTable.this.m_group);
                    okRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CmsUserTable.this.m_cms.removeUserFromGroup(user, CmsUserTable.this.m_group);
                            }
                            catch (CmsException cmsException) {
                                // empty catch block
                            }
                            window.close();
                            CmsUserTable.this.m_app.reload();
                        }
                    };
                }
                if (CmsUserTable.this.m_type.equals(CmsOuTreeType.ROLE)) {
                    caption = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_REMOVE_USER_FROM_ROLE_0", new Object[0]);
                    confirmText = CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_REMOVE_USER_FROM_ROLE_CONFIRM_2", user, CmsUserTable.this.m_group);
                    okRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                OpenCms.getRoleManager().removeUserFromRole(CmsUserTable.this.m_cms, CmsRole.valueOfRoleName(CmsUserTable.this.m_group), user);
                            }
                            catch (CmsException cmsException) {
                                // empty catch block
                            }
                            window.close();
                            CmsUserTable.this.m_app.reload();
                        }
                    };
                }
                window.setCaption(caption);
                window.setContent((Component)new CmsConfirmationDialog(confirmText, okRunnable, new Runnable(){

                    @Override
                    public void run() {
                        window.close();
                    }
                }));
                A_CmsUI.get().addWindow(window);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }

        @Override
        public String getTitle(Locale locale) {
            if (CmsUserTable.this.m_type.isGroup()) {
                return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_REMOVE_USER_FROM_GROUP_0", new Object[0]);
            }
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_REMOVE_USER_FROM_ROLE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (!CmsUserTable.this.m_app.canRemoveGroupMemebers(CmsUserTable.this.m_group)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            if (CmsUserTable.this.m_group == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            try {
                CmsUser user = CmsUserTable.this.m_cms.readUser(context.iterator().next());
                return (Boolean)CmsUserTable.this.getItem(user).getItemProperty((Object)TableProperty.INDIRECT).getValue() != false ? CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            catch (CmsException cmsException) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
        }
    }

    class EntryMoveOU
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryMoveOU() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            CmsMoveUserToOU dialog = null;
            dialog = new CmsMoveUserToOU(CmsUserTable.this.m_cms, new CmsUUID(context.iterator().next()), window, CmsUserTable.this.m_app);
            window.setContent((Component)dialog);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_MOVE_OU_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_MOVE_OU_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            try {
                if (OpenCms.getOrgUnitManager().readOrganizationalUnit(CmsUserTable.this.m_cms, CmsUserTable.this.m_ou).hasFlagWebuser()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read OU", (Throwable)e);
            }
            return CmsUserTable.this.onlyVisibleForOU(context);
        }
    }

    class EntryDelete
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryDelete() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            CmsDeleteMultiplePrincipalDialog dialog = null;
            dialog = new CmsDeleteMultiplePrincipalDialog(CmsUserTable.this.m_cms, context, window, CmsUserTable.this.m_app);
            window.setContent((Component)dialog);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_DELETE_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            return CmsUserTable.this.onlyVisibleForOU(context);
        }
    }

    class EntryKillSession
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryKillSession() {
        }

        @Override
        public void executeAction(Set<String> context) {
            final Window window = CmsBasicDialog.prepareWindow();
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_MESSAGES_DESTROY_SESSION_0", new Object[0]));
            HashSet<String> sessionIds = new HashSet<String>();
            for (CmsSessionInfo info : OpenCms.getSessionManager().getSessionInfos(new CmsUUID(context.iterator().next()))) {
                sessionIds.add(info.getSessionId().getStringValue());
            }
            CmsKillSessionDialog dialog = new CmsKillSessionDialog(sessionIds, new Runnable(){

                @Override
                public void run() {
                    window.close();
                }
            });
            window.setContent((Component)dialog);
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_DESTROY_SESSION_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            if (!OpenCms.getSessionManager().getSessionInfos(new CmsUUID(context.iterator().next())).isEmpty()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
        }
    }

    class EntryEnable
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryEnable() {
        }

        @Override
        public void executeAction(Set<String> context) {
            final Window window = CmsBasicDialog.prepareWindow();
            try {
                final CmsUser user = CmsUserTable.this.m_cms.readUser(new CmsUUID(context.iterator().next()));
                CmsConfirmationDialog dialog = new CmsConfirmationDialog(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_UNLOCK_USER_LABEL_0", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        OpenCms.getLoginManager().resetUserTempDisable(user.getName());
                        window.close();
                        CmsUserTable.this.m_app.reload();
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        window.close();
                    }
                });
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_UNLOCK_USER_CAPTION_1", user.getName()));
                window.setContent((Component)dialog);
                A_CmsUI.get().addWindow(window);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read user", (Throwable)e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_UNLOCK_USER_CONTEXT_MENU_TITLE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            try {
                CmsUser user = CmsUserTable.this.m_cms.readUser(new CmsUUID(context.iterator().next()));
                if (OpenCms.getLoginManager().isUserTempDisabled(user.getName())) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
                }
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            catch (CmsException e) {
                LOG.error((Object)"Can not read user.", (Throwable)e);
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        }
    }
}

