/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.util;

import com.google.common.collect.Maps;
import com.vaadin.ui.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.opencms.ui.apps.util.ProvidesAppAttribute;

public class CmsReflectionAppAttributeProvider {
    public static Map<String, Object> getComponentAttributes(Component component) {
        Class<?> cls = component.getClass();
        HashMap result = Maps.newHashMap();
        for (Method method : cls.getDeclaredMethods()) {
            ProvidesAppAttribute annotation = method.getAnnotation(ProvidesAppAttribute.class);
            if (annotation == null) continue;
            Object val = null;
            try {
                val = method.invoke((Object)component, new Object[0]);
                result.put(annotation.name(), val);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw new RuntimeException(cause);
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (!(cause instanceof Error)) continue;
                throw (Error)cause;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

