/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;

public class CmsComponentState {
    static final Log LOG = CmsLog.getLog(CmsComponentState.class);
    private static final String SITE = "s";
    private static final String FOLDER = "f";
    private static final String RESOURCE_TYPE = "t";
    private static final String DATE_FROM = "d1";
    private static final String DATE_TO = "d2";
    private static final String AVAILABILITY = "a";
    private static final String LOCALE = "l";
    private static final String QUERY = "q";
    private static final String CATEGORY = "c";
    String m_site;
    String m_folder;
    I_CmsResourceType m_resourceType;
    Date m_dateFrom;
    Date m_dateTo;
    String m_availability;
    Locale m_locale;
    String m_query;
    String m_category;

    public CmsComponentState() {
    }

    public CmsComponentState(String state) {
        this.parseStateString(state);
    }

    public String generateStateString() {
        String state = "";
        if (this.m_site != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, SITE, this.m_site);
        }
        if (this.m_folder != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, FOLDER, this.m_folder);
        }
        if (this.m_resourceType != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, RESOURCE_TYPE, this.m_resourceType.getTypeName());
        }
        if (this.m_dateFrom != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, DATE_FROM, String.valueOf(this.m_dateFrom.getTime()));
        }
        if (this.m_dateTo != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, DATE_TO, String.valueOf(this.m_dateTo.getTime()));
        }
        if (this.m_availability != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, AVAILABILITY, this.m_availability);
        }
        if (this.m_locale != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, LOCALE, this.m_locale.toString());
        }
        if (this.m_query != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, QUERY, this.m_query);
        }
        if (this.m_category != null) {
            state = A_CmsWorkplaceApp.addParamToState(state, CATEGORY, this.m_category);
        }
        return state;
    }

    public String getAvailability() {
        return this.m_availability;
    }

    public String getCategory() {
        return this.m_category;
    }

    public Date getDateFrom() {
        return this.m_dateFrom;
    }

    public Date getDateTo() {
        return this.m_dateTo;
    }

    public String getFolder() {
        return this.m_folder;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getQuery() {
        return this.m_query;
    }

    public I_CmsResourceType getResourceType() {
        return this.m_resourceType;
    }

    public String getSite() {
        return this.m_site;
    }

    public void parseStateString(String state) {
        if (state != null) {
            String category;
            String query;
            String locale;
            String availability;
            String dateTo;
            String folder;
            String site = A_CmsWorkplaceApp.getParamFromState(state, SITE);
            if (site != null) {
                this.m_site = site.replace("%2F", "/");
            }
            if ((folder = A_CmsWorkplaceApp.getParamFromState(state, FOLDER)) != null) {
                this.m_folder = folder.replace("%2F", "/");
            }
            try {
                String typeName = A_CmsWorkplaceApp.getParamFromState(state, RESOURCE_TYPE);
                if (typeName != null) {
                    I_CmsResourceType type;
                    this.m_resourceType = type = OpenCms.getResourceManager().getResourceType(typeName);
                }
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            String dateFrom = A_CmsWorkplaceApp.getParamFromState(state, DATE_FROM);
            if (dateFrom != null) {
                try {
                    this.m_dateFrom = new Date(Long.parseLong(dateFrom));
                }
                catch (NumberFormatException e) {
                    this.m_dateFrom = null;
                }
            }
            if ((dateTo = A_CmsWorkplaceApp.getParamFromState(state, DATE_TO)) != null) {
                try {
                    this.m_dateTo = new Date(Long.parseLong(dateTo));
                }
                catch (NumberFormatException e) {
                    this.m_dateTo = null;
                }
            }
            if ((availability = A_CmsWorkplaceApp.getParamFromState(state, AVAILABILITY)) != null) {
                this.m_availability = availability;
            }
            if ((locale = A_CmsWorkplaceApp.getParamFromState(state, LOCALE)) != null) {
                this.m_locale = CmsLocaleManager.getLocale(locale);
            }
            if ((query = A_CmsWorkplaceApp.getParamFromState(state, QUERY)) != null) {
                this.m_query = query.replace("%2F", "/");
            }
            if ((category = A_CmsWorkplaceApp.getParamFromState(state, CATEGORY)) != null) {
                this.m_category = category.replace("%2F", "/");
            }
        }
    }

    public void setAvailability(String availability) {
        this.m_availability = availability;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public void setDateFrom(Date dateFrom) {
        this.m_dateFrom = dateFrom;
    }

    public void setDateTo(Date dateTo) {
        this.m_dateTo = dateTo;
    }

    public void setFolder(String folder) {
        this.m_folder = folder;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }

    public void setResourceType(I_CmsResourceType resourceType) {
        this.m_resourceType = resourceType;
    }

    public void setSite(String site) {
        this.m_site = site;
    }
}

