/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsConfirmationDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 1L;
    private Button m_okButton;
    private Button m_cancelButton;
    private Label m_label;
    private Label m_icon;
    Runnable m_okAction;
    Runnable m_cancelAction;

    public CmsConfirmationDialog(String message, Runnable okAction, Runnable cancelAction) {
        this.m_okAction = okAction;
        this.m_cancelAction = cancelAction;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_label.setValue(message);
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.WARNING.getHtml());
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsConfirmationDialog.this.m_okAction != null) {
                    CmsConfirmationDialog.this.m_okAction.run();
                }
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsConfirmationDialog.this.m_cancelAction != null) {
                    CmsConfirmationDialog.this.m_cancelAction.run();
                }
            }
        });
    }

    public static CmsConfirmationDialog show(String title, String message, Runnable okAction) {
        return CmsConfirmationDialog.show(title, message, okAction, null);
    }

    public static CmsConfirmationDialog show(String title, String message, final Runnable okAction, final Runnable cancelAction) {
        final Window window = CmsBasicDialog.prepareWindow();
        window.setCaption(title);
        CmsConfirmationDialog dialog = new CmsConfirmationDialog(message, new Runnable(){

            @Override
            public void run() {
                window.close();
                okAction.run();
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (cancelAction != null) {
                    cancelAction.run();
                }
                window.close();
            }
        });
        window.setContent((Component)dialog);
        UI.getCurrent().addWindow(window);
        return dialog;
    }

    public static CmsConfirmationDialog show(String title, String message, final Runnable okAction, final Runnable cancelAction, boolean hideUnused) {
        final Window window = CmsBasicDialog.prepareWindow();
        window.setCaption(title);
        Runnable newOk = null;
        Runnable newCancel = null;
        if (okAction != null) {
            newOk = new Runnable(){

                @Override
                public void run() {
                    window.close();
                    okAction.run();
                }
            };
        }
        if (cancelAction != null) {
            newCancel = new Runnable(){

                @Override
                public void run() {
                    window.close();
                    cancelAction.run();
                }
            };
        }
        CmsConfirmationDialog dialog = new CmsConfirmationDialog(message, newOk, newCancel);
        dialog.setHideUnusedButtons(hideUnused);
        window.setContent((Component)dialog);
        UI.getCurrent().addWindow(window);
        return dialog;
    }

    public Label getLabel() {
        return this.m_label;
    }

    public void setHideUnusedButtons(boolean hide) {
        this.m_okButton.setVisible(!hide || this.m_okAction != null);
        this.m_cancelButton.setVisible(!hide || this.m_cancelAction != null);
    }

    public void setMessage(String message) {
        this.m_label.setValue(message);
    }
}

