/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.categoryselect;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.HorizontalLayout;
import java.util.ArrayList;
import java.util.Collection;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.categoryselect.CmsCategorySelectDialog;
import org.opencms.ui.components.categoryselect.CmsCategoryTree;
import org.opencms.ui.components.fileselect.I_CmsSelectionHandler;
import org.opencms.util.CmsStringUtil;

public class CmsCategorySelectField
extends CustomField<String>
implements I_CmsSelectionHandler<Collection<CmsCategory>> {
    private static final long serialVersionUID = -3080639027333425153L;
    private CmsCategorySelectDialog m_dialog;
    private Window m_dialogWindow;
    private CmsCategoryTree m_tree;

    public Class<? extends String> getType() {
        return String.class;
    }

    @Override
    public void onSelection(Collection<CmsCategory> selected) {
        this.setValue(this.getStringValue(selected));
        this.m_dialogWindow.close();
    }

    protected String getInternalValue() {
        if (this.m_tree == null) {
            String result = (String)super.getInternalValue();
            return result != null ? result : "";
        }
        CmsObject cms = A_CmsUI.getCmsObject();
        Object result = "";
        for (CmsCategory cat : this.m_tree.getSelectedCategories()) {
            result = (String)result + cms.getRequestContext().removeSiteRoot(cat.getRootPath()) + ",";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return this.getStringValue(this.m_tree.getSelectedCategories());
    }

    protected Component initContent() {
        HorizontalLayout main = new HorizontalLayout();
        main.setWidth("100%");
        main.setSpacing(true);
        this.m_tree = new CmsCategoryTree();
        this.m_tree.setWidth("100%");
        this.m_tree.setHeight("34px");
        this.m_tree.setDisplayOnly(true);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)super.getInternalValue())) {
            this.setInternalValue((String)super.getInternalValue());
        }
        main.addComponent((Component)this.m_tree);
        main.setExpandRatio((Component)this.m_tree, 2.0f);
        Button open = new Button("");
        open.addStyleName("o-button-icon");
        open.setIcon((Resource)FontOpenCms.GALLERY);
        open.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCategorySelectField.this.openWindow();
            }
        });
        main.addComponent((Component)open);
        return main;
    }

    protected void setInternalValue(String newValue) {
        if (this.m_tree != null) {
            ArrayList<CmsCategory> categories = new ArrayList<CmsCategory>();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(newValue)) {
                CmsObject cms = A_CmsUI.getCmsObject();
                CmsCategoryService catService = CmsCategoryService.getInstance();
                for (String path : newValue.split(",")) {
                    try {
                        CmsCategory cat = catService.getCategory(cms, path);
                        categories.add(cat);
                    }
                    catch (CmsException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.m_tree.setCategories(categories);
            int height = categories.size() * 33 + 1;
            if (height > 200) {
                height = 200;
            }
            this.m_tree.setHeight(height + "px");
        }
        super.setInternalValue((Object)newValue);
    }

    void openWindow() {
        if (this.m_dialogWindow == null) {
            this.m_dialogWindow = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            this.m_dialogWindow.setCaption("Select categories");
        }
        if (this.m_dialog == null) {
            this.m_dialog = new CmsCategorySelectDialog("/");
            this.m_dialogWindow.setContent((Component)this.m_dialog);
            this.m_dialog.addSelectionHandler(this);
        }
        A_CmsUI.get().addWindow(this.m_dialogWindow);
        this.m_dialogWindow.center();
        this.m_dialog.setSelectedCategories(this.m_tree.getSelectedCategories());
    }

    private String getStringValue(Collection<CmsCategory> categories) {
        CmsObject cms = A_CmsUI.getCmsObject();
        Object result = "";
        for (CmsCategory cat : categories) {
            result = (String)result + cms.getRequestContext().removeSiteRoot(cat.getRootPath()) + ",";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }
}

