/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.extensions;

import com.google.common.util.concurrent.FutureCallback;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.UI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.opencms.ui.shared.rpc.I_CmsWindowClientRpc;
import org.opencms.ui.shared.rpc.I_CmsWindowServerRpc;

public class CmsWindowExtension
extends AbstractExtension {
    private static final long serialVersionUID = 1L;
    private Map<String, FutureCallback<Boolean>> m_callbackMap = new ConcurrentHashMap<String, FutureCallback<Boolean>>();

    public CmsWindowExtension(UI ui) {
        super((AbstractClientConnector)ui);
        this.registerRpc(new I_CmsWindowServerRpc(){
            private static final long serialVersionUID = 1L;

            @Override
            public void handleOpenResult(String id, boolean ok) {
                FutureCallback<Boolean> callback = CmsWindowExtension.this.m_callbackMap.get(id);
                if (callback != null) {
                    callback.onSuccess((Object)ok);
                }
                CmsWindowExtension.this.m_callbackMap.remove(id);
            }
        }, I_CmsWindowServerRpc.class);
    }

    public void open(String location, String target, final Runnable onFailure) {
        String id = RandomStringUtils.randomAlphanumeric((int)16);
        this.m_callbackMap.put(id, new FutureCallback<Boolean>(){

            public void onFailure(Throwable t) {
            }

            public void onSuccess(Boolean result) {
                if (!result.booleanValue()) {
                    onFailure.run();
                }
            }
        });
        ((I_CmsWindowClientRpc)this.getRpcProxy(I_CmsWindowClientRpc.class)).open(location, target, id);
    }
}

