/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.types.CmsResourceTypeFolderSubSitemap;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.tools.CmsContainerPageCopier;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsMacroResolverDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.Messages;

public class CmsCopyMoveDialog
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsCopyMoveDialog.class);
    private static final long serialVersionUID = 1L;
    List<Action> m_defaultActions;
    private ComboBox m_actionCombo;
    private Button m_cancelButton;
    private CmsObject m_cms;
    private I_CmsDialogContext m_context;
    private DialogMode m_dialogMode;
    private boolean m_hasContainerPageDefaultFile;
    private CmsMacroResolverDialog m_macroDialog;
    private Button m_okButton;
    private CheckBox m_overwriteExisting;
    private CmsObject m_rootCms;
    private CmsPathSelectField m_targetPath;
    private Set<CmsUUID> m_updateResources;

    public CmsCopyMoveDialog(I_CmsDialogContext context, DialogMode mode) {
        this.m_dialogMode = mode;
        this.m_updateResources = new HashSet<CmsUUID>();
        this.m_context = context;
        this.m_defaultActions = new ArrayList<Action>();
        this.displayResourceInfo(context.getResources());
        FormLayout form = this.initForm();
        this.setContent((Component)form);
        this.updateDefaultActions(null);
        this.m_okButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]));
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCopyMoveDialog.this.submit(false, null);
            }
        });
        this.addButton((Component)this.m_okButton);
        this.m_cancelButton = new Button(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]));
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsCopyMoveDialog.this.cancel();
            }
        });
        this.addButton((Component)this.m_cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsCopyMoveDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsCopyMoveDialog.this.submit(false, null);
            }
        });
    }

    public void setTargetFolder(CmsUUID structureId) throws CmsException {
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsResource res = cms.readResource(structureId);
        this.setTargetForlder(res);
    }

    public void setTargetForlder(CmsResource resource) {
        block7: {
            if (resource.isFolder()) {
                if (this.m_context.getResources().size() == 1) {
                    try {
                        if (this.m_dialogMode.equals((Object)DialogMode.copy) | (this.m_dialogMode.equals((Object)DialogMode.copy_and_move) && CmsResource.getParentFolder(this.m_context.getResources().get(0).getRootPath()).equals(resource.getRootPath()))) {
                            this.m_targetPath.setValue(this.getTargetName(this.m_context.getResources().get(0), resource));
                            break block7;
                        }
                        this.m_targetPath.setValue(this.getCms().getSitePath(resource) + this.getTargetName(this.m_context.getResources().get(0), resource));
                    }
                    catch (CmsException e) {
                        this.m_targetPath.setValue(this.getCms().getSitePath(resource));
                    }
                } else {
                    this.m_targetPath.setValue(this.getCms().getSitePath(resource));
                }
            } else {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_COPY_MULTI_TARGET_NOFOLDER_1", A_CmsUI.getCmsObject().getSitePath(resource)));
            }
        }
        this.updateDefaultActions(resource.getRootPath());
    }

    protected Map<String, String> getMacroMap() {
        return this.m_macroDialog.getMacroMap();
    }

    protected void performSingleOperation(CmsResource source, CmsResource target, Action action, boolean overwrite, Map<String, String> makroMap) throws CmsException {
        this.performSingleOperation(source, target, this.getTargetName(source, target), action, overwrite, makroMap);
    }

    protected void performSingleOperation(CmsResource source, CmsResource target, String name, Action action, boolean overwrite, Map<String, String> macroMap) throws CmsException {
        this.m_updateResources.add(target.getStructureId());
        this.m_updateResources.add(source.getStructureId());
        String finalTarget = target.getRootPath();
        if (finalTarget.equals(source.getRootPath()) || finalTarget.startsWith(source.getRootPath())) {
            throw new CmsVfsException(Messages.get().container("ERR_COPY_ONTO_ITSELF_1", finalTarget));
        }
        finalTarget = CmsStringUtil.joinPaths(finalTarget, name);
        if (overwrite && this.getRootCms().existsResource(finalTarget, CmsResourceFilter.ONLY_VISIBLE)) {
            CmsLockUtil.ensureLock(this.getRootCms(), this.getRootCms().readResource(finalTarget, CmsResourceFilter.ONLY_VISIBLE));
            if (this.getRootCms().existsResource(finalTarget, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) && action != Action.container_page_automatic && action != Action.container_page_copy && action != Action.container_page_reuse) {
                this.getRootCms().deleteResource(finalTarget, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
        }
        if (action == Action.move) {
            CmsResource parent = this.getRootCms().readParentFolder(source.getStructureId());
            this.m_updateResources.add(parent.getStructureId());
            CmsLockActionRecord lockRecord = CmsLockUtil.ensureLock(this.getRootCms(), source);
            this.getRootCms().moveResource(source.getRootPath(), finalTarget);
            if (lockRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                this.getRootCms().unlockResource(finalTarget);
            }
        } else if (action == Action.container_page_automatic || action == Action.container_page_copy || action == Action.container_page_reuse) {
            CmsContainerPageCopier copier = new CmsContainerPageCopier(this.m_context.getCms());
            try {
                CmsContainerPageCopier.CopyMode mode = action == Action.container_page_automatic ? CmsContainerPageCopier.CopyMode.automatic : (action == Action.container_page_copy ? CmsContainerPageCopier.CopyMode.smartCopyAndChangeLocale : CmsContainerPageCopier.CopyMode.reuse);
                copier.setCopyMode(mode);
                copier.run(this.m_context.getResources().get(0), target, name);
                this.m_context.finish(Arrays.asList(copier.getTargetFolder().getStructureId(), copier.getCopiedFolderOrPage().getStructureId()));
            }
            catch (CmsException e) {
                this.m_context.error(e);
            }
            catch (CmsContainerPageCopier.NoCustomReplacementException e) {
                String errorMessage = CmsVaadinUtils.getMessageText("GUI_COPYPAGE_NO_REPLACEMENT_FOUND_1", e.getResource().getRootPath());
                CmsErrorDialog.showErrorDialog(errorMessage, e);
            }
        } else {
            CmsResource.CmsResourceCopyMode copyMode = null;
            switch ((Action)((Object)this.m_actionCombo.getValue())) {
                case copy_all: {
                    copyMode = CmsResource.COPY_AS_NEW;
                    break;
                }
                case copy_sibling_all: {
                    copyMode = CmsResource.COPY_AS_SIBLING;
                    break;
                }
                default: {
                    copyMode = CmsResource.COPY_PRESERVE_SIBLING;
                }
            }
            CmsMacroResolver.copyAndResolveMacro(this.getRootCms(), source.getRootPath(), finalTarget, macroMap, action == Action.sub_sitemap, copyMode);
            this.getRootCms().unlockResource(finalTarget);
            CmsResource copyResource = this.getRootCms().readResource(finalTarget, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_updateResources.add(copyResource.getStructureId());
        }
    }

    protected void updateOverwriteExisting() {
        if (this.m_overwriteExisting != null) {
            boolean move;
            boolean bl = move = this.m_dialogMode == DialogMode.move || this.m_actionCombo.getValue() == Action.move;
            if (move) {
                this.m_overwriteExisting.setValue((Object)Boolean.FALSE);
                this.m_overwriteExisting.setVisible(false);
            } else {
                this.m_overwriteExisting.setVisible(true);
            }
        }
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void submit(boolean overwrite, Map<String, String> makroMap) {
        try {
            List<CmsResource> collidingResources;
            CmsObject cms;
            CmsResource targetFolder = null;
            String targetName = null;
            String target = this.m_targetPath.getValue();
            boolean isSingleResource = this.m_context.getResources().size() == 1;
            target = CmsLinkManager.getAbsoluteUri(target, CmsResource.getParentFolder(this.getCms().getSitePath(this.m_context.getResources().get(0))));
            CmsObject cmsObject = cms = OpenCms.getSiteManager().getSiteForRootPath(target) != null ? this.getRootCms() : this.getCms();
            if (cms.existsResource(target, CmsResourceFilter.ALL.addRequireFolder())) {
                targetFolder = cms.readResource(target);
            } else if (cms.existsResource(target, CmsResourceFilter.ALL.addRequireFile())) {
                if (!isSingleResource) throw new CmsVfsException(Messages.get().container("ERR_COPY_MULTI_TARGET_NOFOLDER_1", target));
                if (target.equals(this.m_context.getResources().get(0).getRootPath())) {
                    throw new CmsVfsException(Messages.get().container("ERR_COPY_ONTO_ITSELF_1", target));
                }
                targetName = CmsResource.getName(target);
                targetFolder = cms.readResource(CmsResource.getParentFolder(target));
            } else {
                if (!isSingleResource) throw new CmsVfsException(Messages.get().container("ERR_COPY_MULTI_TARGET_NOFOLDER_1", target));
                if (!cms.existsResource(CmsResource.getParentFolder(target), CmsResourceFilter.ALL.addRequireFolder())) throw new CmsVfsException(Messages.get().container("ERR_COPY_TARGET_PARENT_FOLDER_MISSING_1", target));
                targetName = CmsResource.getName(target);
                targetFolder = cms.readResource(CmsResource.getParentFolder(target));
            }
            Action action = this.m_actionCombo != null ? (Action)((Object)this.m_actionCombo.getValue()) : Action.move;
            boolean bl = overwrite = overwrite || this.isOverwriteExisting();
            if ((!overwrite || action.equals((Object)Action.move)) && (collidingResources = this.getExistingFileCollisions(targetFolder, targetName)) != null) {
                if (action.equals((Object)Action.move)) {
                    throw new CmsVfsException(Messages.get().container("ERR_MOVE_FORCES_OVERWRITE_EXISTING_RESOURCE_0"));
                }
                this.showConfirmOverwrite(collidingResources);
                return;
            }
            HashMap<CmsResource, CmsException> errors = new HashMap<CmsResource, CmsException>();
            if (action == Action.sub_sitemap & makroMap == null && CmsSiteManager.isFolderWithMacros(this.getRootCms(), this.m_context.getResources().get(0).getRootPath())) {
                this.showMacroResolverDialog(this.m_context.getResources().get(0));
                return;
            }
            if (targetName == null) {
                for (CmsResource source : this.m_context.getResources()) {
                    try {
                        this.performSingleOperation(source, targetFolder, action, overwrite, makroMap);
                    }
                    catch (CmsException e) {
                        errors.put(source, e);
                        LOG.error((Object)("Error while executing " + action + " on resource " + source.getRootPath()), (Throwable)e);
                    }
                }
            } else {
                CmsResource source = this.m_context.getResources().get(0);
                try {
                    this.performSingleOperation(source, targetFolder, targetName, action, overwrite, makroMap);
                }
                catch (CmsException e) {
                    errors.put(source, e);
                    LOG.error((Object)("Error while executing " + this.m_actionCombo.getValue().toString() + " on resource " + source.getRootPath()), (Throwable)e);
                }
            }
            if (!errors.isEmpty()) {
                if (this.m_context instanceof CmsEmbeddedDialogContext) {
                    this.m_context.error((Throwable)errors.values().iterator().next());
                    return;
                } else {
                    this.m_context.finish(this.m_updateResources);
                    this.m_context.error((Throwable)errors.values().iterator().next());
                }
                return;
            } else {
                this.m_context.finish(this.m_updateResources);
            }
            return;
        }
        catch (CmsException e) {
            this.m_context.error(e);
        }
    }

    private CmsObject getCms() {
        if (this.m_cms == null) {
            this.m_cms = A_CmsUI.getCmsObject();
        }
        return this.m_cms;
    }

    private List<CmsResource> getExistingFileCollisions(CmsResource targetFolder, String targetName) throws CmsException {
        ArrayList<CmsResource> collidingResources = new ArrayList<CmsResource>();
        Object finalTarget = targetFolder.getRootPath();
        if (!((String)finalTarget).endsWith("/")) {
            finalTarget = (String)finalTarget + "/";
        }
        if (targetName == null) {
            for (CmsResource source : this.m_context.getResources()) {
                if (((String)finalTarget).equals(CmsResource.getParentFolder(source.getRootPath()))) {
                    return null;
                }
                String fileName = (String)finalTarget + source.getName();
                if (!this.getRootCms().existsResource(fileName, CmsResourceFilter.ALL)) continue;
                collidingResources.add(source);
            }
        } else {
            String fileName = (String)finalTarget + targetName;
            if (this.getRootCms().existsResource(fileName, CmsResourceFilter.ALL)) {
                collidingResources.add(this.getRootCms().readResource(fileName, CmsResourceFilter.ALL));
            }
        }
        return collidingResources.isEmpty() ? null : collidingResources;
    }

    private CmsObject getRootCms() throws CmsException {
        if (this.m_rootCms == null) {
            this.m_rootCms = OpenCms.initCmsObject(this.getCms());
            this.m_rootCms.getRequestContext().setSiteRoot("/");
        }
        return this.m_rootCms;
    }

    private String getTargetName(CmsResource source, CmsResource target) throws CmsException {
        Object folderRootPath = target.getRootPath();
        if (!((String)folderRootPath).endsWith("/")) {
            folderRootPath = (String)folderRootPath + "/";
        }
        String name = ((String)folderRootPath).equals(CmsResource.getParentFolder(source.getRootPath())) ? OpenCms.getResourceManager().getNameGenerator().getCopyFileName(this.getRootCms(), (String)folderRootPath, source.getName()) : source.getName();
        return name;
    }

    private boolean hasContainerPageDefaultFile(CmsResource folder) {
        try {
            CmsResource defaultFile = A_CmsUI.getCmsObject().readDefaultFile(folder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            return defaultFile != null && CmsResourceTypeXmlContainerPage.isContainerPage(defaultFile);
        }
        catch (CmsSecurityException e) {
            return false;
        }
    }

    private FormLayout initForm() {
        FormLayout form = new FormLayout();
        form.setWidth("100%");
        this.m_targetPath = new CmsPathSelectField();
        this.m_targetPath.setCaption(CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_TARGET_0", new Object[0]));
        this.m_targetPath.setFileSelectCaption(CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_SELECT_TARGET_CAPTION_0", new Object[0]));
        this.m_targetPath.setResourceFilter(CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireFolder());
        this.m_targetPath.setWidth("100%");
        form.addComponent((Component)this.m_targetPath);
        if (this.m_dialogMode != DialogMode.move) {
            this.m_actionCombo = new ComboBox();
            this.m_actionCombo.setCaption(CmsVaadinUtils.getMessageText("GUI_COPYPAGE_COPY_MODE_0", new Object[0]));
            this.m_actionCombo.setNullSelectionAllowed(false);
            this.m_actionCombo.setNewItemsAllowed(false);
            this.m_actionCombo.setWidth("100%");
            if (this.m_context.getResources().size() == 1) {
                if (this.m_context.getResources().get(0).isFile()) {
                    this.m_actionCombo.addItem((Object)Action.copy_all);
                    this.m_actionCombo.setItemCaption((Object)Action.copy_all, CmsVaadinUtils.getMessageText("GUI_COPY_AS_NEW_0", new Object[0]));
                    this.m_actionCombo.addItem((Object)Action.copy_sibling_all);
                    this.m_actionCombo.setItemCaption((Object)Action.copy_sibling_all, CmsVaadinUtils.getMessageText("GUI_CREATE_SIBLING_0", new Object[0]));
                    if (this.m_dialogMode == DialogMode.copy_and_move) {
                        this.m_actionCombo.addItem((Object)Action.move);
                        this.m_actionCombo.setItemCaption((Object)Action.move, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_MOVE_FILE_0", new Object[0]));
                    }
                } else {
                    CmsResource folder = this.m_context.getResources().get(0);
                    this.m_hasContainerPageDefaultFile = this.hasContainerPageDefaultFile(folder);
                    if (this.m_hasContainerPageDefaultFile) {
                        this.m_actionCombo.addItem((Object)Action.container_page_automatic);
                        this.m_actionCombo.setItemCaption((Object)Action.container_page_automatic, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_AUTOMATIC_0", new Object[0]));
                        this.m_actionCombo.addItem((Object)Action.container_page_copy);
                        this.m_actionCombo.setItemCaption((Object)Action.container_page_copy, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_CONTAINERPAGE_COPY_0", new Object[0]));
                        this.m_actionCombo.addItem((Object)Action.container_page_reuse);
                        this.m_actionCombo.setItemCaption((Object)Action.container_page_reuse, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_CONTAINERPAGE_REUSE_0", new Object[0]));
                    }
                    if (CmsResourceTypeFolderSubSitemap.isSubSitemap(folder)) {
                        this.m_actionCombo.addItem((Object)Action.sub_sitemap);
                        this.m_actionCombo.setItemCaption((Object)Action.sub_sitemap, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_SUBSITEMAP_0", new Object[0]));
                    }
                    this.m_actionCombo.addItem((Object)Action.copy_sibling_mixed);
                    this.m_actionCombo.setItemCaption((Object)Action.copy_sibling_mixed, CmsVaadinUtils.getMessageText("GUI_COPY_ALL_NO_SIBLINGS_0", new Object[0]));
                    this.m_actionCombo.addItem((Object)Action.copy_all);
                    this.m_actionCombo.setItemCaption((Object)Action.copy_all, CmsVaadinUtils.getMessageText("GUI_COPY_ALL_0", new Object[0]));
                    this.m_actionCombo.addItem((Object)Action.copy_sibling_all);
                    this.m_actionCombo.setItemCaption((Object)Action.copy_sibling_all, CmsVaadinUtils.getMessageText("GUI_COPY_MULTI_CREATE_SIBLINGS_0", new Object[0]));
                    if (this.m_dialogMode == DialogMode.copy_and_move) {
                        this.m_actionCombo.addItem((Object)Action.move);
                        this.m_actionCombo.setItemCaption((Object)Action.move, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_MOVE_FOLDER_0", new Object[0]));
                    }
                }
            } else {
                this.m_actionCombo.addItem((Object)Action.copy_sibling_mixed);
                this.m_actionCombo.setItemCaption((Object)Action.copy_sibling_mixed, CmsVaadinUtils.getMessageText("GUI_COPY_ALL_NO_SIBLINGS_0", new Object[0]));
                this.m_actionCombo.addItem((Object)Action.copy_all);
                this.m_actionCombo.setItemCaption((Object)Action.copy_all, CmsVaadinUtils.getMessageText("GUI_COPY_ALL_0", new Object[0]));
                this.m_actionCombo.addItem((Object)Action.copy_sibling_all);
                this.m_actionCombo.setItemCaption((Object)Action.copy_sibling_all, CmsVaadinUtils.getMessageText("GUI_COPY_MULTI_CREATE_SIBLINGS_0", new Object[0]));
                if (this.m_dialogMode == DialogMode.copy_and_move) {
                    this.m_actionCombo.addItem((Object)Action.move);
                    this.m_actionCombo.setItemCaption((Object)Action.move, CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_MOVE_RESOURCES_0", new Object[0]));
                }
            }
            this.m_actionCombo.setItemStyleGenerator(new ComboBox.ItemStyleGenerator(){
                private static final long serialVersionUID = 1L;

                public String getStyle(ComboBox source, Object itemId) {
                    String style = null;
                    if (CmsCopyMoveDialog.this.m_defaultActions.contains(itemId)) {
                        style = "bold";
                    }
                    return style;
                }
            });
            form.addComponent((Component)this.m_actionCombo);
            this.m_actionCombo.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateOverwriteExisting());
        }
        if (this.m_context.getResources().size() > 1) {
            this.m_overwriteExisting = new CheckBox(CmsVaadinUtils.getMessageText("GUI_COPY_MULTI_OVERWRITE_0", new Object[0]));
            this.m_overwriteExisting.setValue((Object)Boolean.FALSE);
            form.addComponent((Component)this.m_overwriteExisting);
            this.updateOverwriteExisting();
        }
        return form;
    }

    private boolean isOverwriteExisting() {
        return this.m_overwriteExisting != null && (Boolean)this.m_overwriteExisting.getValue() != false;
    }

    private void showConfirmOverwrite(List<CmsResource> collidingResources) {
        final Window window = CmsBasicDialog.prepareWindow();
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_CONFIRM_OVERWRITE_TITLE_0", new Object[0]));
        CmsConfirmationDialog dialog = new CmsConfirmationDialog(CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_CONFIRM_OVERWRITE_MESSAGE_0", new Object[0]), new Runnable(){

            @Override
            public void run() {
                window.close();
                CmsCopyMoveDialog.this.submit(true, null);
            }
        }, new Runnable(){

            @Override
            public void run() {
                window.close();
                CmsCopyMoveDialog.this.cancel();
            }
        });
        dialog.displayResourceInfo(collidingResources);
        window.setContent((Component)dialog);
        UI.getCurrent().addWindow(window);
    }

    private void showMacroResolverDialog(CmsResource resource) {
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_COPY_MOVE_SET_MACRO_VALUES_TITLE_0", new Object[0]));
        this.m_macroDialog = new CmsMacroResolverDialog(new Runnable(){

            @Override
            public void run() {
                Map<String, String> map = CmsCopyMoveDialog.this.getMacroMap();
                window.close();
                CmsCopyMoveDialog.this.submit(true, map);
            }
        }, new Runnable(){

            @Override
            public void run() {
                window.close();
                CmsCopyMoveDialog.this.cancel();
            }
        }, resource);
        this.m_macroDialog.displayResourceInfo(Collections.singletonList(resource));
        window.setContent((Component)this.m_macroDialog);
        UI.getCurrent().addWindow(window);
    }

    private void updateDefaultActions(String targetRootPath) {
        if (this.m_actionCombo != null) {
            this.m_defaultActions.clear();
            String resPath = this.m_context.getResources().get(0).getRootPath();
            String parentFolder = CmsResource.getParentFolder(resPath);
            if (DialogMode.copy_and_move == this.m_dialogMode && !parentFolder.equals(targetRootPath)) {
                this.m_defaultActions.clear();
                this.m_defaultActions.add(Action.move);
            } else if (this.m_context.getResources().size() == 1) {
                if (this.m_context.getResources().get(0).isFile()) {
                    this.m_defaultActions.add(Action.copy_all);
                } else {
                    CmsResource folder;
                    this.m_defaultActions.add(Action.copy_sibling_mixed);
                    if (this.m_hasContainerPageDefaultFile) {
                        this.m_defaultActions.clear();
                        this.m_defaultActions.add(Action.container_page_automatic);
                        this.m_defaultActions.add(Action.container_page_copy);
                        this.m_defaultActions.add(Action.container_page_reuse);
                    }
                    if (CmsResourceTypeFolderSubSitemap.isSubSitemap(folder = this.m_context.getResources().get(0))) {
                        this.m_defaultActions.clear();
                        this.m_defaultActions.add(Action.sub_sitemap);
                    }
                }
            } else {
                this.m_defaultActions.add(Action.copy_sibling_mixed);
            }
            if (!this.m_defaultActions.isEmpty()) {
                this.m_actionCombo.setValue((Object)this.m_defaultActions.get(0));
            }
            this.m_actionCombo.markAsDirty();
        }
    }

    public static enum DialogMode {
        copy,
        copy_and_move,
        move;

    }

    public static enum Action {
        container_page_automatic,
        container_page_copy,
        container_page_reuse,
        copy_all,
        copy_sibling_all,
        copy_sibling_mixed,
        move,
        sub_sitemap;

    }
}

