/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsUUID;

public class CmsUndeleteDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsUndeleteDialog.class);
    private static final long serialVersionUID = 1L;
    protected I_CmsDialogContext m_context;
    private Button m_cancelButton;
    private Button m_okButton;

    public CmsUndeleteDialog(I_CmsDialogContext context) {
        this.m_context = context;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUndeleteDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUndeleteDialog.this.submit();
            }
        });
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsUndeleteDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsUndeleteDialog.this.submit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CmsUUID> undelete() throws CmsException {
        ArrayList<CmsUUID> modifiedResources = new ArrayList<CmsUUID>();
        CmsObject cms = this.m_context.getCms();
        for (CmsResource resource : this.m_context.getResources()) {
            CmsLockActionRecord actionRecord = null;
            try {
                actionRecord = CmsLockUtil.ensureLock(this.m_context.getCms(), resource);
                cms.undeleteResource(cms.getSitePath(resource), true);
                modifiedResources.add(resource.getStructureId());
            }
            finally {
                if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) continue;
                try {
                    cms.unlockResource(resource);
                }
                catch (CmsLockException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return modifiedResources;
    }

    void cancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }

    void submit() {
        try {
            List<CmsUUID> modifiedResources = this.undelete();
            this.m_context.finish(modifiedResources);
        }
        catch (Exception e) {
            this.m_context.error(e);
        }
    }
}

