/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.history;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.v7.ui.CheckBox;
import java.util.Date;
import org.opencms.file.CmsObject;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.gwt.shared.CmsHistoryVersion;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.util.table.CmsTableUtil;
import org.opencms.ui.util.table.Column;

public class CmsHistoryRow {
    private CmsHistoryResourceBean m_bean;
    private CheckBox m_checkbox1 = new CheckBox();
    private CheckBox m_checkbox2 = new CheckBox();
    private Button m_previewButton = CmsTableUtil.createIconButton((Resource)FontAwesome.SEARCH, CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_BUTTON_PREVIEW_0", new Object[0]));
    private Button m_restoreButton = CmsTableUtil.createIconButton((Resource)FontAwesome.CLOCK_O, CmsVaadinUtils.getMessageText("GUI_HISTORY_DIALOG_BUTTON_RESTORE_0", new Object[0]));

    public CmsHistoryRow(CmsHistoryResourceBean bean) {
        this.m_bean = bean;
    }

    public static String formatVersion(CmsHistoryResourceBean bean) {
        CmsHistoryVersion hVersion = bean.getVersion();
        Integer v = hVersion.getVersionNumber();
        String result = v != null ? v.toString() : "-";
        String suffix = "";
        if (hVersion.isOnline()) {
            suffix = " (Online)";
        } else if (hVersion.isOffline()) {
            suffix = " (Offline)";
        }
        result = result + suffix;
        return result;
    }

    @Column(header="V1", order=90)
    public CheckBox getCheckBoxV1() {
        return this.m_checkbox1;
    }

    @Column(header="V2", order=100)
    public CheckBox getCheckBoxV2() {
        return this.m_checkbox2;
    }

    @Column(header="GUI_HISTORY_DIALOG_COL_DATE_LASTMODIFIED_0", order=60)
    public Date getModificationDate() {
        return new Date(this.m_bean.getModificationDate().getDate());
    }

    @Column(header="GUI_HISTORY_DIALOG_COL_PATH_0", order=40, expandRatio=1.0f, view="wide")
    public String getPath() {
        String rootPath = this.m_bean.getRootPath();
        CmsObject cms = A_CmsUI.getCmsObject();
        String result = cms.getRequestContext().removeSiteRoot(rootPath);
        return result;
    }

    @Column(header="GUI_HISTORY_DIALOG_BUTTON_PREVIEW_0", order=7)
    public Button getPreviewButton() {
        return this.m_previewButton;
    }

    @Column(header="GUI_HISTORY_DIALOG_COL_DATE_PUBLISHED_0", order=50)
    public Date getPublishDate() {
        if (this.m_bean.getPublishDate() == null) {
            return null;
        }
        return new Date(this.m_bean.getPublishDate().getDate());
    }

    @Column(header="GUI_HISTORY_DIALOG_BUTTON_RESTORE_0", order=6)
    public Button getRestoreButton() {
        if (this.m_bean.getVersion().getVersionNumber() == null) {
            return null;
        }
        return this.m_restoreButton;
    }

    @Column(header="GUI_LABEL_SIZE_0", order=80)
    public Integer getSize() {
        return this.m_bean.getSize();
    }

    @Column(header="GUI_LABEL_USER_LAST_MODIFIED_0", order=70)
    public String getUserLastModified() {
        return this.m_bean.getUserLastModified();
    }

    @Column(header="GUI_LABEL_VERSION_0", order=30)
    public String getVersion() {
        return CmsHistoryRow.formatVersion(this.m_bean);
    }
}

