/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.data.HasValue;
import com.vaadin.server.UserError;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.CmsUserLog;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsPasswordSecurityEvaluator;
import org.opencms.security.twofactor.CmsSecondFactorInfo;
import org.opencms.security.twofactor.CmsTwoFactorAuthenticationHandler;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.login.CmsLoginUI;
import org.opencms.ui.login.CmsPasswordForm;
import org.opencms.ui.login.CmsSecondFactorDialog;
import org.opencms.util.CmsStringUtil;

public class CmsChangePasswordDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsChangePasswordDialog.class);
    private static final long serialVersionUID = 1L;
    protected CmsPasswordForm m_form;
    CmsObject m_cms;
    Locale m_locale;
    CmsUser m_user;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private Button m_passwordChangeButton;

    public CmsChangePasswordDialog(CmsObject cms, CmsUser user, Locale locale) {
        this.m_locale = locale;
        this.m_cms = cms;
        this.m_user = user;
        if (this.m_user.isManaged()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_USER_NOT_SELF_MANAGED_1", this.m_user.getName()));
        }
        this.m_form = new CmsPasswordForm(this.m_locale);
        this.setContent((Component)this.m_form);
        if (OpenCms.getPasswordHandler() instanceof I_CmsPasswordSecurityEvaluator) {
            this.m_form.setSecurityHint(((I_CmsPasswordSecurityEvaluator)((Object)OpenCms.getPasswordHandler())).getPasswordSecurityHint(this.m_locale));
        }
        this.m_passwordChangeButton = new Button(CmsVaadinUtils.getMessageText("GUI_CHANGE_PASSWORD_BUTTON_0", new Object[0]));
        this.addButton((Component)this.m_passwordChangeButton);
        this.m_passwordChangeButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsChangePasswordDialog.this.submit();
            }
        });
        this.m_cancelButton = new Button(CmsVaadinUtils.messageCancel());
        this.addButton((Component)this.m_cancelButton);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsChangePasswordDialog.this.close();
            }
        });
        this.m_cancelButton.setVisible(false);
        this.m_form.getOldPasswordField().setImmediate(true);
        this.m_form.getOldPasswordField().addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsChangePasswordDialog.this.clearOldPasswordError();
            }
        });
        this.m_form.getPassword1Field().addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.checkSecurity((String)event.getValue()));
        this.m_form.getPassword2Field().addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.checkPasswordMatch((String)event.getValue()));
    }

    public CmsChangePasswordDialog(I_CmsDialogContext context) {
        this(context.getCms(), context.getCms().getRequestContext().getCurrentUser(), UI.getCurrent().getLocale());
        this.m_context = context;
        this.m_cancelButton.setVisible(true);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsChangePasswordDialog.this.close();
            }

            @Override
            protected void ok() {
                CmsChangePasswordDialog.this.submit();
            }
        });
    }

    public void setAdditionalMessage(String text) {
        this.m_form.setAdditionalText(text);
    }

    protected void maybeCheckSecondFactor(Consumer<CmsSecondFactorInfo> handler) {
        boolean needToCheck;
        CmsTwoFactorAuthenticationHandler twoFactorHandler = OpenCms.getTwoFactorAuthenticationHandler();
        boolean bl = needToCheck = twoFactorHandler.needsTwoFactorAuthentication(this.m_user) && twoFactorHandler.hasSecondFactor(this.m_user);
        if (!needToCheck) {
            handler.accept(null);
        } else {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.narrow);
            window.setModal(true);
            window.setResizable(false);
            window.setCaption(CmsSecondFactorDialog.getCaption(this.m_user));
            CmsSecondFactorDialog dialog = new CmsSecondFactorDialog(this.m_user, code -> {
                CmsSecondFactorInfo info = new CmsSecondFactorInfo((String)code);
                handler.accept(info);
            });
            A_CmsUI.get().addWindow(window);
            window.setContent((Component)dialog);
        }
    }

    void checkPasswordMatch(String password2) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(password2)) {
            this.showPasswordMatchError(!password2.equals(this.m_form.getPassword1()));
        }
    }

    void checkSecurity(String password) {
        I_CmsPasswordHandler handler = OpenCms.getPasswordHandler();
        try {
            handler.validatePassword(password);
            if (handler instanceof I_CmsPasswordSecurityEvaluator) {
                I_CmsPasswordSecurityEvaluator.SecurityLevel level = ((I_CmsPasswordSecurityEvaluator)((Object)handler)).evaluatePasswordSecurity(password);
                this.m_form.setErrorPassword1(null, "o-security-" + level.name());
            } else {
                this.m_form.setErrorPassword1(null, "o-security-strong");
            }
        }
        catch (CmsSecurityException e) {
            this.m_form.setErrorPassword1(new UserError(e.getLocalizedMessage(this.m_locale)), "o-security-invalid");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_form.getPassword2())) {
            this.showPasswordMatchError(!password.equals(this.m_form.getPassword2()));
        }
    }

    void clearOldPasswordError() {
        this.m_form.setErrorOldPassword(null, null);
    }

    void close() {
        if (this.m_context != null) {
            this.m_context.finish(Collections.emptyList());
        }
    }

    void showPasswordMatchError(boolean show) {
        if (show) {
            this.m_form.setErrorPassword2(new UserError(Messages.get().getBundle(this.m_locale).key("GUI_PWCHANGE_PASSWORD_MISMATCH_0")), "o-security-invalid");
        } else {
            this.m_form.setErrorPassword2(null, "o-security-strong");
        }
    }

    void submit() {
        String password2;
        String password1 = this.m_form.getPassword1();
        if (this.validatePasswords(password1, password2 = this.m_form.getPassword2())) {
            String oldPassword = this.m_form.getOldPassword();
            if (oldPassword.equals(password1)) {
                this.m_form.setErrorPassword1(new UserError(Messages.get().getBundle(this.m_locale).key("GUI_PWCHANGE_DIFFERENT_PASSWORD_REQUIRED_0")), "o-security-invalid");
            } else {
                this.maybeCheckSecondFactor(secondFactor -> {
                    try {
                        this.m_cms.setPassword(this.m_user.getName(), oldPassword, (CmsSecondFactorInfo)secondFactor, password1);
                        CmsUserLog.logPasswordChangeForRequestedReset(A_CmsUI.getCmsObject(), this.m_user.getName());
                        this.closeOrRedirectToLoginForm();
                    }
                    catch (CmsException e) {
                        this.m_form.setErrorOldPassword(new UserError(e.getLocalizedMessage(this.m_locale)), "o-security-invalid");
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                });
            }
        }
    }

    boolean validatePasswords(String password1, String password2) {
        if (!password1.equals(password2)) {
            this.showPasswordMatchError(true);
            return false;
        }
        this.showPasswordMatchError(false);
        try {
            OpenCms.getPasswordHandler().validatePassword(password1);
            this.m_form.getPassword1Field().setComponentError(null);
            return true;
        }
        catch (CmsException e) {
            this.m_form.setErrorPassword1(new UserError(e.getLocalizedMessage(this.m_locale)), "o-security-invalid");
            return false;
        }
    }

    private void closeOrRedirectToLoginForm() {
        if (this.m_context != null) {
            this.close();
        } else {
            CmsVaadinUtils.showAlert(Messages.get().getBundle(this.m_locale).key("GUI_PWCHANGE_SUCCESS_HEADER_0"), Messages.get().getBundle(this.m_locale).key("GUI_PWCHANGE_GUI_PWCHANGE_SUCCESS_CONTENT_0"), new Runnable(){

                @Override
                public void run() {
                    A_CmsUI.get().getPage().setLocation(OpenCms.getLinkManager().substituteLinkForUnknownTarget(CmsLoginUI.m_adminCms, "/system/login?ocUname=" + CmsChangePasswordDialog.this.m_user.getSimpleName() + "&ocOuFqn=" + CmsChangePasswordDialog.this.m_user.getOuFqn(), false));
                }
            });
        }
    }
}

