/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import java.util.List;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsFileUtil;

public class CmsLoginOuSelector
extends CustomComponent {
    private static final long serialVersionUID = 1L;
    public static final String OU_NONE = "OU_NONE";
    private ComboBox m_ouSelect = new ComboBox();
    private boolean m_alwaysHidden;

    public CmsLoginOuSelector() {
        this.m_ouSelect.setWidth("100%");
        this.setCompositionRoot((Component)this.m_ouSelect);
        this.m_ouSelect.setFilteringMode(FilteringMode.CONTAINS);
        this.m_ouSelect.setNullSelectionAllowed(false);
    }

    public String getValue() {
        return (String)this.m_ouSelect.getValue();
    }

    public boolean hasOrgUnit(String ou) {
        return this.m_ouSelect.getContainerDataSource().getItem((Object)this.normalizeOuName(ou)) != null;
    }

    public void initOrgUnits(List<CmsOrganizationalUnit> orgUnits, boolean addEmptyOption) {
        if (orgUnits.size() == 1 && orgUnits.get(0).getParentFqn() == null) {
            this.setVisible(false);
            this.m_alwaysHidden = true;
        }
        if (addEmptyOption) {
            this.m_ouSelect.addItem((Object)OU_NONE);
            this.m_ouSelect.setItemCaption((Object)OU_NONE, CmsVaadinUtils.getMessageText("GUI_LOGIN_NO_OU_SELECTED_0", new Object[0]));
        }
        for (CmsOrganizationalUnit ou : orgUnits) {
            String key = this.normalizeOuName(ou.getName());
            this.m_ouSelect.addItem((Object)key);
            this.m_ouSelect.setItemCaption((Object)key, ou.getDisplayName(A_CmsUI.get().getLocale()));
        }
    }

    public boolean isAlwaysHidden() {
        return this.m_alwaysHidden;
    }

    public void setValue(String value) {
        this.m_ouSelect.setValue((Object)this.normalizeOuName(value));
    }

    String normalizeOuName(String ou) {
        ou = CmsFileUtil.removeLeadingSeparator(ou);
        ou = CmsFileUtil.removeTrailingSeparator(ou);
        return ou;
    }
}

