/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.notification.A_CmsNotification;

public class CmsPasswordChangeNotification
extends A_CmsNotification {
    private String m_link;

    public CmsPasswordChangeNotification(CmsObject cms, CmsUser receiver, String link, String expiration) {
        super(cms, receiver);
        this.m_link = CmsEncoder.escapeXml(link);
        this.addMacro("user", receiver.getName());
        this.addMacro("expiration", expiration);
    }

    @Override
    protected String generateHtmlMsg() {
        return "<a href=\"" + this.m_link + "\">" + this.m_link + "</a>";
    }

    @Override
    protected String getNotificationContent() {
        return OpenCms.getSystemInfo().getConfigFilePath(this.m_cms, "notification/password-change-notification");
    }
}

