/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.PasswordField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Locale;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsNewPasswordField;
import org.opencms.ui.util.CmsStyleVariable;
import org.opencms.util.CmsStringUtil;

public class CmsPasswordForm
extends VerticalLayout {
    private static final long serialVersionUID = 773244283339376105L;
    private Label m_additionalText;
    private Label m_headMessage;
    private PasswordField m_oldPasswordField;
    private CmsStyleVariable m_oldPasswordStyle;
    private CssLayout m_oldPasswordWrapper;
    private CmsStyleVariable m_password1Style;
    private CssLayout m_password1Wrapper;
    private CmsStyleVariable m_password2Style;
    private CssLayout m_password2Wrapper;
    private CmsNewPasswordField m_passwordField1;
    private CmsNewPasswordField m_passwordField2;
    private Label m_securityHint;

    public CmsPasswordForm() {
        this(A_CmsUI.get().getLocale());
    }

    public CmsPasswordForm(Locale locale) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(locale), null);
        this.m_securityHint.setVisible(false);
        this.m_password1Style = new CmsStyleVariable((Component)this.m_password1Wrapper);
        this.m_password2Style = new CmsStyleVariable((Component)this.m_password2Wrapper);
        this.m_oldPasswordStyle = new CmsStyleVariable((Component)this.m_oldPasswordWrapper);
    }

    public String getOldPassword() {
        return (String)this.m_oldPasswordField.getValue();
    }

    public PasswordField getOldPasswordField() {
        return this.m_oldPasswordField;
    }

    public String getPassword1() {
        return this.m_passwordField1.getValue();
    }

    public CmsNewPasswordField getPassword1Field() {
        return this.m_passwordField1;
    }

    public String getPassword2() {
        return this.m_passwordField2.getValue();
    }

    public CmsNewPasswordField getPassword2Field() {
        return this.m_passwordField2;
    }

    public void hideOldPassword() {
        this.m_oldPasswordWrapper.setVisible(false);
    }

    public void setAdditionalText(String text) {
        if (CmsStringUtil.isEmpty(text)) {
            this.m_additionalText.setVisible(false);
        } else {
            this.m_additionalText.setValue(text);
            this.m_additionalText.setVisible(true);
        }
    }

    public void setEnabled(boolean enabled) {
        this.m_passwordField1.setEnabled(enabled);
        this.m_passwordField2.setEnabled(enabled);
        this.m_oldPasswordField.setEnabled(enabled);
    }

    public void setErrorOldPassword(UserError error, String style) {
        this.m_oldPasswordField.setComponentError((ErrorMessage)error);
        this.m_oldPasswordStyle.setStyle(style);
    }

    public void setErrorPassword1(UserError error, String style) {
        this.m_passwordField1.setComponentError((ErrorMessage)error);
        this.m_password1Style.setStyle(style);
    }

    public void setErrorPassword2(UserError error, String style) {
        this.m_passwordField2.setComponentError((ErrorMessage)error);
        this.m_password2Style.setStyle(style);
    }

    public void setHeaderVisible(boolean visible) {
        this.m_headMessage.setVisible(false);
    }

    public void setSecurityHint(String hint) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(hint)) {
            this.m_securityHint.setValue(hint);
            this.m_securityHint.setVisible(true);
        } else {
            this.m_securityHint.setVisible(false);
        }
    }
}

