/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.opencms.util.CmsUUID;

public final class CmsDataTypeUtil {
    private CmsDataTypeUtil() {
    }

    public static Object dataDeserialize(byte[] data, String type) throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(type);
        if (CmsDataTypeUtil.isParseable(clazz)) {
            return CmsDataTypeUtil.parse(new String(data), clazz);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        ObjectInputStream oin = new ObjectInputStream(bin);
        return oin.readObject();
    }

    public static String dataExport(Object data) throws IOException {
        if (CmsDataTypeUtil.isParseable(data.getClass())) {
            return CmsDataTypeUtil.format(data);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(data);
        oout.close();
        return new String(Base64.encodeBase64((byte[])bout.toByteArray()));
    }

    public static Object dataImport(String value, String type) throws ClassNotFoundException, IOException {
        Class<?> clazz = Class.forName(type);
        if (CmsDataTypeUtil.isParseable(clazz)) {
            return CmsDataTypeUtil.parse(value, clazz);
        }
        byte[] data = Base64.decodeBase64((byte[])value.getBytes());
        return CmsDataTypeUtil.dataDeserialize(data, type);
    }

    public static byte[] dataSerialize(Object data) throws IOException {
        if (CmsDataTypeUtil.isParseable(data.getClass())) {
            return CmsDataTypeUtil.format(data).getBytes();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        Hashtable obj = data;
        if (data instanceof Map) {
            Hashtable ht = new Hashtable();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                ht.put(entry.getKey(), entry.getValue());
            }
            obj = ht;
        }
        oout.writeObject(obj);
        oout.close();
        return bout.toByteArray();
    }

    public static String format(boolean data) {
        return String.valueOf(data);
    }

    public static String format(byte data) {
        return Byte.valueOf(data).toString();
    }

    public static String format(char data) {
        return Character.valueOf(data).toString();
    }

    public static String format(Date data) {
        return Long.valueOf(data.getTime()).toString();
    }

    public static String format(double data) {
        return Double.valueOf(data).toString();
    }

    public static String format(float data) {
        return Float.valueOf(data).toString();
    }

    public static String format(int data) {
        return Integer.valueOf(data).toString();
    }

    public static String format(long data) {
        return Long.valueOf(data).toString();
    }

    public static String format(Object data) {
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        if (clazz.equals(Date.class)) {
            return CmsDataTypeUtil.format(((Date)data).getTime());
        }
        return data.toString();
    }

    public static String format(short data) {
        return Short.valueOf(data).toString();
    }

    public static boolean isParseable(Class<?> clazz) {
        boolean parseable = false;
        parseable = parseable || clazz.equals(Byte.TYPE);
        parseable = parseable || clazz.equals(Byte.class);
        parseable = parseable || clazz.equals(Short.TYPE);
        parseable = parseable || clazz.equals(Short.class);
        parseable = parseable || clazz.equals(Integer.TYPE);
        parseable = parseable || clazz.equals(Integer.class);
        parseable = parseable || clazz.equals(Long.TYPE);
        parseable = parseable || clazz.equals(Long.class);
        parseable = parseable || clazz.equals(Float.TYPE);
        parseable = parseable || clazz.equals(Float.class);
        parseable = parseable || clazz.equals(Double.TYPE);
        parseable = parseable || clazz.equals(Double.class);
        parseable = parseable || clazz.equals(Boolean.TYPE);
        parseable = parseable || clazz.equals(Boolean.class);
        parseable = parseable || clazz.equals(Character.TYPE);
        parseable = parseable || clazz.equals(Character.class);
        parseable = parseable || clazz.equals(String.class);
        parseable = parseable || clazz.equals(Date.class);
        parseable = parseable || clazz.equals(CmsUUID.class);
        return parseable;
    }

    public static int numberToInt(Number n) {
        return n == null ? 0 : n.intValue();
    }

    public static Object parse(String data, Class<?> clazz) {
        if (data == null) {
            return null;
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return CmsDataTypeUtil.parseByte(data);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return CmsDataTypeUtil.parseShort(data);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return CmsDataTypeUtil.parseLong(data);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return CmsDataTypeUtil.parseInt(data);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return CmsDataTypeUtil.parseFloat(data);
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return CmsDataTypeUtil.parseDouble(data);
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return CmsDataTypeUtil.parseBoolean(data);
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
            return CmsDataTypeUtil.parseChar(data);
        }
        if (clazz.equals(CmsUUID.class)) {
            return CmsDataTypeUtil.parseUUID(data);
        }
        if (clazz.equals(Date.class)) {
            return CmsDataTypeUtil.parseDate(data);
        }
        return data;
    }

    public static Boolean parseBoolean(String data) {
        return Boolean.valueOf(data);
    }

    public static Byte parseByte(String data) {
        return Byte.valueOf(data);
    }

    public static Character parseChar(String data) {
        return Character.valueOf(data.charAt(0));
    }

    public static Date parseDate(String data) {
        return new Date(CmsDataTypeUtil.parseLong(data));
    }

    public static Double parseDouble(String data) {
        return Double.valueOf(data);
    }

    public static Float parseFloat(String data) {
        return Float.valueOf(data);
    }

    public static Integer parseInt(String data) {
        return Integer.valueOf(data);
    }

    public static Long parseLong(String data) {
        return Long.valueOf(data);
    }

    public static Short parseShort(String data) {
        return Short.valueOf(data);
    }

    public static CmsUUID parseUUID(String data) {
        return new CmsUUID(data);
    }
}

