/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CmsDefaultSet<T>
implements IsSerializable {
    private boolean m_defaultMembership;
    private HashMap<T, Boolean> m_membershipMap = new HashMap();
    private boolean m_frozen;

    public void checkNotFrozen() {
        if (this.m_frozen) {
            throw new IllegalStateException("Can't modify frozen default set.");
        }
    }

    public boolean contains(T value) {
        Boolean isMember = this.m_membershipMap.get(value);
        if (isMember != null) {
            return isMember;
        }
        return this.m_defaultMembership;
    }

    public void freeze() {
        this.m_frozen = true;
    }

    public Map<T, Boolean> getBaseMap() {
        return Collections.unmodifiableMap(this.m_membershipMap);
    }

    public boolean getDefaultMembership() {
        return this.m_defaultMembership;
    }

    public void setContains(T value, boolean isMember) {
        this.checkNotFrozen();
        this.m_membershipMap.put(value, isMember);
    }

    public void setDefaultMembership(boolean defaultMembership) {
        this.checkNotFrozen();
        this.m_defaultMembership = defaultMembership;
    }
}

