/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.util.CmsStringUtil;

public final class CmsGeoUtil {
    public static String parseCoordinates(String coordinates) {
        if (coordinates == null) {
            return null;
        }
        String locationPickerCoordinates = CmsGeoUtil.parseLocationPickerCoordinates(coordinates);
        if (locationPickerCoordinates != null) {
            return locationPickerCoordinates;
        }
        if (CmsGeoUtil.validateCoordinates(coordinates)) {
            return coordinates;
        }
        return null;
    }

    public static String parseLocationPickerCoordinates(String jsonValue) {
        try {
            JSONObject json = new JSONObject(jsonValue);
            if (!CmsGeoUtil.validateLocationPickerCoordinates(json)) {
                return null;
            }
            return json.getString("lat") + "," + json.getString("lng");
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static boolean validateCoordinates(String coordinates) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(coordinates)) {
            return false;
        }
        if (!coordinates.contains(",")) {
            return false;
        }
        String[] tokens = coordinates.split(",");
        String latitude = tokens[0];
        String longitude = tokens[1];
        return CmsGeoUtil.validateLatitude(latitude) && CmsGeoUtil.validateLongitude(longitude);
    }

    public static boolean validateLatitude(String latitude) {
        try {
            double value = Double.parseDouble(latitude);
            return value <= 90.0 && value >= -90.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validateLocationPickerCoordinates(JSONObject jsonObject) {
        try {
            String latitude = jsonObject.getString("lat");
            String longitude = jsonObject.getString("lng");
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(latitude) || CmsStringUtil.isEmptyOrWhitespaceOnly(longitude)) {
                return false;
            }
            return CmsGeoUtil.validateLatitude(latitude) && CmsGeoUtil.validateLongitude(longitude);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static boolean validateLongitude(String longitude) {
        try {
            double value = Double.parseDouble(longitude);
            return value <= 180.0 && value >= -180.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validateRadius(String radius) {
        try {
            double value = Double.parseDouble(radius);
            return value >= 0.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validateUnits(String units) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(units)) {
            return false;
        }
        return units.equals("km") || units.equals("mi");
    }
}

