/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.function.Function;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;

public class CmsJsonUtil {
    public static Object mapJson(Object obj, Function<Object, Object> func) throws JSONException {
        if (obj instanceof JSONObject) {
            return CmsJsonUtil.mapJsonObject((JSONObject)obj, func);
        }
        if (obj instanceof JSONArray) {
            return CmsJsonUtil.mapJsonArray((JSONArray)obj, func);
        }
        return func.apply(obj);
    }

    public static JSONObject mapJsonObject(JSONObject obj, Function<Object, Object> func) throws JSONException {
        JSONObject result = new JSONObject();
        for (String key : obj.keySet()) {
            Object val = obj.opt(key);
            Object val2 = CmsJsonUtil.mapJson(val, func);
            result.put(key, val2);
        }
        return result;
    }

    private static JSONArray mapJsonArray(JSONArray array, Function<Object, Object> func) throws JSONException {
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.length(); ++i) {
            result.put(CmsJsonUtil.mapJson(array.get(i), func));
        }
        return result;
    }
}

