/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsResourceTranslator;
import org.opencms.util.CmsUUID;
import org.opencms.util.I_CmsRegexSubstitution;
import org.opencms.util.Messages;
import org.opencms.util.PrintfFormat;

public final class CmsStringUtil {
    public static final String BODY_END_REGEX = "<\\s*/\\s*body[^>]*>";
    public static final String BODY_START_REGEX = "<\\s*body[^>]*>";
    public static final String FALSE = Boolean.toString(false);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String MACRO_OPENCMS_CONTEXT = "${OpenCmsContext}";
    public static final Pattern PATTERN_LOCALE_SUFFIX = Pattern.compile("(.*)_([a-z]{2}(?:_[A-Z]{2})?)(?:\\.[^\\.]*)?$");
    public static final Pattern PATTERN_NUMBER_SUFFIX = Pattern.compile("(.*)_(\\d+)(\\.[^\\.^\\n]*)?$");
    public static final Pattern PATTERN_SLASHES = Pattern.compile("/+");
    public static final String PLACEHOLDER_END = "}";
    public static final String PLACEHOLDER_START = "{";
    public static final char[] SENTENCE_ENDING_CHARS = new char[]{'.', '!', '?'};
    public static final String TABULATOR = "  ";
    public static final String TRUE = Boolean.toString(true);
    private static final Pattern BODY_END_PATTERN = Pattern.compile("<\\s*/\\s*body[^>]*>", 2);
    private static final Pattern BODY_START_PATTERN = Pattern.compile("<\\s*body[^>]*>", 2);
    private static final long DAYS = 86400000L;
    private static final long[] DURATION_MULTIPLIERS = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};
    private static final Pattern DURATION_NUMBER_AND_UNIT_PATTERN = Pattern.compile("([0-9]+)([a-z]+)");
    private static final String[] DURATION_UNTIS = new String[]{"d", "h", "m", "s", "ms"};
    private static final long HOURS = 3600000L;
    private static final Log LOG = CmsLog.getLog(CmsStringUtil.class);
    private static String m_contextReplace;
    private static String m_contextSearch;
    private static final long MINUTES = 60000L;
    private static final long SECONDS = 1000L;
    private static final Pattern XML_ENCODING_REGEX;
    private static final Pattern XML_HEAD_REGEX;
    private static final Pattern NOT_SLASHES;

    private CmsStringUtil() {
    }

    public static String addLeadingAndTrailingSlash(String path) {
        StringBuffer buffer1 = new StringBuffer();
        if (!path.startsWith("/")) {
            buffer1.append("/");
        }
        buffer1.append(path);
        if (!path.endsWith("/") && !path.isEmpty()) {
            buffer1.append("/");
        }
        return buffer1.toString();
    }

    public static String arrayAsString(String[] arg, String separator) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < arg.length; ++i) {
            result.append(arg[i]);
            if (i + 1 >= arg.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String changeFileNameSuffixTo(String filename, String suffix) {
        int dotPos = filename.lastIndexOf(46);
        if (dotPos != -1) {
            return filename.substring(0, dotPos + 1) + suffix;
        }
        return filename;
    }

    public static void checkName(String name, String constraints, String key, I_CmsMessageBundle bundle) throws CmsIllegalArgumentException {
        int l = name.length();
        for (int i = 0; i < l; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || constraints.indexOf(c) >= 0) continue;
            throw new CmsIllegalArgumentException(bundle.container(key, new Object[]{name, Character.valueOf(c), i, constraints}));
        }
    }

    public static String collectionAsString(Collection<?> collection, String separator) {
        StringBuffer string = new StringBuffer(128);
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            string.append(it.next());
            if (!it.hasNext()) continue;
            string.append(separator);
        }
        return string.toString();
    }

    public static boolean comparePaths(String path1, String path2) {
        return CmsStringUtil.addLeadingAndTrailingSlash(path1).equals(CmsStringUtil.addLeadingAndTrailingSlash(path2));
    }

    public static int countChar(String s, char c) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++counter;
        }
        return counter;
    }

    public static <T extends Enum<T>> String[] enumNameToStringArray(T[] values) {
        int i = 0;
        String[] result = new String[values.length];
        for (T value : values) {
            result[i++] = ((Enum)value).name();
        }
        return result;
    }

    public static String escapeHtml(String source) {
        if (source == null) {
            return null;
        }
        source = CmsEncoder.escapeXml(source);
        source = CmsStringUtil.substitute(source, "\r", "");
        source = CmsStringUtil.substitute(source, "\n", "<br/>\n");
        return source;
    }

    public static String escapeJavaScript(String source) {
        source = CmsStringUtil.substitute(source, "\\", "\\\\");
        source = CmsStringUtil.substitute(source, "\"", "\\\"");
        source = CmsStringUtil.substitute(source, "'", "\\'");
        source = CmsStringUtil.substitute(source, "\r\n", "\\n");
        source = CmsStringUtil.substitute(source, "\n", "\\n");
        source = CmsStringUtil.substitute(source, "/", "\\/");
        return source;
    }

    public static String escapePattern(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        block17: for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\\': {
                    result.append("\\\\");
                    continue block17;
                }
                case '/': {
                    result.append("\\/");
                    continue block17;
                }
                case '$': {
                    result.append("\\$");
                    continue block17;
                }
                case '^': {
                    result.append("\\^");
                    continue block17;
                }
                case '.': {
                    result.append("\\.");
                    continue block17;
                }
                case '*': {
                    result.append("\\*");
                    continue block17;
                }
                case '+': {
                    result.append("\\+");
                    continue block17;
                }
                case '|': {
                    result.append("\\|");
                    continue block17;
                }
                case '?': {
                    result.append("\\?");
                    continue block17;
                }
                case '{': {
                    result.append("\\{");
                    continue block17;
                }
                case '}': {
                    result.append("\\}");
                    continue block17;
                }
                case '[': {
                    result.append("\\[");
                    continue block17;
                }
                case ']': {
                    result.append("\\]");
                    continue block17;
                }
                case '(': {
                    result.append("\\(");
                    continue block17;
                }
                case ')': {
                    result.append("\\)");
                    continue block17;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return new String(result);
    }

    public static Map<String, String> extendAttribute(String text, String attribute, String defValue) {
        HashMap<String, String> retValue = new HashMap<String, String>();
        retValue.put("text", text);
        retValue.put("value", "'" + defValue + "'");
        if (text != null && text.toLowerCase().indexOf(attribute.toLowerCase()) >= 0) {
            String quotation = "'";
            int pos1 = text.toLowerCase().indexOf(attribute.toLowerCase());
            int pos2 = text.indexOf(quotation, pos1);
            int test = text.indexOf("\"", pos1);
            if (test > -1 && (pos2 == -1 || test < pos2)) {
                quotation = "\"";
                pos2 = test;
            }
            int pos3 = text.indexOf(quotation, pos2 + 1);
            String newValue = quotation + defValue + text.substring(pos2 + 1, pos3 + 1);
            Object newText = text.substring(0, pos1);
            if (pos3 < text.length()) {
                newText = (String)newText + text.substring(pos3 + 1);
            }
            retValue.put("text", (String)newText);
            retValue.put("value", newValue);
        }
        return retValue;
    }

    public static String extractHtmlBody(String content) {
        Matcher startMatcher = BODY_START_PATTERN.matcher(content);
        Matcher endMatcher = BODY_END_PATTERN.matcher(content);
        int start = 0;
        int end = content.length();
        if (startMatcher.find()) {
            start = startMatcher.end();
        }
        if (endMatcher.find(start)) {
            end = endMatcher.start();
        }
        return content.substring(start, end);
    }

    public static String extractXmlEncoding(String content) {
        int pos1;
        String encoding;
        String charset;
        String xmlHead;
        Matcher encodingMatcher;
        String result = null;
        Matcher xmlHeadMatcher = XML_HEAD_REGEX.matcher(content);
        if (xmlHeadMatcher.find() && (encodingMatcher = XML_ENCODING_REGEX.matcher(xmlHead = xmlHeadMatcher.group())).find() && Charset.isSupported(charset = (encoding = encodingMatcher.group()).substring(pos1 = encoding.indexOf(61) + 2, encoding.length() - 1))) {
            result = charset;
        }
        return result;
    }

    public static String formatResourceName(String name, int maxLength) {
        if (name == null) {
            return null;
        }
        if (name.length() <= maxLength) {
            return name;
        }
        int total = name.length();
        String[] names = CmsStringUtil.splitAsArray(name, "/");
        if (name.endsWith("/")) {
            names[names.length - 1] = names[names.length - 1] + "/";
        }
        for (int i = 1; total > maxLength && i < names.length - 1; ++i) {
            if (i > 1) {
                names[i - 1] = "";
            }
            names[i] = "...";
            total = 0;
            for (int j = 0; j < names.length; ++j) {
                int l;
                total += l + ((l = names[j].length()) > 0 ? 1 : 0);
            }
        }
        if (total > maxLength) {
            names[0] = names.length > 2 ? "" : (names.length > 1 ? "..." : names[0]);
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= 0) continue;
            result.append("/");
            result.append(names[i]);
        }
        return result.toString();
    }

    public static String formatRuntime(long runtime) {
        long seconds = runtime / 1000L % 60L;
        long minutes = runtime / 60000L % 60L;
        long hours = runtime / 3600000L % 24L;
        long days = runtime / 86400000L;
        StringBuffer strBuf = new StringBuffer();
        if (days > 0L) {
            if (days < 10L) {
                strBuf.append('0');
            }
            strBuf.append(days);
            strBuf.append(':');
        }
        if (hours < 10L) {
            strBuf.append('0');
        }
        strBuf.append(hours);
        strBuf.append(':');
        if (minutes < 10L) {
            strBuf.append('0');
        }
        strBuf.append(minutes);
        strBuf.append(':');
        if (seconds < 10L) {
            strBuf.append('0');
        }
        strBuf.append(seconds);
        return strBuf.toString();
    }

    public static Color getColorValue(String value, Color defaultValue, String key) {
        Color result;
        try {
            char pre = ((String)value).charAt(0);
            if (pre != '#') {
                value = "#" + (String)value;
            }
            result = Color.decode((String)value);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_PARSE_COLOR_2", value, key));
            }
            result = defaultValue;
        }
        return result;
    }

    public static String getCommonPrefixPath(String first, String second) {
        List<String> firstComponents = CmsStringUtil.getPathComponents(first);
        List<String> secondComponents = CmsStringUtil.getPathComponents(second);
        int minSize = Math.min(firstComponents.size(), secondComponents.size());
        StringBuffer resultBuffer = new StringBuffer();
        for (int i = 0; i < minSize && firstComponents.get(i).equals(secondComponents.get(i)); ++i) {
            resultBuffer.append("/");
            resultBuffer.append(firstComponents.get(i));
        }
        String result = resultBuffer.toString();
        if (result.length() == 0) {
            result = "/";
        }
        return result;
    }

    public static String getEthernetAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            if (!ip.isLoopbackAddress()) {
                NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                byte[] mac = network.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                }
                return sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return CmsUUID.getDummyEthernetAddress();
    }

    public static int getIntValue(String value, int defaultValue, String key) {
        int result;
        try {
            result = Integer.valueOf(value);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_PARSE_INT_2", value, key));
            }
            result = defaultValue;
        }
        return result;
    }

    public static int getIntValueRounded(String value, int defaultValue, String key) {
        int result;
        try {
            result = Math.round(Float.parseFloat(value));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_PARSE_INT_2", value, key));
            }
            result = defaultValue;
        }
        return result;
    }

    public static Locale getLocaleForName(String name) {
        String suffix = CmsStringUtil.getLocaleSuffixForName(CmsResource.getName(name));
        if (suffix != null) {
            String laguageString = suffix.substring(0, 2);
            return suffix.length() == 5 ? new Locale(laguageString, suffix.substring(3, 5)) : new Locale(laguageString);
        }
        return null;
    }

    public static Locale getLocaleForText(String text) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text)) {
            try {
                Detector detector = DetectorFactory.create();
                detector.append(text);
                String lang = detector.detect();
                Locale loc = new Locale(lang);
                if (OpenCms.getLocaleManager().getAvailableLocales().contains(loc)) {
                    return loc;
                }
            }
            catch (LangDetectException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String getLocaleSuffixForName(String name) {
        Matcher matcher = PATTERN_LOCALE_SUFFIX.matcher(name);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public static long getLongValue(String value, long defaultValue, String key) {
        long result;
        try {
            result = Long.valueOf(value);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_PARSE_INT_2", value, key));
            }
            result = defaultValue;
        }
        return result;
    }

    public static List<String> getPathComponents(String path) {
        List<String> result = CmsStringUtil.splitAsList(path, "/");
        Iterator<String> iter = result.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(token)) continue;
            iter.remove();
        }
        return result;
    }

    public static String getRelativeSubPath(String base, String path) {
        Object result = null;
        base = CmsStringUtil.joinPaths(base, "/");
        if ((path = CmsStringUtil.joinPaths(path, "/")).startsWith(base)) {
            result = path.substring(base.length());
        }
        if (result != null) {
            if (((String)result).endsWith("/")) {
                result = ((String)result).substring(0, ((String)result).length() - 1);
            }
            if (!((String)result).startsWith("/")) {
                result = "/" + (String)result;
            }
        }
        return result;
    }

    public static String indentLines(String text, int numSpaces) {
        return text.replaceAll("(?m)^", StringUtils.repeat((String)" ", (int)numSpaces));
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isEmptyOrWhitespaceOnly(String value) {
        return CmsStringUtil.isEmpty(value) || value.trim().length() == 0;
    }

    public static boolean isEqual(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public static boolean isNotEmpty(String value) {
        return value != null && value.length() != 0;
    }

    public static boolean isNotEmptyOrWhitespaceOnly(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static boolean isPrefixPath(String firstPath, String secondPath) {
        firstPath = CmsStringUtil.joinPaths(firstPath, "/");
        secondPath = CmsStringUtil.joinPaths(secondPath, "/");
        return secondPath.startsWith(firstPath);
    }

    public static boolean isProperPrefixPath(String firstPath, String secondPath) {
        firstPath = CmsStringUtil.joinPaths(firstPath, "/");
        return (secondPath = CmsStringUtil.joinPaths(secondPath, "/")).startsWith(firstPath) && !firstPath.equals(secondPath);
    }

    public static boolean isValidJavaClassName(String className) {
        if (CmsStringUtil.isEmpty(className)) {
            return false;
        }
        int length = className.length();
        boolean nodot = true;
        for (int i = 0; i < length; ++i) {
            char ch = className.charAt(i);
            if (nodot) {
                if (ch == '.') {
                    return false;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    nodot = false;
                    continue;
                }
                return false;
            }
            if (ch == '.') {
                nodot = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                nodot = false;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String joinPaths(List<String> paths) {
        String result = CmsStringUtil.listAsString(paths, "/");
        result = PATTERN_SLASHES.matcher(result).replaceAll("/");
        return result;
    }

    public static String joinPaths(String ... paths) {
        StringBuffer result = new StringBuffer(paths.length * 32);
        boolean noSlash = true;
        for (int i = 0; i < paths.length; ++i) {
            for (int j = 0; j < paths[i].length(); ++j) {
                char c = paths[i].charAt(j);
                if (c != '/') {
                    result.append(c);
                    noSlash = true;
                    continue;
                }
                if (!noSlash) continue;
                result.append('/');
                noSlash = false;
            }
            if (!noSlash || i >= paths.length - 1) continue;
            result.append('/');
            noSlash = false;
        }
        return result.toString();
    }

    public static int lastIndexOf(String source, char[] chars) {
        int result = -1;
        for (int i = 0; i < chars.length; ++i) {
            int pos = source.lastIndexOf(chars[i]);
            if (pos <= result) continue;
            result = pos;
        }
        return result;
    }

    public static int lastWhitespaceIn(String source) {
        if (CmsStringUtil.isEmpty(source)) {
            return -1;
        }
        int pos = -1;
        for (int i = source.length() - 1; i >= 0; --i) {
            if (!Character.isWhitespace(source.charAt(i))) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public static String listAsString(List<?> list, String separator) {
        StringBuffer string = new StringBuffer(128);
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            string.append(it.next());
            if (!it.hasNext()) continue;
            string.append(separator);
        }
        return string.toString();
    }

    public static String mapAsJson(Map<String, String> map) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                obj.put(entry.getKey(), entry.getValue());
            }
            catch (JSONException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return obj.toString();
    }

    public static <K, V> String mapAsString(Map<K, V> map, String sepItem, String sepKeyval) {
        StringBuffer string = new StringBuffer(128);
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            string.append(entry.getKey());
            string.append(sepKeyval);
            string.append(entry.getValue());
            if (!it.hasNext()) continue;
            string.append(sepItem);
        }
        return string.toString();
    }

    public static String padLeft(String input, int size) {
        return new PrintfFormat("%" + size + "s").sprintf(input);
    }

    public static String padRight(String input, int size) {
        return new PrintfFormat("%-" + size + "s").sprintf(input);
    }

    public static final long parseDuration(String durationStr, long defaultValue) {
        durationStr = durationStr.toLowerCase().trim();
        Matcher matcher = DURATION_NUMBER_AND_UNIT_PATTERN.matcher(durationStr);
        long millis = 0L;
        boolean matched = false;
        while (matcher.find()) {
            long number = Long.valueOf(matcher.group(1));
            String unit = matcher.group(2);
            long multiplier = 0L;
            for (int j = 0; j < DURATION_UNTIS.length; ++j) {
                if (!unit.equals(DURATION_UNTIS[j])) continue;
                multiplier = DURATION_MULTIPLIERS[j];
                break;
            }
            if (multiplier == 0L) {
                LOG.warn((Object)("parseDuration: Unknown unit " + unit));
            } else {
                matched = true;
            }
            millis += number * multiplier;
        }
        if (!matched) {
            millis = defaultValue;
        }
        return millis;
    }

    public static StringTemplateGroup readStringTemplateGroup(InputStream stream) {
        try {
            return new StringTemplateGroup((Reader)new InputStreamReader(stream, "UTF-8"), DefaultTemplateLexer.class, new StringTemplateErrorListener(){

                public void error(String arg0, Throwable arg1) {
                    LOG.error((Object)(arg0 + ": " + arg1.getMessage()), arg1);
                }

                public void warning(String arg0) {
                    LOG.warn((Object)arg0);
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new StringTemplateGroup("dummy");
        }
    }

    public static Optional<String> removePrefixPath(String prefix, String path) {
        prefix = CmsFileUtil.addTrailingSeparator(prefix);
        if ((path = CmsFileUtil.addTrailingSeparator(path)).startsWith(prefix)) {
            String result = path.substring(prefix.length() - 1);
            if (result.length() > 1) {
                result = CmsFileUtil.removeTrailingSeparator(result);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static com.google.common.base.Optional<String> replacePrefix(String text, String origPrefix, String newPrefix, boolean ignoreCase) {
        String prefixTestString = ignoreCase ? text.toLowerCase() : text;
        String string = origPrefix = ignoreCase ? origPrefix.toLowerCase() : origPrefix;
        if (prefixTestString.startsWith(origPrefix)) {
            return com.google.common.base.Optional.of((Object)(newPrefix + text.substring(origPrefix.length())));
        }
        return com.google.common.base.Optional.absent();
    }

    public static String[] splitAsArray(String source, char delimiter) {
        List<String> result = CmsStringUtil.splitAsList(source, delimiter);
        return result.toArray(new String[result.size()]);
    }

    public static String[] splitAsArray(String source, String delimiter) {
        List<String> result = CmsStringUtil.splitAsList(source, delimiter);
        return result.toArray(new String[result.size()]);
    }

    public static List<String> splitAsList(String source, char delimiter) {
        return CmsStringUtil.splitAsList(source, delimiter, false);
    }

    public static List<String> splitAsList(String source, char delimiter, boolean trim) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int l = source.length();
        int n = source.indexOf(delimiter);
        while (n != -1) {
            if (i < n || i > 0 && i < l) {
                result.add(trim ? source.substring(i, n).trim() : source.substring(i, n));
            }
            i = n + 1;
            n = source.indexOf(delimiter, i);
        }
        if (n < 0) {
            n = source.length();
        }
        if (i < n) {
            result.add(trim ? source.substring(i).trim() : source.substring(i));
        }
        return result;
    }

    public static List<String> splitAsList(String source, String delimiter) {
        return CmsStringUtil.splitAsList(source, delimiter, false);
    }

    public static List<String> splitAsList(String source, String delimiter, boolean trim) {
        int dl = delimiter.length();
        if (dl == 1) {
            return CmsStringUtil.splitAsList(source, delimiter.charAt(0), trim);
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int l = source.length();
        int n = source.indexOf(delimiter);
        while (n != -1) {
            if (i < n || i > 0 && i < l) {
                result.add(trim ? source.substring(i, n).trim() : source.substring(i, n));
            }
            i = n + dl;
            n = source.indexOf(delimiter, i);
        }
        if (n < 0) {
            n = source.length();
        }
        if (i < n) {
            result.add(trim ? source.substring(i).trim() : source.substring(i));
        }
        return result;
    }

    public static Map<String, String> splitAsMap(String source, String paramDelim, String keyValDelim) {
        int keyValLen = keyValDelim.length();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (String param : CmsStringUtil.splitAsList(source, paramDelim, true)) {
            int pos = param.indexOf(keyValDelim);
            String key = param;
            String value = "";
            if (pos > 0) {
                key = param.substring(0, pos);
                if (pos + keyValLen < param.length()) {
                    value = param.substring(pos + keyValLen);
                }
            }
            params.put(key, value);
        }
        return params;
    }

    public static Map<String, String> splitOptions(String optionsStr) {
        boolean S_KEY = false;
        boolean S_VALUE = true;
        int S_KEY_ESC = 2;
        int S_VALUE_ESC = 3;
        boolean nextEntry = false;
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int length = optionsStr.length();
        int state = 0;
        for (int i = 0; i < length + 1; ++i) {
            String value;
            nextEntry = false;
            char ch = '\u0000';
            if (i < length) {
                ch = optionsStr.charAt(i);
            }
            switch (state) {
                case 0: {
                    if (ch == '|' || ch == '\u0000') {
                        nextEntry = true;
                        valueBuffer = null;
                        state = 0;
                        break;
                    }
                    if (ch == '\\') {
                        state = 2;
                        break;
                    }
                    if (ch == ':') {
                        state = 1;
                        break;
                    }
                    keyBuffer.append(ch);
                    break;
                }
                case 2: {
                    if (ch == '\u0000') {
                        nextEntry = true;
                        valueBuffer = null;
                        break;
                    }
                    keyBuffer.append(ch);
                    state = 0;
                    break;
                }
                case 1: {
                    if (ch == '|' || ch == '\u0000') {
                        nextEntry = true;
                        state = 0;
                        break;
                    }
                    if (ch == '\\') {
                        state = 3;
                        break;
                    }
                    if (valueBuffer == null) break;
                    valueBuffer.append(ch);
                    break;
                }
                case 3: {
                    if (ch == '\u0000') {
                        nextEntry = true;
                        state = 0;
                        break;
                    }
                    if (valueBuffer != null) {
                        valueBuffer.append(ch);
                    }
                    state = 1;
                    break;
                }
            }
            if (!nextEntry) continue;
            nextEntry = false;
            String key = keyBuffer.toString();
            key = key.replaceFirst("^\\s+", "");
            if (valueBuffer != null) {
                value = valueBuffer.toString();
                value = value.replaceFirst("\\s+$", "");
            } else {
                value = "";
                key = key.replaceFirst("\\s+$", "");
            }
            if (key.length() > 0) {
                result.put(key, value);
            }
            keyBuffer = new StringBuilder();
            valueBuffer = new StringBuilder();
        }
        return result;
    }

    public static String substitute(Pattern pattern, String text, I_CmsRegexSubstitution sub) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, sub.substituteMatch(text, matcher));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String substitute(String source, Map<String, String> substitions) {
        String result = source;
        for (Map.Entry<String, String> entry : substitions.entrySet()) {
            result = CmsStringUtil.substitute(result, entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public static String substitute(String source, String searchString, String replaceString) {
        int length;
        int rl;
        if (source == null) {
            return null;
        }
        if (CmsStringUtil.isEmpty(searchString)) {
            return source;
        }
        if (replaceString == null) {
            replaceString = "";
        }
        int len = source.length();
        int sl = searchString.length();
        if (sl == (rl = replaceString.length())) {
            length = len;
        } else {
            int e;
            int c = 0;
            int s = 0;
            while ((e = source.indexOf(searchString, s)) != -1) {
                ++c;
                s = e + sl;
            }
            if (c == 0) {
                return source;
            }
            length = len - c * (sl - rl);
        }
        int s = 0;
        int e = source.indexOf(searchString, s);
        if (e == -1) {
            return source;
        }
        StringBuffer sb = new StringBuffer(length);
        while (e != -1) {
            sb.append(source.substring(s, e));
            sb.append(replaceString);
            s = e + sl;
            e = source.indexOf(searchString, s);
        }
        e = len;
        sb.append(source.substring(s, e));
        return sb.toString();
    }

    public static String substituteContextPath(String htmlContent, String context) {
        if (m_contextSearch == null) {
            m_contextSearch = "([^\\w/])" + context;
            m_contextReplace = "$1" + CmsStringUtil.escapePattern(MACRO_OPENCMS_CONTEXT) + "/";
        }
        return CmsStringUtil.substitutePerl(htmlContent, m_contextSearch, m_contextReplace, "g");
    }

    public static String substitutePerl(String content, String searchString, String replaceItem, String occurences) {
        String translationRule = "s#" + searchString + "#" + replaceItem + "#" + occurences;
        Perl5Util perlUtil = new Perl5Util();
        try {
            return perlUtil.substitute(translationRule, content);
        }
        catch (MalformedPerl5PatternException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MALFORMED_TRANSLATION_RULE_1", translationRule), (Throwable)e);
            }
            return content;
        }
    }

    public static String toUnicodeLiteral(String s) {
        StringBuffer result = new StringBuffer();
        char[] carr = s.toCharArray();
        for (int i = 0; i < carr.length; ++i) {
            result.append("\\u");
            String unicode = Integer.toHexString(carr[i]).toUpperCase();
            for (int j = 4 - unicode.length(); j > 0; --j) {
                result.append("0");
            }
            result.append(unicode);
        }
        return result.toString();
    }

    public static String transformValues(String oldFormat, String newFormat, String value) {
        String part;
        if (!(oldFormat.contains(PLACEHOLDER_START) && oldFormat.contains(PLACEHOLDER_END) && newFormat.contains(PLACEHOLDER_START) && newFormat.contains(PLACEHOLDER_END))) {
            return newFormat;
        }
        ArrayList<Integer> oldValues = new ArrayList<Integer>();
        ArrayList<Integer> newValues = new ArrayList<Integer>();
        int oldNumber = 0;
        try {
            int counter = 0;
            Pattern pattern = Pattern.compile("\\{\\.\\*\\}");
            Matcher matcher = pattern.matcher(oldFormat);
            while (matcher.find()) {
                ++counter;
            }
            oldValues = new ArrayList(counter);
            matcher = pattern.matcher(oldFormat);
            while (matcher.find()) {
                int start = matcher.start() + 1;
                oldValues.add(oldNumber, start);
                ++oldNumber;
            }
        }
        catch (PatternSyntaxException counter) {
            // empty catch block
        }
        int newNumber = 0;
        try {
            int counter = 0;
            Pattern pattern = Pattern.compile("\\{\\}");
            Matcher matcher = pattern.matcher(newFormat);
            while (matcher.find()) {
                ++counter;
            }
            newValues = new ArrayList(counter);
            matcher = pattern.matcher(newFormat);
            while (matcher.find()) {
                int start = matcher.start() + 1;
                newValues.add(newNumber, start);
                ++newNumber;
            }
        }
        catch (PatternSyntaxException counter) {
            // empty catch block
        }
        if (oldNumber != newNumber) {
            return newFormat;
        }
        ArrayList<String> oldBetween = new ArrayList<String>(oldNumber + 1);
        ArrayList<String> newBetween = new ArrayList<String>(newNumber + 1);
        int counter = 0;
        Iterator iter = oldValues.iterator();
        while (iter.hasNext()) {
            int start = (Integer)iter.next();
            if (counter == 0) {
                if (start == 1) {
                    oldBetween.add(counter, "");
                } else {
                    part = oldFormat.substring(0, start - 1);
                    oldBetween.add(counter, part);
                }
            } else {
                int lastStart = (Integer)oldValues.get(counter - 1);
                String part2 = oldFormat.substring(lastStart + 3, start - 1);
                oldBetween.add(counter, part2);
            }
            ++counter;
        }
        int lastElstart = (Integer)oldValues.get(counter - 1);
        if (lastElstart + 2 == oldFormat.length() - 1) {
            oldBetween.add(counter, "");
        } else {
            part = oldFormat.substring(lastElstart + 3);
            oldBetween.add(counter, part);
        }
        counter = 0;
        iter = newValues.iterator();
        while (iter.hasNext()) {
            int start = (Integer)iter.next();
            if (counter == 0) {
                if (start == 1) {
                    newBetween.add(counter, "");
                } else {
                    String part3 = newFormat.substring(0, start - 1);
                    newBetween.add(counter, part3);
                }
            } else {
                int lastStart = (Integer)newValues.get(counter - 1);
                String part4 = newFormat.substring(lastStart + 1, start - 1);
                newBetween.add(counter, part4);
            }
            ++counter;
        }
        lastElstart = (Integer)newValues.get(counter - 1);
        if (lastElstart + 2 == newFormat.length() - 1) {
            newBetween.add(counter, "");
        } else {
            String part5 = newFormat.substring(lastElstart + 1);
            newBetween.add(counter, part5);
        }
        ArrayList<String> placeHolders = new ArrayList<String>(oldNumber);
        String tmpValue = value;
        for (int placeCounter = 0; placeCounter < oldBetween.size() - 1; ++placeCounter) {
            String content = (String)oldBetween.get(placeCounter);
            String nextContent = (String)oldBetween.get(placeCounter + 1);
            int contPos = 0;
            int nextContPos = 0;
            contPos = placeCounter == 0 && CmsStringUtil.isEmpty(content) ? 0 : tmpValue.indexOf(content);
            nextContPos = placeCounter + 1 == oldBetween.size() - 1 && CmsStringUtil.isEmpty(nextContent) ? tmpValue.length() : tmpValue.indexOf(nextContent);
            if (contPos < 0 || nextContPos < 0) {
                return value;
            }
            String placeContent = tmpValue.substring(contPos + content.length(), nextContPos);
            placeHolders.add(placeCounter, placeContent);
            tmpValue = tmpValue.substring(nextContPos);
        }
        Object newValue = "";
        for (int buildCounter = 0; buildCounter < newNumber; ++buildCounter) {
            newValue = (String)newValue + (String)newBetween.get(buildCounter) + (String)placeHolders.get(buildCounter);
        }
        newValue = (String)newValue + (String)newBetween.get(newNumber);
        return newValue;
    }

    public static String translatePathComponents(CmsResourceTranslator translator, String path) {
        String result = CmsStringUtil.substitute(NOT_SLASHES, path, (String text, Matcher matcher) -> translator.translateResource(matcher.group()));
        return result;
    }

    public static String trimToSize(String source, int length) {
        return CmsStringUtil.trimToSize(source, length, length, " ...");
    }

    public static String trimToSize(String source, int length, int area, String suffix) {
        String findPointSource;
        int pos;
        int modLength;
        if (source == null || source.length() <= length) {
            return source;
        }
        if (CmsStringUtil.isEmpty(suffix)) {
            suffix = "";
        }
        if ((modLength = length - suffix.length()) <= 0) {
            return suffix.substring(0, length);
        }
        int modArea = area + suffix.length();
        if (modArea > modLength || modArea < 0) {
            modArea = modLength;
        }
        String result = (pos = CmsStringUtil.lastIndexOf(findPointSource = source.substring(modLength - modArea, modLength), SENTENCE_ENDING_CHARS)) >= 0 ? source.substring(0, modLength - modArea + pos + 1) + suffix : ((pos = CmsStringUtil.lastWhitespaceIn(findPointSource)) >= 0 ? source.substring(0, modLength - modArea + pos) + suffix : source.substring(0, modLength) + suffix);
        return result;
    }

    public static String trimToSize(String source, int length, String suffix) {
        int area = length > 100 ? length / 2 : length;
        return CmsStringUtil.trimToSize(source, length, area, suffix);
    }

    public static boolean validateRegex(String value, String regex, boolean allowEmpty) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            return allowEmpty;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    static {
        XML_ENCODING_REGEX = Pattern.compile("encoding\\s*=\\s*[\"'].+[\"']", 2);
        XML_HEAD_REGEX = Pattern.compile("<\\s*\\?.*\\?\\s*>", 2);
        NOT_SLASHES = Pattern.compile("[^/]+");
    }

    public static class CmsSlashComparator
    implements Comparator<String> {
        @Override
        public int compare(String a, String b) {
            int slashCountB;
            int slashCountA = CmsStringUtil.countChar(a, '/');
            if (slashCountA < (slashCountB = CmsStringUtil.countChar(b, '/'))) {
                return 1;
            }
            if (slashCountA == slashCountB) {
                return a.compareTo(b);
            }
            return -1;
        }
    }
}

