/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;

public class CmsWaitHandle {
    private static final Log LOG = CmsLog.getLog(CmsWaitHandle.class);
    private boolean m_released;
    private boolean m_singleUse;

    public CmsWaitHandle() {
        this.m_singleUse = false;
    }

    public CmsWaitHandle(boolean singleUse) {
        this.m_singleUse = singleUse;
    }

    public synchronized void enter(long waitTime) {
        if (this.m_singleUse && this.m_released) {
            return;
        }
        try {
            this.wait(waitTime);
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public synchronized void release() {
        this.notifyAll();
        this.m_released = true;
    }
}

