/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.repository.CmsPropertyName;
import org.opencms.repository.I_CmsRepositoryItem;
import org.opencms.repository.I_CmsRepositorySession;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.webdav.CmsDavInputContext;
import org.opencms.webdav.CmsDavResourceFactory;
import org.opencms.webdav.CmsDavSession;
import org.opencms.webdav.CmsDavUtil;

public class CmsDavResource
implements DavResource {
    private static final Log LOG = CmsLog.getLog(CmsDavResource.class);
    private CmsDavResourceFactory m_factory;
    private DavResourceLocator m_locator;
    private CmsDavSession m_session;
    private Optional<I_CmsRepositoryItem> m_item;
    private LockManager m_lockManager;

    public CmsDavResource(DavResourceLocator loc, CmsDavResourceFactory factory, CmsDavSession session, LockManager lockManager) {
        this.m_factory = factory;
        this.m_locator = loc;
        this.m_session = session;
        this.m_lockManager = lockManager;
    }

    public void addLockManager(LockManager lockmgr) {
        this.m_lockManager = lockmgr;
    }

    public void addMember(DavResource dres, InputContext inputContext) throws DavException {
        I_CmsRepositorySession session = this.getRepositorySession();
        String childPath = ((CmsDavResource)dres).getCmsPath();
        String method = ((CmsDavInputContext)inputContext).getMethod();
        InputStream stream = inputContext.getInputStream();
        if (method.equals("MKCOL") && stream != null) {
            throw new DavException(415);
        }
        if (dres.exists() && this.isLocked(dres)) {
            throw new DavException(423);
        }
        try {
            if (stream != null) {
                session.save(childPath, stream, true);
            } else {
                session.create(childPath);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new DavException(CmsDavUtil.getStatusForException(e), (Throwable)e);
        }
        catch (Exception e) {
            throw new DavException(500);
        }
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        int status;
        MultiStatusResponse res;
        block8: {
            if (this.exists() && this.isLocked(this)) {
                throw new DavException(423);
            }
            res = new MultiStatusResponse(this.getHref(), null);
            HashMap<CmsPropertyName, String> propMap = new HashMap<CmsPropertyName, String>();
            for (PropEntry propEntry : changeList) {
                if (propEntry instanceof DefaultDavProperty) {
                    DefaultDavProperty defaultDavProperty = (DefaultDavProperty)propEntry;
                    CmsPropertyName cmsPropName = new CmsPropertyName(defaultDavProperty.getName().getNamespace().getURI(), defaultDavProperty.getName().getName());
                    propMap.put(cmsPropName, (String)defaultDavProperty.getValue());
                    continue;
                }
                if (!(propEntry instanceof DavPropertyName)) continue;
                CmsPropertyName cmsPropertyName = new CmsPropertyName(((DavPropertyName)propEntry).getNamespace().getURI(), ((DavPropertyName)propEntry).getName());
                propMap.put(cmsPropertyName, "");
            }
            status = 200;
            try {
                this.getRepositorySession().updateProperties(this.getCmsPath(), propMap);
            }
            catch (CmsException cmsException) {
                LOG.warn((Object)cmsException.getLocalizedMessage(), (Throwable)cmsException);
                if (!(cmsException instanceof CmsPermissionViolationException)) break block8;
                status = 403;
            }
        }
        for (PropEntry propEntry : changeList) {
            if (propEntry instanceof DavPropertyName) {
                res.add((DavPropertyName)propEntry, status);
                continue;
            }
            if (propEntry instanceof DefaultDavProperty) {
                res.add((DavProperty)propEntry, status);
                continue;
            }
            res.add((DavPropertyName)propEntry, 403);
        }
        return res;
    }

    public void copy(DavResource dres, boolean shallow) throws DavException {
        CmsDavResource other = (CmsDavResource)dres;
        boolean targetParentExists = false;
        try {
            targetParentExists = dres.getCollection().exists();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (!targetParentExists) {
            throw new DavException(409);
        }
        try {
            this.getRepositorySession().copy(this.getCmsPath(), other.getCmsPath(), true, shallow);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new DavException(CmsDavUtil.getStatusForException(e));
        }
    }

    public void delete() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            this.getRepositorySession().delete(this.getCmsPath());
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new DavException(CmsDavUtil.getStatusForException(e), (Throwable)e);
        }
    }

    public boolean exists() {
        return this.getItem() != null;
    }

    public DavResource getCollection() {
        DavResourceLocator locator = this.m_locator.getFactory().createResourceLocator(this.m_locator.getPrefix(), this.m_locator.getWorkspacePath(), CmsResource.getParentFolder(this.m_locator.getResourcePath()));
        try {
            return this.m_factory.createResource(locator, this.m_session);
        }
        catch (DavException e) {
            return null;
        }
    }

    public String getComplianceClass() {
        return DavCompliance.concatComplianceClasses((String[])new String[]{"1", "2"});
    }

    public String getDisplayName() {
        String result = CmsResource.getName(this.getCmsPath());
        result = result.replace("/", "");
        return result;
    }

    public DavResourceFactory getFactory() {
        return this.m_factory;
    }

    public String getHref() {
        String href = this.m_locator.getHref(true);
        String result = CmsFileUtil.removeTrailingSeparator(href);
        return result;
    }

    public DavResourceLocator getLocator() {
        return this.m_locator;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return this.m_lockManager.getLock(type, scope, (DavResource)this);
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public DavResourceIterator getMembers() {
        I_CmsRepositorySession session = this.getRepositorySession();
        try {
            List<I_CmsRepositoryItem> children = session.list(this.getCmsPath());
            List childDavRes = children.stream().map(child -> {
                String childPath = CmsStringUtil.joinPaths(this.m_locator.getWorkspacePath(), child.getName());
                DavResourceLocator childLocator = this.m_locator.getFactory().createResourceLocator(this.m_locator.getPrefix(), this.m_locator.getWorkspacePath(), childPath);
                return new CmsDavResource(childLocator, this.m_factory, this.m_session, this.m_lockManager);
            }).filter(child -> {
                boolean exists = child.exists();
                if (!exists) {
                    LOG.warn((Object)("Invalid child resource: " + child.getLocator().getPrefix() + ":" + child.getLocator().getResourcePath()));
                }
                return exists;
            }).collect(Collectors.toList());
            return new DavResourceIteratorImpl(childDavRes);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public long getModificationTime() {
        I_CmsRepositoryItem item = this.getItem();
        return item.getLastModifiedDate();
    }

    public DavPropertySet getProperties() {
        DavPropertySet result = new DavPropertySet();
        ResourceType typeProp = new ResourceType(this.isCollection() ? 1 : 0);
        result.add((DavProperty)typeProp);
        result.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)CmsDavUtil.DATE_FORMAT.format(new Date(this.getItem().getLastModifiedDate()))));
        result.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getItem().getName()));
        if (!this.isCollection()) {
            result.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)("" + this.getItem().getContentLength())));
            result.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)this.getETag()));
        }
        try {
            Map<CmsPropertyName, String> cmsProps = this.getRepositorySession().getProperties(this.getCmsPath());
            for (Map.Entry<CmsPropertyName, String> entry : cmsProps.entrySet()) {
                CmsPropertyName propName = entry.getKey();
                DavPropertyName name = DavPropertyName.create((String)propName.getName(), (Namespace)Namespace.getNamespace((String)propName.getNamespace()));
                result.add((DavProperty)new DefaultDavProperty(name, (Object)entry.getValue()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public DavProperty<?> getProperty(DavPropertyName name) {
        return this.getProperties().get(name);
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public String getResourcePath() {
        return this.m_locator.getResourcePath();
    }

    public DavSession getSession() {
        return this.m_session;
    }

    public String getSupportedMethods() {
        TreeSet<String> methods = new TreeSet<String>();
        I_CmsRepositoryItem item = this.getItem();
        if (item == null) {
            methods.addAll(Arrays.asList("OPTIONS", "PUT", "MKCOL"));
            methods.add("LOCK");
        } else {
            methods.addAll(Arrays.asList("OPTIONS", "HEAD", "POST", "DELETE"));
            methods.add("PROPFIND");
            methods.add("PROPPATCH");
            Arrays.asList("COPY", "MOVE");
            if (!item.isCollection()) {
                methods.add("PUT");
            }
        }
        return CmsStringUtil.listAsString(new ArrayList(methods), ", ");
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.m_lockManager.getLock(type, scope, (DavResource)this) != null;
    }

    public boolean isCollection() {
        I_CmsRepositoryItem item = this.getItem();
        return item != null && item.isCollection();
    }

    public boolean isLockable(Type type, Scope scope) {
        return false;
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        return this.m_lockManager.createLock(reqLockInfo, (DavResource)this);
    }

    public void move(DavResource destination) throws DavException {
        CmsDavResource other = (CmsDavResource)destination;
        if (this.isLocked(this)) {
            throw new DavException(423);
        }
        try {
            this.getRepositorySession().move(this.getCmsPath(), other.getCmsPath(), true);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new DavException(CmsDavUtil.getStatusForException(e));
        }
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        return this.m_lockManager.refreshLock(reqLockInfo, lockToken, (DavResource)this);
    }

    public void removeMember(DavResource member) throws DavException {
        if (this.isLocked(this) || this.isLocked(member)) {
            throw new DavException(423);
        }
        ((CmsDavResource)member).delete();
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        if (this.exists() && this.isLocked(this)) {
            throw new DavException(423);
        }
        I_CmsRepositorySession session = this.getRepositorySession();
        HashMap<CmsPropertyName, String> props = new HashMap<CmsPropertyName, String>();
        CmsPropertyName key = new CmsPropertyName(propertyName.getNamespace().getURI(), propertyName.getName());
        props.put(key, "");
        try {
            session.updateProperties(this.getCmsPath(), props);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new DavException(500);
        }
    }

    public void setProperty(DavProperty<?> property) throws DavException {
        if (this.exists() && this.isLocked(this)) {
            throw new DavException(423);
        }
        if (!(property instanceof DefaultDavProperty)) {
            throw new DavException(403);
        }
        I_CmsRepositorySession session = this.getRepositorySession();
        HashMap<CmsPropertyName, String> props = new HashMap<CmsPropertyName, String>();
        DavPropertyName propertyName = property.getName();
        String newValue = (String)((DefaultDavProperty)property).getValue();
        if (newValue == null) {
            newValue = "";
        }
        CmsPropertyName key = new CmsPropertyName(propertyName.getNamespace().getURI(), propertyName.getName());
        props.put(key, newValue);
        try {
            session.updateProperties(this.getCmsPath(), props);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new DavException(500);
        }
    }

    public void spool(OutputContext outputContext) throws IOException {
        I_CmsRepositoryItem item = this.getItem();
        outputContext.setContentType(item.getMimeType());
        outputContext.setContentLength(item.getContentLength());
        outputContext.setModificationTime(item.getLastModifiedDate());
        outputContext.setETag(this.getETag());
        OutputStream out = outputContext.getOutputStream();
        if (out != null) {
            out.write(item.getContent());
        }
    }

    public void unlock(String lockToken) throws DavException {
        this.m_lockManager.releaseLock(lockToken, (DavResource)this);
    }

    private String getCmsPath() {
        String path = this.m_locator.getResourcePath();
        String workspace = this.m_locator.getWorkspacePath();
        Optional<String> remainingPath = CmsStringUtil.removePrefixPath(workspace, path);
        return remainingPath.orElse(null);
    }

    private String getETag() {
        return "\"" + this.getItem().getContentLength() + "-" + this.getItem().getLastModifiedDate() + "\"";
    }

    private I_CmsRepositoryItem getItem() {
        if (this.m_item == null) {
            try {
                I_CmsRepositoryItem item = this.getRepositorySession().getItem(this.getCmsPath());
                this.m_item = Optional.of(item);
            }
            catch (Exception e) {
                String messageKey;
                CmsMessageContainer messageContainer;
                boolean isFiltered = false;
                if (e instanceof CmsException && (messageContainer = ((CmsException)e).getMessageContainer()) != null && "ERR_ITEM_FILTERED_1".equals(messageKey = messageContainer.getKey())) {
                    isFiltered = true;
                }
                if (e instanceof CmsVfsResourceNotFoundException) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                } else if (isFiltered) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                } else {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                this.m_item = Optional.empty();
            }
        }
        return this.m_item.orElse(null);
    }

    private I_CmsRepositorySession getRepositorySession() {
        return this.m_session.getRepositorySession();
    }

    private boolean isLocked(DavResource res) {
        ActiveLock lock = res.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            return false;
        }
        for (String sLockToken : this.m_session.getLockTokens()) {
            if (!sLockToken.equals(lock.getToken())) continue;
            return false;
        }
        return true;
    }
}

