/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.I_CmsAutoBeanFactory;
import org.opencms.gwt.shared.I_CmsCodeMirrorClientConfiguration;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsCodeWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    private static final Log LOG = CmsLog.getLog(CmsCodeWidget.class);
    private static I_CmsAutoBeanFactory m_configFactory = (I_CmsAutoBeanFactory)AutoBeanFactorySource.create(I_CmsAutoBeanFactory.class);

    public CmsCodeWidget() {
        this("{}");
    }

    public CmsCodeWidget(String configuration) {
        this.setConfiguration(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue contentValue, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        try {
            JSONObject serverConfig = new JSONObject();
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.getConfiguration())) {
                try {
                    serverConfig = new JSONObject(this.getConfiguration());
                }
                catch (JSONException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String mode = serverConfig.optString("mode", "html");
            String heightStr = serverConfig.optString("height");
            Integer height = null;
            if (heightStr != null && !"none".equals(heightStr)) {
                try {
                    height = Integer.valueOf(heightStr);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            AutoBean<I_CmsCodeMirrorClientConfiguration> clientConfig = m_configFactory.createConfiguration();
            Locale userLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            ((I_CmsCodeMirrorClientConfiguration)clientConfig.as()).setPhrasesJSON(this.getPhrases(userLocale));
            ((I_CmsCodeMirrorClientConfiguration)clientConfig.as()).setHeight(height);
            ((I_CmsCodeMirrorClientConfiguration)clientConfig.as()).setStartMode(mode);
            String clientConfigJsonString = AutoBeanCodex.encode(clientConfig).getPayload();
            return clientConfigJsonString;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return "{}";
        }
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.wide;
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        return null;
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsCodeWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsCodeWidget(this.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPhrases(Locale userLocale) {
        String string;
        InputStream stream = null;
        stream = this.getClass().getResourceAsStream("codemirror_phrases_" + userLocale.getLanguage() + ".json");
        if (stream == null) return "{}";
        try {
            byte[] data = CmsFileUtil.readFully(stream, false);
            String result = new String(data, StandardCharsets.UTF_8);
            JSONObject dummy = new JSONObject(result);
            string = result;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return "{}";
            }
        }
        stream.close();
        return string;
    }
}

