/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsElementViewSelectWidget
extends CmsSelectWidget {
    @Override
    public I_CmsWidget newInstance() {
        return new CmsElementViewSelectWidget();
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        ArrayList<CmsSelectWidgetOption> options = new ArrayList<CmsSelectWidgetOption>();
        String myPath = this.getResourcePath(cms, widgetDialog);
        Map<CmsUUID, CmsElementView> views = OpenCms.getADEManager().getElementViews(cms);
        for (CmsElementView view : views.values()) {
            if (this.shouldIgnore(view, views, myPath)) continue;
            Object value = "";
            if (view.getResource() != null) {
                value = cms.getSitePath(view.getResource());
            } else if (view.getId() != null && !view.getId().isNullUUID()) {
                value = "view://" + view.getId();
            }
            options.add(new CmsSelectWidgetOption((String)value, false, view.getTitle(cms, widgetDialog.getLocale())));
        }
        if (this.isSelectParent()) {
            options.add(new CmsSelectWidgetOption("view://null", true, "--"));
        }
        return options;
    }

    private boolean isSelectParent() {
        return this.getConfiguration() != null && this.getConfiguration().contains("selectparent");
    }

    private boolean shouldIgnore(CmsElementView view, Map<CmsUUID, CmsElementView> views, String myPath) {
        if (this.isSelectParent()) {
            boolean isStandardView;
            for (CmsElementView otherView : views.values()) {
                CmsElementView parentOfOther;
                CmsUUID parentViewId = otherView.getParentViewId();
                if (parentViewId == null || (parentOfOther = views.get(parentViewId)) == null || parentOfOther.getResource() == null || !parentOfOther.getResource().getRootPath().equals(myPath)) continue;
                return true;
            }
            boolean bl = isStandardView = view.getResource() != null || view.getId().isNullUUID();
            if (view.getParentViewId() != null || !isStandardView) {
                return true;
            }
            if (view.getResource() != null && view.getResource().getRootPath().equals(myPath)) {
                return true;
            }
        }
        return false;
    }
}

