/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsGalleryWidgetDynamicConfiguration;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsGalleryWidgetConfiguration {
    public static final String CONFIG_KEY_CLASS = "class";
    public static final String CONFIG_KEY_GALLERYTYPES = "gallerytypes";
    public static final String CONFIG_KEY_STARTUP = "startup";
    public static final String CONFIG_KEY_TYPE = "type";
    public static final String CONFIG_VALUE_DYNAMIC = "dynamic";
    protected String m_className;
    protected String m_startup;
    protected String m_type;
    private String m_galleryTypes;

    public CmsGalleryWidgetConfiguration(CmsObject cms, CmsMessages widgetDialog, I_CmsWidgetParameter param, String configuration) {
        this.init(cms, widgetDialog, param, configuration);
    }

    protected CmsGalleryWidgetConfiguration() {
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getGalleryTypes() {
        return this.m_galleryTypes;
    }

    public String getStartup() {
        return this.m_startup;
    }

    public String getType() {
        return this.m_type;
    }

    protected void init(CmsObject cms, CmsMessages messages, I_CmsWidgetParameter param, String configuration) {
        if (configuration == null) {
            return;
        }
        configuration = CmsMacroResolver.resolveMacros(configuration, cms, messages);
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj = new JSONObject(configuration);
        }
        catch (JSONException e) {
            return;
        }
        this.setClassName(jsonObj.optString(CONFIG_KEY_CLASS, null));
        I_CmsGalleryWidgetDynamicConfiguration dynConf = null;
        if (this.getClassName() != null) {
            try {
                dynConf = (I_CmsGalleryWidgetDynamicConfiguration)Class.forName(this.getClassName()).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setType(jsonObj.optString(CONFIG_KEY_TYPE));
        if ((CONFIG_VALUE_DYNAMIC.equals(this.getType()) || CmsStringUtil.isEmpty(this.getType())) && dynConf != null) {
            this.setType(dynConf.getType(cms, messages, param));
        }
        this.setGalleryTypes(jsonObj.optString(CONFIG_KEY_GALLERYTYPES, null));
        this.setStartup(jsonObj.optString(CONFIG_KEY_STARTUP));
        if ((CONFIG_VALUE_DYNAMIC.equals(this.getStartup()) || CmsStringUtil.isEmpty(this.getStartup())) && dynConf != null) {
            this.setStartup(dynConf.getStartup(cms, messages, param));
        }
    }

    protected void setClassName(String className) {
        this.m_className = className;
    }

    protected void setGalleryTypes(String galleryTypes) {
        this.m_galleryTypes = galleryTypes;
    }

    protected void setStartup(String startup) {
        this.m_startup = startup;
    }

    protected void setType(String type) {
        this.m_type = type;
    }

    public String getConfigString() {
        Object result = "";
        if (this.m_startup != null) {
            result = (String)result + "&startup=" + this.m_startup;
        }
        if (this.m_type != null) {
            result = (String)result + "&type=" + this.m_type;
        }
        return result;
    }
}

