/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsInputWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    public static final String CONF_AUTO_TYPOGRAPHY = "auto-typography";
    public static final String CONF_TYPOGRAPHY = "typography";
    private static final Log LOG = CmsLog.getLog(CmsInputWidget.class);

    public CmsInputWidget() {
        this("");
    }

    public CmsInputWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        String configStr = this.getConfiguration();
        if (configStr == null) {
            configStr = "";
        }
        String[] tokens = configStr.split("\\|");
        JSONObject json = new JSONObject();
        String typografLocale = CmsTextareaWidget.getTypografLocale(contentLocale);
        for (String token : tokens) {
            if (!Arrays.asList(CONF_TYPOGRAPHY, CONF_AUTO_TYPOGRAPHY).contains(token)) continue;
            try {
                json.put("typograf", CONF_AUTO_TYPOGRAPHY.equals(token) ? "auto" : "true");
                json.put("locale", typografLocale);
            }
            catch (Exception e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return json.toString();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.singleline;
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        result.append("<input class=\"xmlInput textInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\"");
        result.append(" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" value=\"");
        result.append(CmsEncoder.escapeXml(param.getStringValue(cms)));
        result.append("\">");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsInputWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsInputWidget(this.getConfiguration());
    }
}

