/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opencms.acacia.shared.CmsSerialDateUtil;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.I_CmsSerialDateBean;

public abstract class A_CmsSerialDateBean
implements I_CmsSerialDateBean {
    public static final int MAX_OCCURRENCES = 100;
    protected Calendar m_startDate;
    protected Calendar m_endDate;
    protected int m_occurrences;
    protected Calendar m_serialEndDate;
    protected long m_endMillis;
    protected I_CmsSerialDateValue.EndType m_endType = null;
    protected SortedSet<Date> m_dates;
    protected SortedSet<Date> m_allDates;
    protected SortedSet<Long> m_datesInMillis;
    protected final SortedSet<Date> m_exceptions = new TreeSet<Date>();
    private Boolean m_hasTooManyOccurrences;

    public A_CmsSerialDateBean(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions) {
        this.m_startDate = new GregorianCalendar();
        this.m_endDate = new GregorianCalendar();
        this.m_startDate.setTime(startDate);
        this.m_endDate.setTime(endDate == null ? startDate : endDate);
        if (isWholeDay) {
            this.m_startDate.set(11, 0);
            this.m_startDate.set(12, 0);
            this.m_startDate.set(13, 0);
            this.m_startDate.set(14, 0);
            this.m_endDate.set(11, 0);
            this.m_endDate.set(12, 0);
            this.m_endDate.set(13, 0);
            this.m_endDate.set(14, 0);
            this.m_endDate.add(5, 1);
        }
        this.m_endType = endType;
        switch (this.m_endType) {
            case DATE: {
                this.m_serialEndDate = new GregorianCalendar();
                this.m_serialEndDate.setTime(serialEndDate);
                GregorianCalendar dayAfterEnd = new GregorianCalendar(this.m_serialEndDate.get(1), this.m_serialEndDate.get(2), this.m_serialEndDate.get(5));
                ((Calendar)dayAfterEnd).add(5, 1);
                this.m_endMillis = dayAfterEnd.getTimeInMillis();
                break;
            }
            case TIMES: {
                this.m_occurrences = occurrences;
                break;
            }
            case SINGLE: {
                this.m_occurrences = 1;
                break;
            }
        }
        if (null != exceptions) {
            this.m_exceptions.addAll(exceptions);
        }
    }

    @Override
    public SortedSet<Date> getDates() {
        if (null == this.m_dates) {
            this.m_dates = this.filterExceptions(this.calculateDates());
        }
        return this.m_dates;
    }

    @Override
    public SortedSet<Long> getDatesAsLong() {
        if (null == this.m_datesInMillis) {
            SortedSet<Date> dates = this.getDates();
            this.m_datesInMillis = new TreeSet<Long>();
            for (Date d : dates) {
                this.m_datesInMillis.add(d.getTime());
            }
        }
        return this.m_datesInMillis;
    }

    @Override
    public Long getEventDuration() {
        return null != this.m_endDate && null != this.m_startDate ? Long.valueOf(this.m_endDate.getTimeInMillis() - this.m_startDate.getTimeInMillis()) : null;
    }

    @Override
    public SortedSet<Date> getExceptions() {
        return this.m_exceptions;
    }

    public int getOccurrences() {
        return Math.min(this.m_occurrences, CmsSerialDateUtil.getMaxEvents());
    }

    public Calendar getSerialEndDate() {
        return this.m_serialEndDate;
    }

    public I_CmsSerialDateValue.EndType getSerialEndType() {
        return this.m_endType;
    }

    public Calendar getStartDate() {
        return this.m_startDate;
    }

    @Override
    public boolean hasTooManyDates() {
        if (null == this.m_hasTooManyOccurrences) {
            switch (this.getSerialEndType()) {
                case SINGLE: {
                    this.m_hasTooManyOccurrences = Boolean.FALSE;
                    break;
                }
                case TIMES: {
                    this.m_hasTooManyOccurrences = this.m_occurrences > CmsSerialDateUtil.getMaxEvents();
                    break;
                }
                case DATE: {
                    this.m_hasTooManyOccurrences = Boolean.FALSE;
                    this.calculateDates();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return this.m_hasTooManyOccurrences;
    }

    protected abstract Calendar getFirstDate();

    protected abstract boolean isAnyDatePossible();

    protected boolean showMoreEntries(Calendar nextDate, int previousOccurrences) {
        switch (this.getSerialEndType()) {
            case DATE: {
                boolean moreByOccurrences;
                boolean moreByDate = nextDate.getTimeInMillis() < this.m_endMillis;
                boolean bl = moreByOccurrences = previousOccurrences < CmsSerialDateUtil.getMaxEvents();
                if (moreByDate && !moreByOccurrences) {
                    this.m_hasTooManyOccurrences = Boolean.TRUE;
                }
                return moreByDate && moreByOccurrences;
            }
            case TIMES: 
            case SINGLE: {
                return previousOccurrences < this.getOccurrences();
            }
        }
        throw new IllegalArgumentException();
    }

    protected abstract void toNextDate(Calendar var1);

    private SortedSet<Date> calculateDates() {
        if (null == this.m_allDates) {
            TreeSet<Date> result = new TreeSet<Date>();
            if (this.isAnyDatePossible()) {
                Calendar date = this.getFirstDate();
                int previousOccurrences = 0;
                while (this.showMoreEntries(date, previousOccurrences)) {
                    result.add(date.getTime());
                    this.toNextDate(date);
                    ++previousOccurrences;
                }
            }
            this.m_allDates = result;
        }
        return this.m_allDates;
    }

    private SortedSet<Date> filterExceptions(SortedSet<Date> dates) {
        TreeSet<Date> result = new TreeSet<Date>();
        for (Date d : dates) {
            if (this.m_exceptions.contains(d)) continue;
            result.add(d);
        }
        return result;
    }
}

